/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.HatchBoundaryLoop;
import org.kabeja.dxf.helpers.Point;

public class DXFHatch
extends DXFEntity {
    private String name = "";
    private boolean solid = false;
    private int associativityFlag = 0;
    private int boundaryPathCount = 0;
    private int hatchStyle = 0;
    private int patternType = 0;
    private double patternAngle = 0.0;
    private double patternScaleSpacing = 1.0;
    private boolean boundaryAnnotation = false;
    private boolean patternDouble = false;
    private int definationLinesCount = 0;
    private double pixelSize = 0.0;
    private int seedPointCount = 0;
    private double offsetVector = 0.0;
    private int degenerateBoundaryPathCount = 0;
    private boolean gradientHatch = false;
    private Point elevationPoint = new Point();
    private List boundaries = new ArrayList();
    private List patterns = new ArrayList();
    private String patternID = "";
    private double patternScale;

    public int getAssociativityFlag() {
        return this.associativityFlag;
    }

    public void setAssociativityFlag(int associativityFlag) {
        this.associativityFlag = associativityFlag;
    }

    public boolean isBoundaryAnnotation() {
        return this.boundaryAnnotation;
    }

    public void setBoundaryAnnotation(boolean boundaryAnnotation) {
        this.boundaryAnnotation = boundaryAnnotation;
    }

    public int getBoundaryPathCount() {
        return this.boundaryPathCount;
    }

    public void setBoundaryPathCount(int boundaryPathCount) {
        this.boundaryPathCount = boundaryPathCount;
    }

    public int getDefinationLinesCount() {
        return this.definationLinesCount;
    }

    public void setDefinationLinesCount(int definationLinesCount) {
        this.definationLinesCount = definationLinesCount;
    }

    public int getDegenerateBoundaryPathCount() {
        return this.degenerateBoundaryPathCount;
    }

    public void setDegenerateBoundaryPathCount(int degenerateBoundaryPathCount) {
        this.degenerateBoundaryPathCount = degenerateBoundaryPathCount;
    }

    public boolean isGradientHatch() {
        return this.gradientHatch;
    }

    public void setGradientHatch(boolean gradientHatch) {
        this.gradientHatch = gradientHatch;
    }

    public int getHatchStyle() {
        return this.hatchStyle;
    }

    public void setHatchStyle(int hatchStyle) {
        this.hatchStyle = hatchStyle;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getOffsetVector() {
        return this.offsetVector;
    }

    public void setOffsetVector(double offsetVector) {
        this.offsetVector = offsetVector;
    }

    public double getPatternAngle() {
        return this.patternAngle;
    }

    public void setPatternAngle(double patternAngle) {
        this.patternAngle = patternAngle;
    }

    public boolean isPatternDouble() {
        return this.patternDouble;
    }

    public void setPatternDouble(boolean patternDouble) {
        this.patternDouble = patternDouble;
    }

    public double getPatternScaleSpacing() {
        return this.patternScaleSpacing;
    }

    public void setPatternScaleSpacing(double patternScaleSpacing) {
        this.patternScaleSpacing = patternScaleSpacing;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public void setPatternType(int patternType) {
        this.patternType = patternType;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public void setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
    }

    public int getSeedPointCount() {
        return this.seedPointCount;
    }

    public void setSeedPointCount(int seedPointCount) {
        this.seedPointCount = seedPointCount;
    }

    public boolean isSolid() {
        return this.flags == 1;
    }

    public void setSolid(boolean solid) {
        this.solid = solid;
    }

    public void addBoundaryLoop(HatchBoundaryLoop loop) {
        this.boundaries.add(loop);
    }

    public Iterator getBoundaryLoops() {
        return this.boundaries.iterator();
    }

    public int getBoundaryLoopSize() {
        return this.boundaries.size();
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        for (HatchBoundaryLoop loop : this.boundaries) {
            Bounds b = loop.getBounds();
            if (!b.isValid()) continue;
            bounds.addToBounds(b);
        }
        return bounds;
    }

    public Point getElevationPoint() {
        return this.elevationPoint;
    }

    public void setElevationPoint(Point elevationPoint) {
        this.elevationPoint = elevationPoint;
    }

    public String getType() {
        return "HATCH";
    }

    public String getDXFHatchPatternID() {
        return this.patternID;
    }

    public void setDXFHatchPatternID(String patternID) {
        this.patternID = patternID;
    }

    public double getLength() {
        return 0.0;
    }

    public double getPatternScale() {
        return this.patternScale;
    }

    public void setPatternScale(double patternScale) {
        this.patternScale = patternScale;
    }
}

