/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFDimensionStyle;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFHatchPattern;
import org.kabeja.dxf.DXFHeader;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLineType;
import org.kabeja.dxf.DXFStyle;
import org.kabeja.dxf.DXFView;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.dxf.objects.DXFDictionary;
import org.kabeja.dxf.objects.DXFObject;

public class DXFDocument {
    public static String PROPERTY_ENCODING = "encoding";
    public static final double DEFAULT_MARGIN = 5.0;
    private Hashtable layers = new Hashtable();
    private Hashtable blocks = new Hashtable();
    private HashMap lineTypes = new HashMap();
    private HashMap dimensionStyles = new HashMap();
    private HashMap textStyles = new HashMap();
    private Hashtable ucs = new Hashtable();
    private Hashtable properties = new Hashtable();
    private List viewports = new ArrayList();
    private Bounds bounds = new Bounds();
    private double margin;
    private DXFHeader header = new DXFHeader();
    private HashMap objects = new HashMap();
    private HashMap patterns = new HashMap();
    private List views = new ArrayList();
    private DXFDictionary rootDictionary = new DXFDictionary();

    public DXFDocument() {
        DXFLayer defaultLayer = new DXFLayer();
        defaultLayer.setDXFDocument(this);
        defaultLayer.setName("0");
        this.layers.put("0", defaultLayer);
        this.margin = 5.0;
        this.rootDictionary = new DXFDictionary();
        this.rootDictionary.setDXFDocument(this);
    }

    public void addDXFLayer(DXFLayer layer) {
        layer.setDXFDocument(this);
        this.layers.put(layer.getName(), layer);
    }

    public DXFLayer getDXFLayer(String key) {
        if (this.layers.containsKey(key)) {
            return (DXFLayer)this.layers.get(key);
        }
        if (this.layers.containsKey("0")) {
            return (DXFLayer)this.layers.get("0");
        }
        DXFLayer layer = new DXFLayer();
        layer.setName("0");
        this.addDXFLayer(layer);
        return layer;
    }

    public boolean containsDXFLayer(String layerName) {
        return this.layers.containsKey(layerName);
    }

    public Iterator getDXFLayerIterator() {
        return new ArrayList(this.layers.values()).iterator();
    }

    public void addDXFLineType(DXFLineType ltype) {
        this.lineTypes.put(ltype.getName(), ltype);
    }

    public DXFLineType getDXFLineType(String name) {
        return (DXFLineType)this.lineTypes.get(name);
    }

    public Iterator getDXFLineTypeIterator() {
        return this.lineTypes.values().iterator();
    }

    public void addDXFEntity(DXFEntity entity) {
        entity.setDXFDocument(this);
        DXFLayer layer = this.getDXFLayer(entity.getLayerName());
        layer.addDXFEntity(entity);
    }

    public void addDXFBlock(DXFBlock block) {
        block.setDXFDocument(this);
        this.blocks.put(block.getName(), block);
    }

    public DXFBlock getDXFBlock(String name) {
        return (DXFBlock)this.blocks.get(name);
    }

    public Iterator getDXFBlockIterator() {
        return this.blocks.values().iterator();
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        if (this.properties.containsKey(key)) {
            return (String)this.properties.get(key);
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public Bounds getBounds() {
        this.bounds = new Bounds();
        Enumeration e = this.layers.elements();
        while (e.hasMoreElements()) {
            Bounds b;
            DXFLayer layer = (DXFLayer)e.nextElement();
            if (layer.isFrozen() || !(b = layer.getBounds()).isValid()) continue;
            this.bounds.addToBounds(b);
        }
        return this.bounds;
    }

    public Bounds getBounds(boolean onModelspace) {
        Bounds bounds = new Bounds();
        Enumeration e = this.layers.elements();
        while (e.hasMoreElements()) {
            Bounds b;
            DXFLayer layer = (DXFLayer)e.nextElement();
            if (layer.isFrozen() || !(b = layer.getBounds(onModelspace)).isValid()) continue;
            bounds.addToBounds(b);
        }
        return bounds;
    }

    public double getHeight() {
        return this.bounds.getHeight();
    }

    public double getWidth() {
        return this.bounds.getWidth();
    }

    public DXFHeader getDXFHeader() {
        return this.header;
    }

    public void setDXFHeader(DXFHeader header) {
        this.header = header;
    }

    public void addDXFDimensionStyle(DXFDimensionStyle style) {
        this.dimensionStyles.put(style.getName(), style);
    }

    public DXFDimensionStyle getDXFDimensionStyle(String name) {
        return (DXFDimensionStyle)this.dimensionStyles.get(name);
    }

    public Iterator getDXFDimensionStyleIterator() {
        return this.dimensionStyles.values().iterator();
    }

    public void addDXStyle(DXFStyle style) {
        this.textStyles.put(style.getName(), style);
    }

    public DXFStyle getDXFStyle(String name) {
        return (DXFStyle)this.textStyles.get(name);
    }

    public Iterator getDXFStyleIterator() {
        return this.textStyles.values().iterator();
    }

    public void removeDXFLayer(String id) {
        this.layers.remove(id);
    }

    public void addDXFViewport(DXFViewport viewport) {
        this.viewports.add(viewport);
    }

    public Iterator getDXFViewportIterator() {
        return this.viewports.iterator();
    }

    public void removeDXFViewport(DXFViewport viewport) {
        this.viewports.remove(viewport);
    }

    public void removeDXFViewport(int index) {
        this.viewports.remove(index);
    }

    public void addDXFView(DXFView view) {
        this.views.add(view);
    }

    public Iterator getDXFViewIterator() {
        return this.views.iterator();
    }

    public void addDXFObject(DXFObject obj) {
        DXFDictionary d = this.rootDictionary.getDXFDictionaryForID(obj.getID());
        if (d != null) {
            d.putDXFObject(obj);
        } else {
            HashMap type = null;
            if (this.objects.containsKey(obj.getObjectType())) {
                type = (HashMap)this.objects.get(obj.getObjectType());
            } else {
                type = new HashMap();
                this.objects.put(obj.getObjectType(), type);
            }
            type.put(obj.getID(), obj);
        }
    }

    public DXFDictionary getRootDXFDictionary() {
        return this.rootDictionary;
    }

    public void setRootDXFDictionary(DXFDictionary root) {
        this.rootDictionary = root;
    }

    public List getDXFObjectsByType(String type) {
        HashMap objecttypes = (HashMap)this.objects.get(type);
        ArrayList list = new ArrayList(objecttypes.values());
        return list;
    }

    public DXFObject getDXFObjectByID(String id) {
        for (HashMap map : this.objects.values()) {
            Object obj = map.get(id);
            if (obj == null) continue;
            return (DXFObject)obj;
        }
        return this.rootDictionary.getDXFObjectByID(id);
    }

    public DXFEntity getDXFEntityByID(String id) {
        DXFEntity entity = null;
        Iterator i = this.getDXFLayerIterator();
        while (i.hasNext()) {
            DXFLayer layer = (DXFLayer)i.next();
            entity = layer.getDXFEntityByID(id);
            if (entity == null) continue;
            return entity;
        }
        i = this.getDXFBlockIterator();
        while (i.hasNext()) {
            DXFBlock block = (DXFBlock)i.next();
            entity = block.getDXFEntityByID(id);
            if (entity == null) continue;
            return entity;
        }
        return entity;
    }

    public void addDXFHatchPattern(DXFHatchPattern pattern) {
        this.patterns.put(pattern.getID(), pattern);
    }

    public Iterator getDXFHatchPatternIterator() {
        return this.patterns.values().iterator();
    }

    public DXFHatchPattern getDXFHatchPattern(String id) {
        return (DXFHatchPattern)this.patterns.get(id);
    }
}

