/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Iterator;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;

public class DXFBlock {
    public static String TYPE = "BLOCK";
    private Point referencePoint;
    private String layerID = "0";
    private String name = "";
    private String description = "";
    private ArrayList entities = new ArrayList();
    private DXFDocument doc;

    public DXFBlock() {
        this.referencePoint = new Point();
    }

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        Iterator i = this.entities.iterator();
        if (i.hasNext()) {
            while (i.hasNext()) {
                DXFEntity entity = (DXFEntity)i.next();
                Bounds b = entity.getBounds();
                if (!b.isValid()) continue;
                bounds.addToBounds(b);
            }
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Point getReferencePoint() {
        return this.referencePoint;
    }

    public void setReferencePoint(Point p) {
        this.referencePoint = p;
    }

    public void addDXFEntity(DXFEntity entity) {
        this.entities.add(entity);
    }

    public Iterator getDXFEntitiesIterator() {
        return this.entities.iterator();
    }

    public String getLayerID() {
        return this.layerID;
    }

    public void setLayerID(String layerID) {
        this.layerID = layerID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDXFDocument(DXFDocument doc) {
        this.doc = doc;
        for (DXFEntity entity : this.entities) {
            entity.setDXFDocument(doc);
        }
    }

    public DXFDocument getDXFDocument() {
        return this.doc;
    }

    public double getLength() {
        double length = 0.0;
        for (DXFEntity entity : this.entities) {
            length += entity.getLength();
        }
        return length;
    }

    public DXFEntity getDXFEntityByID(String id) {
        DXFEntity entity = null;
        for (DXFEntity e : this.entities) {
            if (!e.getID().equals(id)) continue;
            return e;
        }
        return entity;
    }
}

