/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.batik.tools;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.kabeja.xml.SAXSerializer;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractSAXSerializer2
extends SAXSVGDocumentFactory
implements SAXSerializer {
    public static final String SUFFIX_JPEG = "jpg";
    public static final String SUFFIX_PNG = "png";
    public static final String SUFFIX_TIFF = "tif";
    public static final String SUFFIX_PDF = "pdf";
    public static final String MIME_TYPE_JPEG = "image/jepg";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_TIFF = "image/tiff";
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_QUALITY = "quality";
    protected OutputStream out;
    protected float width;
    protected float height;
    protected double quality = 0.9;
    protected Transcoder transcoder;

    public AbstractSAXSerializer2() {
        super(null);
        this.init();
        this.transcoder = this.createTranscoder();
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setProperties(Map properties) {
        if (properties.containsKey(PROPERTY_WIDTH)) {
            this.width = Float.parseFloat((String)properties.get(PROPERTY_WIDTH));
        }
        if (properties.containsKey(PROPERTY_HEIGHT)) {
            this.height = Float.parseFloat((String)properties.get(PROPERTY_HEIGHT));
        }
        if (properties.containsKey(PROPERTY_QUALITY)) {
            this.quality = Double.parseDouble((String)properties.get(PROPERTY_QUALITY));
        }
    }

    public void endDocument() throws SAXException {
        try {
            super.endDocument();
            TranscoderInput transInput = new TranscoderInput(this.document);
            TranscoderOutput transOutput = new TranscoderOutput(this.out);
            if ((double)this.width > 0.0 && (double)this.height > 0.0) {
                this.transcoder.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)new Float(this.width));
                this.transcoder.addTranscodingHint(JPEGTranscoder.KEY_HEIGHT, (Object)new Float(this.height));
            }
            this.transcode(transInput, transOutput);
        }
        catch (TranscoderException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    protected abstract Transcoder createTranscoder();

    protected void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        this.transcoder.transcode(input, output);
    }

    protected void init() {
        try {
            if (this.parserClassName != null) {
                this.parser = XMLReaderFactory.createXMLReader(this.parserClassName);
            } else {
                SAXParser saxParser = null;
                try {
                    saxParser = SAXParserFactory.newInstance().newSAXParser();
                }
                catch (ParserConfigurationException pce) {
                    pce.printStackTrace();
                }
                this.parser = saxParser.getXMLReader();
            }
            this.parser.setContentHandler(this);
            this.parser.setDTDHandler((DTDHandler)((Object)this));
            this.parser.setEntityResolver((EntityResolver)((Object)this));
            this.parser.setErrorHandler((ErrorHandler)(this.errorHandler == null ? this : this.errorHandler));
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parser.setFeature("http://xml.org/sax/features/validation", this.isValidating);
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

