/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class Loader {
    public static final String OPTION_MAIN_CLASS = "-main";
    public static final String OPTION_LIB_FOLDER = "-lib";
    public static final String OPTION_CLASSES_FOLDER = "-classes";
    public String mainClass = "org.kabeja.Main";
    private Set classpathEntries = new HashSet();

    public Loader() {
        this.classpathEntries.add("lib");
        this.classpathEntries.add("classes");
    }

    public static void main(String[] args) {
        Loader l = new Loader();
        l.launch(args);
    }

    public void launch(String[] args) {
        args = this.parseMainClass(args);
        URLClassLoader cl = new URLClassLoader(this.getClasspath());
        try {
            Class<?> clazz = cl.loadClass(this.mainClass);
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("main", args.getClass());
            method.invoke(obj, new Object[]{args});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    protected URL[] getClasspath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator i = this.classpathEntries.iterator();
        while (i.hasNext()) {
            File f = new File((String)i.next());
            try {
                if (f.isDirectory() && f.exists()) {
                    File[] files = f.listFiles();
                    for (int x = 0; x < files.length; ++x) {
                        String name = files[x].getName().toLowerCase();
                        if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                        urls.add(files[x].toURL());
                    }
                }
                urls.add(f.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    protected String[] parseMainClass(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (OPTION_MAIN_CLASS.equals(args[i]) && i + 1 < args.length) {
                this.mainClass = args[++i];
                continue;
            }
            if (OPTION_LIB_FOLDER.equals(args[i])) {
                this.addPathEntries(args[++i]);
                continue;
            }
            if (OPTION_CLASSES_FOLDER.equals(args[i])) {
                this.addPathEntries(args[++i]);
                continue;
            }
            list.add(args[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    protected void addPathEntries(String path) {
        StringTokenizer st = new StringTokenizer(path, ":");
        while (st.hasMoreElements()) {
            String el = (String)st.nextElement();
            this.classpathEntries.add(el);
        }
    }
}

