/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class ImagePreviewer
extends JComponent {
    private BufferedImage img;
    private int margin = 5;
    private Font font = new Font("SansSerif", 0, 9);
    private int fontHeight;
    private Dimension dim;
    private double ih;
    private double iw;
    private double ratio;
    private double x;
    private double y;
    private double w;
    private double h;
    private double text_x;
    private double text_y;
    private String text;

    public void paintComponent(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, (int)this.x, (int)this.y, (int)this.w, (int)this.h, this);
            g.setColor(Color.BLACK);
            g.drawRect((int)this.x - 1, (int)this.y - 1, (int)this.w + 1, (int)this.h + 1);
            g.setFont(this.font);
            g.drawString(this.text, (int)this.text_x, (int)this.text_y);
        }
    }

    public void setImage(String uri) {
        this.img = null;
        if (uri != null && uri.length() > 0) {
            try {
                this.img = uri.startsWith("http:") || uri.startsWith("ftp:") ? ImageIO.read(new URL(uri)) : ImageIO.read(new File(uri));
                if (this.img != null) {
                    this.scaleImage();
                    this.repaint();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    private void scaleImage() {
        double f;
        this.h = this.img.getHeight();
        this.w = this.img.getWidth();
        double r = this.w / this.h;
        if (r > this.ratio) {
            f = this.iw / this.w;
            this.h *= f;
            this.w = this.iw;
            this.y = (double)this.margin + (this.ih - this.h) / 2.0;
            this.x = this.margin;
        } else {
            f = this.ih / this.h;
            this.w *= f;
            this.x = this.dim.getWidth() / 2.0 - this.w / 2.0;
            this.h = this.ih;
            this.y = this.margin;
        }
        this.text = this.img.getWidth() + "x" + this.img.getHeight();
        FontMetrics fm = this.getFontMetrics(this.font);
        this.fontHeight = fm.getHeight();
        int length = fm.stringWidth(this.text);
        this.text_x = (this.dim.getWidth() - (double)length) / 2.0;
        this.text_y = this.dim.getHeight() - 2.0;
    }

    public void setFixedSize(int arg0, int arg1) {
        this.dim = new Dimension(arg0, arg1);
        this.setSize(arg0, arg1);
        FontMetrics fm = this.getFontMetrics(this.font);
        this.fontHeight = fm.getHeight();
        this.ih = this.dim.getHeight() - (double)this.margin - 4.0 - (double)this.fontHeight;
        this.iw = this.dim.getWidth() - (double)(2 * this.margin);
        this.ratio = this.iw / this.ih;
        if (this.img != null) {
            this.scaleImage();
        }
    }

    public void setImage(BufferedImage img) {
        this.img = img;
        if (img != null) {
            this.scaleImage();
            this.repaint();
        }
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }
}

