/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ButtonGradientTitledLabel
extends JComponent {
    private ArrayList rightSide = new ArrayList();
    private ArrayList leftSide = new ArrayList();
    private String text;
    private int margin = 3;
    private int iconSize = 16;
    private int padding = 3;
    private GradientPaint gradient;
    private Color startColor = new Color(66, 66, 66);
    private Color endColor = new Color(230, 230, 230);
    private Color textColor = Color.WHITE;

    public ButtonGradientTitledLabel(String title) {
        this.text = title;
    }

    public ButtonGradientTitledLabel() {
        this("");
    }

    public void addComponent(JComponent comp) {
        this.addComponent(comp, 4);
    }

    public void addComponent(JComponent comp, int orientation) {
        comp.setBorder(BorderFactory.createEmptyBorder());
        comp.setOpaque(false);
        comp.setFocusable(false);
        switch (orientation) {
            case 4: {
                this.rightSide.add(comp);
                break;
            }
            case 2: {
                this.leftSide.add(comp);
                break;
            }
            default: {
                this.rightSide.add(comp);
            }
        }
        this.add(comp);
    }

    public Dimension getPreferredSize() {
        int h = 0;
        int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        h = fontHeight > this.iconSize ? 2 * this.margin + fontHeight : 2 * this.margin + this.iconSize;
        int w = (this.leftSide.size() + this.rightSide.size()) * this.padding + 2 * this.padding + this.getFontMetrics(this.getFont()).stringWidth(this.text);
        Dimension dim = new Dimension(w, h);
        return dim;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        int gy = height / 2;
        this.gradient = new GradientPaint((float)((double)width * 0.45), gy, this.startColor, width, gy, this.endColor);
        g2.setPaint(this.gradient);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.WHITE);
        g2.drawLine(0, 0, width, 0);
        g2.drawLine(0, 0, 0, height - 1);
        g2.setColor(Color.gray);
        g2.drawLine(0, height - 1, width - 1, height - 1);
        g2.setFont(this.getFont());
        g2.setColor(this.textColor);
        int x = this.padding;
        int y = height / 2 - this.iconSize / 2;
        for (JComponent comp : this.leftSide) {
            comp.setBounds(x, y, this.iconSize, this.iconSize);
            x += this.iconSize + this.padding;
        }
        FontMetrics fm = g2.getFontMetrics();
        y = height / 2 + fm.getHeight() / 2 - fm.getDescent();
        g2.drawString(this.text, x, y);
        x = width - this.padding - this.iconSize;
        y = height / 2 - this.iconSize / 2;
        for (JComponent comp : this.rightSide) {
            comp.setBounds(x, y, this.iconSize, this.iconSize);
            x -= this.iconSize + this.padding;
        }
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }
}

