/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JLabel;

public class ImagePreviewer
extends JLabel
implements PropertyChangeListener,
Runnable {
    String imgSrc;
    Image img;
    int height;
    int width;
    int x;
    int y;
    MediaTracker mt;
    Thread t;

    public ImagePreviewer() {
        this.imgSrc = "Select an image";
        this.height = 128;
        this.width = 128;
        this.x = 30;
        this.y = 30;
        this.setSize(new Dimension(this.width + this.x * 2, this.height + this.y * 2));
        this.setBounds(0, 0, this.width + this.x * 2, this.height + this.y * 2);
        this.setPreferredSize(new Dimension(this.width + this.x * 2, this.height + this.y * 2));
        this.validate();
        this.mt = new MediaTracker(this);
    }

    public ImagePreviewer(int width, int height) {
        this.imgSrc = "";
        this.height = height;
        this.width = width;
        this.x = 30;
        this.y = 30;
        this.setSize(new Dimension(width + this.x * 2, height + this.y * 2));
        this.setBounds(0, 0, width + this.x * 2, height + this.y * 2);
        this.setPreferredSize(new Dimension(width + this.x * 2, height + this.y * 2));
        this.validate();
        this.mt = new MediaTracker(this);
    }

    public void setValue(Object value) {
        this.imgSrc = (String)value;
        if (this.imgSrc.length() > 0) {
            this.img = Toolkit.getDefaultToolkit().getImage(this.imgSrc);
            this.mt.addImage(this.img, 0);
            this.t = new Thread(this);
            this.t.start();
            this.t = null;
        }
    }

    public void run() {
        try {
            this.mt.waitForID(0);
            this.repaint();
        }
        catch (InterruptedException e) {
            System.out.println("Exception Thread:" + e.getMessage());
            return;
        }
    }

    public void paint(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, this.x, this.y, this.width, this.height, null);
        }
        g.drawString("Preview", this.width / 2, 15);
        g.drawRect(this.x - 1, this.y - 1, this.width + 1, this.height + 1);
    }

    public void propertyChange(PropertyChangeEvent e) {
        File f;
        if (e.getPropertyName().equals("SelectedFileChangedProperty") && (f = (File)e.getNewValue()) != null && f.isFile() && (f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg") || f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".png"))) {
            this.setValue(f.getPath());
        }
    }
}

