/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.border.Border;

public class FineBorder
implements Border {
    private Insets i;
    private Color startColor;
    private Color endColor;
    final int steps = 55;
    private Color[] gradient;
    private String label;
    private String icon;
    private Image iconImg;
    private int iconHeight = 16;
    private int iconWidth = 16;
    private double plainsize = 0.4;
    private boolean withicon;
    private Color textColor = Color.WHITE;
    private Color darkGray = new Color(100, 100, 100);
    private Color lightGray = new Color(160, 160, 160);

    public FineBorder(String title) {
        this.i = new Insets(25, 1, 3, 3);
        this.startColor = new Color(91, 110, 179);
        this.endColor = new Color(212, 212, 185);
        this.gradient = new Color[55];
        this.buildGradient();
        this.label = title;
        this.withicon = false;
    }

    public FineBorder(String title, String icon, Component c) {
        this(title);
        this.icon = icon;
        this.withicon = true;
        MediaTracker mt = new MediaTracker(c);
        this.iconImg = Toolkit.getDefaultToolkit().getImage(icon);
        mt.addImage(this.iconImg, 0);
        try {
            mt.waitForID(0);
            c.repaint();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.i;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.startColor);
        int size = (int)(this.plainsize * (double)(width - 2));
        g.fillRect(x + 1, y, size, y + this.i.top);
        this.paintGradient(g, x + 1 + size, y, width - 2 - size, this.i.top - 1);
        g.setColor(this.darkGray);
        g.drawLine(x + width - 3, y, x + width - 3, y + height);
        g.setColor(this.lightGray);
        g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 1);
        g.drawLine(x + width - 1, y + 2, x + width - 1, y + height - 2);
        g.setColor(this.darkGray);
        g.drawLine(x, y + height - 3, x + width - 3, y + height - 3);
        g.setColor(this.lightGray);
        g.drawLine(x + 1, y + height - 2, x + width - 2, y + height - 2);
        g.drawLine(x + 2, y + height - 1, x + width - 3, y + height - 1);
        g.setColor(Color.gray);
        g.drawLine(x, y, x, y + height - 3);
        g.setColor(Color.gray);
        g.drawLine(x, y, x + width - 5, y);
        g.drawLine(x, y + this.i.top - 1, x + width - this.i.right, y + this.i.top - 1);
        g.setColor(Color.white);
        g.drawLine(x + 1, y + 1, x + width - this.i.right - 1, y + 1);
        g.drawLine(x + 1, y + 1, x + 1, y + this.i.top - 1);
        if (this.withicon) {
            g.drawImage(this.iconImg, x + 5, y + (this.i.top - 1 - this.iconHeight) / 2, this.iconWidth, this.iconHeight, null);
            g.setColor(this.textColor);
            g.drawString(this.label, x + 10 + this.iconWidth, y + this.i.top / 2 + fm.getHeight() / 2);
        } else {
            g.setColor(this.textColor);
            g.drawString(this.label, x + 10, y + this.i.top / 2 + fm.getHeight() / 2 - fm.getDescent());
        }
    }

    private void paintGradient(Graphics g, int x, int y, int width, int height) {
        int i;
        double diffx = width / 55;
        int length = (int)diffx;
        for (i = 0; (i + 1) * length < width && i < 55; ++i) {
            g.setColor(this.gradient[i]);
            g.fillRect(x + i * length, y, length, height);
        }
        if (i < 55) {
            g.setColor(this.gradient[i]);
        } else {
            g.setColor(this.endColor);
        }
        g.fillRect(x + i * length, y, width - i * length, height);
    }

    private void buildGradient() {
        double diffred = this.endColor.getRed() - this.startColor.getRed();
        double diffgreen = this.endColor.getGreen() - this.startColor.getGreen();
        double diffblue = this.endColor.getBlue() - this.startColor.getBlue();
        this.gradient[0] = this.startColor;
        this.gradient[54] = this.endColor;
        for (int i = 1; i < 54; ++i) {
            this.gradient[i] = new Color(this.startColor.getRed() + (int)(diffred / 53.0 * (double)i), this.startColor.getGreen() + (int)(diffgreen / 53.0 * (double)i), this.startColor.getBlue() + (int)(diffblue / 53.0 * (double)i));
        }
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
        this.buildGradient();
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
        this.buildGradient();
    }

    public void setTitle(String title) {
        this.label = title;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }
}

