/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management.helper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.softee.management.annotation.Description;
import org.softee.management.annotation.MBean;
import org.softee.management.annotation.ManagedAttribute;
import org.softee.management.annotation.ManagedOperation;
import org.softee.management.annotation.Parameter;
import org.softee.management.exception.ManagementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectedDynamicMBean
implements DynamicMBean {
    private final Object mbean;
    private final Class<?> mbeanClass;
    private final Map<String, PropertyDescriptor> propertyDescriptors;
    private final Map<String, Method> operationMethods;
    private final MBeanInfo mbeanInfo;

    public IntrospectedDynamicMBean(Object mbean) throws ManagementException {
        this.mbean = mbean;
        this.mbeanClass = mbean.getClass();
        if (!this.mbeanClass.isAnnotationPresent(MBean.class)) {
            throw new ManagementException(String.format("MBean %s is not annotated with @%s", this.mbeanClass, MBean.class.getName()));
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.mbeanClass);
            this.propertyDescriptors = this.createPropertyDescriptors(beanInfo);
            this.operationMethods = this.createOperationMethods(beanInfo);
            this.mbeanInfo = this.createMbeanInfo();
        }
        catch (javax.management.IntrospectionException e) {
            throw new ManagementException(e);
        }
        catch (IntrospectionException e) {
            throw new ManagementException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(attribute);
        if (propertyDescriptor == null) {
            throw new AttributeNotFoundException(attribute);
        }
        Method getter = propertyDescriptor.getReadMethod();
        if (getter == null) {
            throw new AttributeNotFoundException(String.format("Getter method for attribute %s of %s", attribute, this.mbeanClass));
        }
        try {
            if (!getter.isAccessible()) {
                getter.setAccessible(true);
            }
            return getter.invoke(this.mbean, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to obtain value of attribute %s of %s", attribute, this.mbeanClass));
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList attributes = new AttributeList(attributeNames.length);
        for (String attributeName : attributeNames) {
            try {
                Attribute attribute = new Attribute(attributeName, this.getAttribute(attributeName));
                attributes.add(attribute);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return attributes;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attribute.getName();
        PropertyDescriptor propertyDescriptor = this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            throw new AttributeNotFoundException(name);
        }
        Method setter = propertyDescriptor.getWriteMethod();
        if (setter == null) {
            throw new AttributeNotFoundException(String.format("setter method for attribute %s of %s", name, this.mbeanClass));
        }
        Object value = attribute.getValue();
        try {
            if (!setter.isAccessible()) {
                setter.setAccessible(true);
            }
            setter.invoke(this.mbean, value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException(String.format("attribute %s, value = (%s)%s, expected (%s)", name, value.getClass().getName(), value, setter.getParameterTypes()[0].getName()));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, String.format("attribute %s of %s, value = (%s)%s", name, this.mbeanClass, value.getClass().getName(), value));
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e, String.format("attribute %s of %s, value = (%s)%s", name, this.mbeanClass, value.getClass().getName(), value));
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        for (Object object : attributes) {
            Attribute attribute = (Attribute)object;
            try {
                this.setAttribute(attribute);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return attributes;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Method method = this.operationMethods.get(actionName);
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.mbean, params);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private MBeanInfo createMbeanInfo() throws javax.management.IntrospectionException, ManagementException {
        String description = IntrospectedDynamicMBean.description(this.mbeanClass);
        MBeanAttributeInfo[] attributeInfo = this.createAttributeInfo(this.propertyDescriptors);
        MBeanConstructorInfo[] constructorInfo = this.createConstructorInfo();
        MBeanOperationInfo[] operationInfo = this.createOperationInfo();
        MBeanNotificationInfo[] notificationInfo = this.createNotificationInfo();
        return new MBeanInfo(this.mbeanClass.getName(), description, attributeInfo, constructorInfo, operationInfo, notificationInfo);
    }

    private MBeanNotificationInfo[] createNotificationInfo() {
        return null;
    }

    private Map<String, Method> createOperationMethods(BeanInfo beanInfo) throws ManagementException {
        HashMap<String, Method> operationMethods = new HashMap<String, Method>();
        for (MethodDescriptor descriptor : beanInfo.getMethodDescriptors()) {
            Method old;
            Method method = descriptor.getMethod();
            ManagedOperation annotation = method.getAnnotation(ManagedOperation.class);
            if (annotation == null || (old = operationMethods.put(method.getName(), method)) == null) continue;
            throw new ManagementException(String.format("Multiple Operation annotations for operation %s of %s", method.getName(), this.mbeanClass));
        }
        return operationMethods;
    }

    private MBeanOperationInfo[] createOperationInfo() throws ManagementException {
        MBeanOperationInfo[] operationInfos = new MBeanOperationInfo[this.operationMethods.size()];
        int operationIndex = 0;
        for (String methodName : this.sortedKeys(this.operationMethods)) {
            Method method = this.operationMethods.get(methodName);
            ManagedOperation annotation = method.getAnnotation(ManagedOperation.class);
            MBeanParameterInfo[] signature = this.createParameterInfo(method);
            ManagedOperation.Impact impact = annotation.value();
            int impactValue = impact.impactValue;
            String description = IntrospectedDynamicMBean.description(method);
            MBeanOperationInfo opInfo = new MBeanOperationInfo(method.getName(), description, signature, method.getReturnType().getName(), impactValue, null);
            operationInfos[operationIndex++] = opInfo;
        }
        return operationInfos;
    }

    protected MBeanParameterInfo[] createParameterInfo(Method method) {
        MBeanParameterInfo[] parameters = new MBeanParameterInfo[method.getParameterTypes().length];
        for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
            String pType = method.getParameterTypes()[parameterIndex].getName();
            Parameter parameter = IntrospectedDynamicMBean.getParameterAnnotation(method, parameterIndex, Parameter.class);
            Description description = IntrospectedDynamicMBean.getParameterAnnotation(method, parameterIndex, Description.class);
            String pName = parameter != null ? parameter.value() : "p" + (parameterIndex + 1);
            String pDesc = description != null ? description.value() : null;
            parameters[parameterIndex] = new MBeanParameterInfo(pName, pType, pDesc);
        }
        return parameters;
    }

    private MBeanConstructorInfo[] createConstructorInfo() {
        return null;
    }

    private Map<String, PropertyDescriptor> createPropertyDescriptors(BeanInfo beanInfo) throws ManagementException {
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
            ManagedAttribute getterAnnotation = this.getAnnotation(property.getReadMethod(), ManagedAttribute.class);
            ManagedAttribute setterAnnotation = this.getAnnotation(property.getWriteMethod(), ManagedAttribute.class);
            if (getterAnnotation == null && setterAnnotation == null) continue;
            properties.put(property.getName(), property);
        }
        return properties;
    }

    private MBeanAttributeInfo[] createAttributeInfo(Map<String, PropertyDescriptor> propertyDescriptors) throws ManagementException, javax.management.IntrospectionException {
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[propertyDescriptors.size()];
        int i = 0;
        for (String propertyName : this.sortedKeys(propertyDescriptors)) {
            PropertyDescriptor property = propertyDescriptors.get(propertyName);
            Method readMethod = property.getReadMethod();
            Method writeMethod = property.getWriteMethod();
            boolean readable = null != this.getAnnotation(readMethod, ManagedAttribute.class);
            boolean writable = null != this.getAnnotation(writeMethod, ManagedAttribute.class);
            Description descriptionAnnotation = this.getSingleAnnotation(property, Description.class, readMethod, writeMethod);
            String description = descriptionAnnotation != null ? descriptionAnnotation.value() : null;
            MBeanAttributeInfo info = new MBeanAttributeInfo(property.getName(), description, readable ? readMethod : null, writable ? writeMethod : null);
            infos[i++] = info;
        }
        return infos;
    }

    private <T extends Annotation> T getSingleAnnotation(PropertyDescriptor property, Class<T> annotationClass, AccessibleObject ... entities) throws ManagementException {
        T result = null;
        for (AccessibleObject entity : entities) {
            T annotation;
            if (entity == null || (annotation = entity.getAnnotation(annotationClass)) == null) continue;
            if (result != null) {
                throw new ManagementException(String.format("Multiple %s annotations found for property %s of %s", annotationClass.getName(), property.getName(), this.mbeanClass));
            }
            result = annotation;
        }
        return result;
    }

    private static <A extends Annotation> A getParameterAnnotation(Method method, int index, Class<A> annotationClass) {
        for (Annotation a : method.getParameterAnnotations()[index]) {
            if (!annotationClass.isInstance(a)) continue;
            return (A)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    private <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationClass) {
        return element != null ? (A)element.getAnnotation(annotationClass) : null;
    }

    private static String description(AnnotatedElement element) {
        Description annotation = element.getAnnotation(Description.class);
        return annotation != null ? annotation.value() : null;
    }

    private List<String> sortedKeys(Map<String, ?> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        return keys;
    }
}

