/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.b.b.a.a;

import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.api.web.dto.CustomerCopyVO;
import com.tplink.smb.omada.backup.api.web.dto.CustomerImportVO;
import com.tplink.smb.omada.backup.api.web.dto.FileServerRestoreVO;
import com.tplink.smb.omada.backup.api.web.dto.SelfRestoreFileVO;
import com.tplink.smb.omada.backup.core.cache.RestoreResult;
import com.tplink.smb.omada.backup.core.restore.a.a;
import com.tplink.smb.omada.backup.core.restore.k;
import com.tplink.smb.omada.backup.core.restore.m;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.e;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.annotation.ApiService;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetCurrentInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.port.mongo.omadac.OmadacPO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.AuditLogKeyEnumDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import io.reactivex.Single;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

@ApiService
public class g
implements com.tplink.smb.omada.backup.api.web.g {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(g.class);
    @Autowired
    private com.tplink.smb.omada.lock.a.b b;
    @Autowired
    private com.tplink.smb.omada.backup.core.a.a c;
    @Autowired
    private com.tplink.smb.omada.backup.core.restore.b.a d;
    @Autowired
    private m e;
    @Autowired
    private com.tplink.smb.omada.identityaccess.api.internal.g f;
    @Autowired
    private com.tplink.smb.omada.backup.core.a.b g;
    private final com.tplink.smb.omada.identityaccess.port.mongo.g h = com.tplink.smb.omada.identityaccess.port.mongo.g.a();
    @Autowired
    private com.tplink.smb.omada.maintenance.domain.model.a.a i;
    @Autowired
    private k j;

    public Single<OperationResponse> a(String mspId, MultipartFile file, JSONObject reqObj, e controlType) {
        Subject result = ReplaySubject.create().toSerialized();
        Optional omadacPOOptional = this.h.a(new c(mspId));
        if (!omadacPOOptional.isPresent()) {
            result.onNext((Object)new OperationResponse(com.tplink.smb.omada.common.g.b.aA));
            result.onComplete();
            return result.firstOrError();
        }
        Set customers = ((OmadacPO)omadacPOOptional.get()).getCustomers();
        OperationResponse response = this.a(mspId, customers, controlType);
        if (!response.success()) {
            this.d.a(mspId, customers, response.getErrorCode());
            result.onNext((Object)response);
            result.onComplete();
            return result.firstOrError();
        }
        boolean skipConfirm = reqObj != null && reqObj.optBoolean("skipConfirm", false);
        boolean skipDevice = reqObj != null && reqObj.optBoolean("skipDevice", false);
        this.a(mspId, customers, controlType, file, skipConfirm, skipDevice, optRes -> {
            result.onNext(optRes);
            result.onComplete();
        });
        return result.firstOrError();
    }

    public OperationResponse a(String mspId, e controlType, FileServerRestoreVO restoreVO) {
        if (!com.tplink.smb.omada.common.access.e.a.equals((Object)controlType) && !com.tplink.smb.omada.common.access.e.b.equals((Object)controlType)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
        }
        return this.g.a(mspId, controlType, restoreVO);
    }

    public OperationResponse a(String mspId, e controlType, SelfRestoreFileVO fileVO) {
        if (!Objects.equals(com.tplink.smb.omada.backup.api.c.h.a.a(), fileVO.getBackupType()) && !Objects.equals(com.tplink.smb.omada.backup.api.c.h.c.a(), fileVO.getBackupType())) {
            return OperationResponse.PARAM_ERROR;
        }
        return this.g.a(mspId, controlType, fileVO);
    }

    private OperationResponse a(String mspId, Set<String> customers, e controlType) {
        if (!controlType.equals((Object)com.tplink.smb.omada.common.access.e.b) && !controlType.equals((Object)com.tplink.smb.omada.common.access.e.a)) {
            a.warn("omadacId={} not local request, forbid restore operation", (Object)mspId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
        }
        return this.d.a(mspId, customers);
    }

    private void a(String mspId, Set<String> customers, e controlType, MultipartFile file, boolean skipConfirm, boolean skipDevice, Consumer<OperationResponse> completeConsumer) {
        long setRestoreStatusTimeNs = System.nanoTime();
        a.info("mspId={} restoring beginning...", (Object)mspId);
        String currentSession = SessionUtils.getSessionId();
        if (currentSession == null) {
            this.d.a(mspId, customers, com.tplink.smb.omada.common.g.b.l.b());
            completeConsumer.accept(new OperationResponse(com.tplink.smb.omada.common.g.b.l));
            return;
        }
        OperationResponse currentInfo = this.f.a(new GetCurrentInfoDTO(SessionUtils.getSessionId(), controlType, mspId));
        if (!currentInfo.success()) {
            this.d.a(mspId, customers, currentInfo.getErrorCode());
            completeConsumer.accept(new OperationResponse(currentInfo.getErrorCode(), currentInfo.getMsg(), null));
            return;
        }
        Optional localUserIp = UserIpUtils.getLocalUserIp();
        boolean isExecuteSuccess = this.e.a(mspId, setRestoreStatusTimeNs, () -> {
            OperationResponse ops = new OperationResponse(com.tplink.smb.omada.common.g.b.eh);
            try (InputStream inputStream = file.getInputStream();){
                completeConsumer.accept(OperationResponse.SUCCESS);
                ops = this.a(inputStream, new b(mspId), customers, (UserDTO)currentInfo.getResult(), skipConfirm, skipDevice);
            }
            catch (Exception e2) {
                this.d.a(mspId, customers, com.tplink.smb.omada.common.g.b.eh.b());
                a.error("mspId={} restore failed.", (Object)mspId, (Object)e2);
                this.i.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), (UserDTO)currentInfo.getResult(), (String)localUserIp.orElse(null), Boolean.valueOf(false), new String[0]);
                completeConsumer.accept(new OperationResponse(com.tplink.smb.omada.common.g.b.eh));
            }
            finally {
                if (!ops.success()) {
                    this.d.a(mspId, customers, ops.getErrorCode());
                    a.debug("mspId={} restore failed.", (Object)mspId);
                } else {
                    this.c.a((UserDTO)currentInfo.getResult(), currentSession, new c(mspId));
                    this.d.b(mspId, customers);
                }
                this.i.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), (UserDTO)currentInfo.getResult(), (String)localUserIp.orElse(null), Boolean.valueOf(ops.success()), new String[0]);
            }
        });
        if (!isExecuteSuccess) {
            this.d.a(mspId, customers, com.tplink.smb.omada.common.g.b.eh.b());
            completeConsumer.accept(new OperationResponse(com.tplink.smb.omada.common.g.b.eh));
            this.i.a(mspId, AuditLogKeyEnumDTO.MSP_RESTORE.name(), (UserDTO)currentInfo.getResult(), (String)localUserIp.orElse(null), Boolean.valueOf(false), new String[0]);
        }
    }

    private OperationResponse a(InputStream in, b mspId, Set<String> customerIds, UserDTO currentUser, boolean skipConfirm, boolean skipDevice) {
        return (OperationResponse)this.b.b(mspId.a(), () -> this.c.a(in, mspId, currentUser, skipConfirm, skipDevice, false, customerIds), () -> {
            a.warn("{} restore Operation failed because msp Busy.", (Object)mspId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
        });
    }

    public OperationResponse a(String mspId) {
        if (Thread.currentThread().isInterrupted()) {
            a.warn("Server try to shut down, omadacId={} refuse restore request", (Object)mspId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
        }
        if (this.d.b(mspId, com.tplink.smb.omada.backup.api.c.g.c)) {
            return OperationResponse.SUCCESS;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.eg);
    }

    public OperationResponse a(String mspId, e controlType, JSONObject jsonObject) {
        String fileName = jsonObject.optString("fileName");
        boolean skipDevice = jsonObject.optBoolean("skipDevice", false);
        if (T.c((String)fileName)) {
            a.warn("empty file name to autoBackupRestore in AutoBackup");
            return OperationResponse.PARAM_ERROR;
        }
        return this.c.a(mspId, controlType, fileName, System.nanoTime(), skipDevice);
    }

    public OperationResponse b(String mspId) {
        RestoreResult restoreResult = this.d.g(mspId);
        a.debug("get restore result {}, mspId {}", (Object)restoreResult, (Object)mspId);
        if (!restoreResult.getResErrorCode().a() && restoreResult.getStatus().intValue() == com.tplink.smb.omada.backup.core.restore.a.a.d.a()) {
            return new OperationResponse(restoreResult.getResErrorCode());
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)restoreResult);
    }

    public Single<OperationResponse> a(String mspId, MultipartFile file, CustomerImportVO customerImportVO, e controlType) {
        Subject result = ReplaySubject.create().toSerialized();
        OperationResponse response = this.j.a(mspId, controlType);
        if (!response.success()) {
            this.d.b(mspId, response.getErrorCode());
            result.onNext((Object)response);
            result.onComplete();
            return result.firstOrError();
        }
        OperationResponse userRes = this.f.a(GetCurrentInfoDTO.builder().sessionId(SessionUtils.getSessionId()).omadacId(mspId).build());
        if (!userRes.success()) {
            this.d.b(mspId, userRes.getErrorCode());
            result.onNext((Object)response);
            result.onComplete();
            return result.firstOrError();
        }
        this.c.a(new b(mspId), file, customerImportVO, (UserDTO)userRes.getResult(), optRes -> {
            result.onNext(optRes);
            result.onComplete();
        });
        return result.firstOrError();
    }

    public Single<OperationResponse> a(String mspId, CustomerImportVO customerImportVO, e controlType) {
        Subject result = ReplaySubject.create().toSerialized();
        OperationResponse response = this.j.a(mspId, controlType);
        if (!response.success()) {
            this.d.b(mspId, response.getErrorCode());
            result.onNext((Object)response);
            result.onComplete();
            return result.firstOrError();
        }
        OperationResponse userRes = this.f.a(GetCurrentInfoDTO.builder().sessionId(SessionUtils.getSessionId()).omadacId(mspId).build());
        if (!userRes.success()) {
            this.d.b(mspId, userRes.getErrorCode());
            result.onNext((Object)response);
            result.onComplete();
            return result.firstOrError();
        }
        this.c.a(new b(mspId), customerImportVO, (UserDTO)userRes.getResult(), optRes -> {
            result.onNext(optRes);
            result.onComplete();
        });
        return result.firstOrError();
    }

    public Single<OperationResponse> a(String mspId, CustomerCopyVO customerCopyVO, e controlType) {
        Subject result = ReplaySubject.create().toSerialized();
        if (Objects.isNull(customerCopyVO)) {
            result.onNext((Object)OperationResponse.PARAM_ERROR);
            result.onComplete();
            return result.firstOrError();
        }
        OperationResponse response = this.j.a(mspId, controlType);
        if (!response.success()) {
            this.d.b(mspId, response.getErrorCode());
            result.onNext((Object)response);
            result.onComplete();
            return result.firstOrError();
        }
        OperationResponse userRes = this.f.a(GetCurrentInfoDTO.builder().sessionId(SessionUtils.getSessionId()).omadacId(mspId).build());
        if (!userRes.success()) {
            this.d.b(mspId, userRes.getErrorCode());
            result.onNext((Object)userRes);
            result.onComplete();
            return result.firstOrError();
        }
        this.c.a(new b(mspId), customerCopyVO, (UserDTO)userRes.getResult(), optRes -> {
            this.i.a(mspId, AuditLogKeyEnumDTO.CUSTOMER_COPY.name(), (UserDTO)userRes.getResult(), (String)UserIpUtils.getLocalUserIp().orElse(null), Boolean.valueOf(optRes.success()), new String[]{customerCopyVO.getName()});
            result.onNext(optRes);
            result.onComplete();
        });
        return result.firstOrError();
    }
}

