/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.shared;

public enum RoleEnumDTO {
    SYSTEM_ROOT(0, "Master Administrator"),
    SYSTEM_ADMIN(1, "Administrator"),
    SYSTEM_VIEWER(2, "Viewer"),
    CLOUD_ROOT(3, "Master Cloud Administrator"),
    CLOUD_ADMIN(4, "Cloud Administrator"),
    CLOUD_VIEWER(5, "Cloud Viewer");

    private int value;
    private String name;

    private RoleEnumDTO(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public static RoleEnumDTO resolve(String name) {
        for (RoleEnumDTO roleType : RoleEnumDTO.values()) {
            if (!roleType.name.equals(name)) continue;
            return roleType;
        }
        return null;
    }

    public static RoleEnumDTO resolve(int value) {
        for (RoleEnumDTO roleType : RoleEnumDTO.values()) {
            if (roleType.value != value) continue;
            return roleType;
        }
        return null;
    }

    public static boolean isCloudUser(int type) {
        RoleEnumDTO roleType = RoleEnumDTO.resolve(type);
        if (roleType == null) {
            return false;
        }
        return roleType.isCloudUser();
    }

    public boolean isCloudUser() {
        switch (this) {
            case CLOUD_ROOT: 
            case CLOUD_ADMIN: 
            case CLOUD_VIEWER: {
                return true;
            }
        }
        return false;
    }

    public String getTypeName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static Integer[] getLocalUserRoles() {
        return new Integer[]{RoleEnumDTO.SYSTEM_ROOT.value, RoleEnumDTO.SYSTEM_ADMIN.value, RoleEnumDTO.SYSTEM_VIEWER.value};
    }

    public static Integer[] getCloudUserRoles() {
        return new Integer[]{RoleEnumDTO.CLOUD_ROOT.value, RoleEnumDTO.CLOUD_ADMIN.value, RoleEnumDTO.CLOUD_VIEWER.value};
    }

    public static Integer[] getRootUserRoles() {
        return new Integer[]{RoleEnumDTO.CLOUD_ROOT.value, RoleEnumDTO.SYSTEM_ROOT.value};
    }

    public static Integer[] getRootAndAdminUserRoles() {
        return new Integer[]{RoleEnumDTO.CLOUD_ROOT.value, RoleEnumDTO.SYSTEM_ROOT.value, RoleEnumDTO.CLOUD_ADMIN.value, RoleEnumDTO.SYSTEM_ADMIN.value};
    }

    public static Integer[] getAllRolesExcludeLocalRoot() {
        return new Integer[]{RoleEnumDTO.CLOUD_ROOT.value, RoleEnumDTO.CLOUD_ADMIN.value, RoleEnumDTO.CLOUD_VIEWER.value, RoleEnumDTO.SYSTEM_ADMIN.value, RoleEnumDTO.SYSTEM_VIEWER.value};
    }
}

