/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.internal.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.UserLevelEnumDTO;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.shared.RoleEnumDTO;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class UserDTO {
    private String id;
    private String name;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String accountId;
    private String tenantId;
    @Deprecated
    private Integer roleType;
    private Integer userType;
    private String omadacId;
    private Boolean verified;
    @Deprecated
    private Set<String> permissions;
    private Set<String> siteIds;
    private Map<String, String> siteInfos;
    private Boolean alert;
    private Boolean incidentNotification;
    private Boolean allSite;
    private String lastSite;
    private Date createdTime;
    private String parentUserId;
    private List<String> favorites;
    private List<String> favoritesCustomer;
    @Deprecated
    private String roleName;
    private Integer hotspotRoleType;
    private Boolean dismissFeedback;
    private Boolean devicesUpgradeNotification;
    private Boolean firmwareNotification;
    private String roleId;
    private String roleTypeName;
    private Integer userLevel;
    private String customerRoleId;
    private Set<String> customerIds;
    private Map<String, String> customerInfos;
    private Map<String, List<String>> customerFavoriteSites;
    private Boolean allCustomer;
    @Deprecated
    private String lastCustomer;
    private String externalUserGroupId;
    private Boolean openApiRequest;
    private Integer grantType;
    private String parentExternalUserId;
    private String idpId;
    private Boolean temporaryEnable;
    private Long startTime;
    private Long endTime;

    public static boolean validate(UserDTO userDTO) {
        if (userDTO == null || userDTO.getUserType() == null || RoleEnumDTO.resolve(userDTO.getUserType()) == null) {
            return false;
        }
        return !T.a((String)userDTO.getOmadacId());
    }

    @JsonIgnore
    public Optional<String> getUsernameOrCloudAccount() {
        return this.isCloudUser() ? Optional.ofNullable(this.email) : Optional.ofNullable(this.name);
    }

    @JsonIgnore
    public Optional<RoleEnumDTO> getRole() {
        if (this.roleType == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(RoleEnumDTO.resolve(this.roleType));
    }

    public boolean isCloudUser() {
        if (this.getUserType() != null) {
            return Objects.equals(UserTypeEnumDTO.CLOUD_USER.getValue(), this.getUserType());
        }
        return false;
    }

    public boolean isOwner() {
        return Objects.equals("master_admin_id", this.getRoleId()) || Objects.equals("msp_master_admin_id", this.getRoleId());
    }

    public boolean isRoot() {
        return this.isOwner() || Objects.equals("super_admin_id", this.getRoleId()) || Objects.equals("msp_super_admin_id", this.getRoleId()) || Objects.equals("customer_super_admin_id", this.getRoleId());
    }

    public boolean isMspUser() {
        return Objects.equals(UserLevelEnumDTO.MSP_USER.getLevel(), this.getUserLevel());
    }

    public String getControllerId() {
        return this.getOmadacId();
    }

    public boolean isDefaultRole() {
        return Objects.equals("master_admin_id", this.roleId) || Objects.equals("admin_id", this.roleId) || Objects.equals("viewer_id", this.roleId) || Objects.equals("super_admin_id", this.roleId) || Objects.equals("msp_master_admin_id", this.roleId) || Objects.equals("msp_admin_id", this.roleId) || Objects.equals("msp_viewer_id", this.roleId) || Objects.equals("msp_super_admin_id", this.roleId) || Objects.equals("customer_master_admin_id", this.roleId) || Objects.equals("customer_admin_id", this.roleId) || Objects.equals("customer_viewer_id", this.roleId) || Objects.equals("customer_super_admin_id", this.roleId);
    }

    public int userResource() {
        return Boolean.TRUE.equals(this.getOpenApiRequest()) ? 1 : 0;
    }

    public boolean verifyTemporaryUser() {
        if (this.temporaryEnable == null || !this.temporaryEnable.booleanValue()) {
            return true;
        }
        return this.startTime <= System.currentTimeMillis() && this.endTime >= System.currentTimeMillis();
    }

    public Set<String> getSiteIds() {
        if (this.siteIds == null) {
            return new HashSet<String>();
        }
        return this.siteIds;
    }

    @Generated
    public static UserDTOBuilder builder() {
        return new UserDTOBuilder();
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Deprecated
    @Generated
    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }

    @Generated
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    @Deprecated
    @Generated
    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public void setSiteIds(Set<String> siteIds) {
        this.siteIds = siteIds;
    }

    @Generated
    public void setSiteInfos(Map<String, String> siteInfos) {
        this.siteInfos = siteInfos;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setIncidentNotification(Boolean incidentNotification) {
        this.incidentNotification = incidentNotification;
    }

    @Generated
    public void setAllSite(Boolean allSite) {
        this.allSite = allSite;
    }

    @Generated
    public void setLastSite(String lastSite) {
        this.lastSite = lastSite;
    }

    @Generated
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setParentUserId(String parentUserId) {
        this.parentUserId = parentUserId;
    }

    @Generated
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    @Generated
    public void setFavoritesCustomer(List<String> favoritesCustomer) {
        this.favoritesCustomer = favoritesCustomer;
    }

    @Deprecated
    @Generated
    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Generated
    public void setHotspotRoleType(Integer hotspotRoleType) {
        this.hotspotRoleType = hotspotRoleType;
    }

    @Generated
    public void setDismissFeedback(Boolean dismissFeedback) {
        this.dismissFeedback = dismissFeedback;
    }

    @Generated
    public void setDevicesUpgradeNotification(Boolean devicesUpgradeNotification) {
        this.devicesUpgradeNotification = devicesUpgradeNotification;
    }

    @Generated
    public void setFirmwareNotification(Boolean firmwareNotification) {
        this.firmwareNotification = firmwareNotification;
    }

    @Generated
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @Generated
    public void setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
    }

    @Generated
    public void setUserLevel(Integer userLevel) {
        this.userLevel = userLevel;
    }

    @Generated
    public void setCustomerRoleId(String customerRoleId) {
        this.customerRoleId = customerRoleId;
    }

    @Generated
    public void setCustomerIds(Set<String> customerIds) {
        this.customerIds = customerIds;
    }

    @Generated
    public void setCustomerInfos(Map<String, String> customerInfos) {
        this.customerInfos = customerInfos;
    }

    @Generated
    public void setCustomerFavoriteSites(Map<String, List<String>> customerFavoriteSites) {
        this.customerFavoriteSites = customerFavoriteSites;
    }

    @Generated
    public void setAllCustomer(Boolean allCustomer) {
        this.allCustomer = allCustomer;
    }

    @Deprecated
    @Generated
    public void setLastCustomer(String lastCustomer) {
        this.lastCustomer = lastCustomer;
    }

    @Generated
    public void setExternalUserGroupId(String externalUserGroupId) {
        this.externalUserGroupId = externalUserGroupId;
    }

    @Generated
    public void setOpenApiRequest(Boolean openApiRequest) {
        this.openApiRequest = openApiRequest;
    }

    @Generated
    public void setGrantType(Integer grantType) {
        this.grantType = grantType;
    }

    @Generated
    public void setParentExternalUserId(String parentExternalUserId) {
        this.parentExternalUserId = parentExternalUserId;
    }

    @Generated
    public void setIdpId(String idpId) {
        this.idpId = idpId;
    }

    @Generated
    public void setTemporaryEnable(Boolean temporaryEnable) {
        this.temporaryEnable = temporaryEnable;
    }

    @Generated
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Deprecated
    @Generated
    public Integer getRoleType() {
        return this.roleType;
    }

    @Generated
    public Integer getUserType() {
        return this.userType;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public Boolean getVerified() {
        return this.verified;
    }

    @Deprecated
    @Generated
    public Set<String> getPermissions() {
        return this.permissions;
    }

    @Generated
    public Map<String, String> getSiteInfos() {
        return this.siteInfos;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Boolean getIncidentNotification() {
        return this.incidentNotification;
    }

    @Generated
    public Boolean getAllSite() {
        return this.allSite;
    }

    @Generated
    public String getLastSite() {
        return this.lastSite;
    }

    @Generated
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public String getParentUserId() {
        return this.parentUserId;
    }

    @Generated
    public List<String> getFavorites() {
        return this.favorites;
    }

    @Generated
    public List<String> getFavoritesCustomer() {
        return this.favoritesCustomer;
    }

    @Deprecated
    @Generated
    public String getRoleName() {
        return this.roleName;
    }

    @Generated
    public Integer getHotspotRoleType() {
        return this.hotspotRoleType;
    }

    @Generated
    public Boolean getDismissFeedback() {
        return this.dismissFeedback;
    }

    @Generated
    public Boolean getDevicesUpgradeNotification() {
        return this.devicesUpgradeNotification;
    }

    @Generated
    public Boolean getFirmwareNotification() {
        return this.firmwareNotification;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getRoleTypeName() {
        return this.roleTypeName;
    }

    @Generated
    public Integer getUserLevel() {
        return this.userLevel;
    }

    @Generated
    public String getCustomerRoleId() {
        return this.customerRoleId;
    }

    @Generated
    public Set<String> getCustomerIds() {
        return this.customerIds;
    }

    @Generated
    public Map<String, String> getCustomerInfos() {
        return this.customerInfos;
    }

    @Generated
    public Map<String, List<String>> getCustomerFavoriteSites() {
        return this.customerFavoriteSites;
    }

    @Generated
    public Boolean getAllCustomer() {
        return this.allCustomer;
    }

    @Deprecated
    @Generated
    public String getLastCustomer() {
        return this.lastCustomer;
    }

    @Generated
    public String getExternalUserGroupId() {
        return this.externalUserGroupId;
    }

    @Generated
    public Boolean getOpenApiRequest() {
        return this.openApiRequest;
    }

    @Generated
    public Integer getGrantType() {
        return this.grantType;
    }

    @Generated
    public String getParentExternalUserId() {
        return this.parentExternalUserId;
    }

    @Generated
    public String getIdpId() {
        return this.idpId;
    }

    @Generated
    public Boolean getTemporaryEnable() {
        return this.temporaryEnable;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public UserDTO() {
    }

    @Generated
    public UserDTO(String id, String name, String email, String accountId, String tenantId, Integer roleType, Integer userType, String omadacId, Boolean verified, Set<String> permissions, Set<String> siteIds, Map<String, String> siteInfos, Boolean alert, Boolean incidentNotification, Boolean allSite, String lastSite, Date createdTime, String parentUserId, List<String> favorites, List<String> favoritesCustomer, String roleName, Integer hotspotRoleType, Boolean dismissFeedback, Boolean devicesUpgradeNotification, Boolean firmwareNotification, String roleId, String roleTypeName, Integer userLevel, String customerRoleId, Set<String> customerIds, Map<String, String> customerInfos, Map<String, List<String>> customerFavoriteSites, Boolean allCustomer, String lastCustomer, String externalUserGroupId, Boolean openApiRequest, Integer grantType, String parentExternalUserId, String idpId, Boolean temporaryEnable, Long startTime, Long endTime) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.accountId = accountId;
        this.tenantId = tenantId;
        this.roleType = roleType;
        this.userType = userType;
        this.omadacId = omadacId;
        this.verified = verified;
        this.permissions = permissions;
        this.siteIds = siteIds;
        this.siteInfos = siteInfos;
        this.alert = alert;
        this.incidentNotification = incidentNotification;
        this.allSite = allSite;
        this.lastSite = lastSite;
        this.createdTime = createdTime;
        this.parentUserId = parentUserId;
        this.favorites = favorites;
        this.favoritesCustomer = favoritesCustomer;
        this.roleName = roleName;
        this.hotspotRoleType = hotspotRoleType;
        this.dismissFeedback = dismissFeedback;
        this.devicesUpgradeNotification = devicesUpgradeNotification;
        this.firmwareNotification = firmwareNotification;
        this.roleId = roleId;
        this.roleTypeName = roleTypeName;
        this.userLevel = userLevel;
        this.customerRoleId = customerRoleId;
        this.customerIds = customerIds;
        this.customerInfos = customerInfos;
        this.customerFavoriteSites = customerFavoriteSites;
        this.allCustomer = allCustomer;
        this.lastCustomer = lastCustomer;
        this.externalUserGroupId = externalUserGroupId;
        this.openApiRequest = openApiRequest;
        this.grantType = grantType;
        this.parentExternalUserId = parentExternalUserId;
        this.idpId = idpId;
        this.temporaryEnable = temporaryEnable;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Generated
    public String toString() {
        return "UserDTO(id=" + this.getId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", accountId=" + this.getAccountId() + ", tenantId=" + this.getTenantId() + ", roleType=" + this.getRoleType() + ", userType=" + this.getUserType() + ", omadacId=" + this.getOmadacId() + ", verified=" + this.getVerified() + ", permissions=" + this.getPermissions() + ", siteIds=" + this.getSiteIds() + ", siteInfos=" + this.getSiteInfos() + ", alert=" + this.getAlert() + ", incidentNotification=" + this.getIncidentNotification() + ", allSite=" + this.getAllSite() + ", lastSite=" + this.getLastSite() + ", createdTime=" + this.getCreatedTime() + ", parentUserId=" + this.getParentUserId() + ", favorites=" + this.getFavorites() + ", favoritesCustomer=" + this.getFavoritesCustomer() + ", roleName=" + this.getRoleName() + ", hotspotRoleType=" + this.getHotspotRoleType() + ", dismissFeedback=" + this.getDismissFeedback() + ", devicesUpgradeNotification=" + this.getDevicesUpgradeNotification() + ", firmwareNotification=" + this.getFirmwareNotification() + ", roleId=" + this.getRoleId() + ", roleTypeName=" + this.getRoleTypeName() + ", userLevel=" + this.getUserLevel() + ", customerRoleId=" + this.getCustomerRoleId() + ", customerIds=" + this.getCustomerIds() + ", customerInfos=" + this.getCustomerInfos() + ", customerFavoriteSites=" + this.getCustomerFavoriteSites() + ", allCustomer=" + this.getAllCustomer() + ", lastCustomer=" + this.getLastCustomer() + ", externalUserGroupId=" + this.getExternalUserGroupId() + ", openApiRequest=" + this.getOpenApiRequest() + ", grantType=" + this.getGrantType() + ", parentExternalUserId=" + this.getParentExternalUserId() + ", idpId=" + this.getIdpId() + ", temporaryEnable=" + this.getTemporaryEnable() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }

    @Generated
    public static class UserDTOBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String email;
        @Generated
        private String accountId;
        @Generated
        private String tenantId;
        @Generated
        private Integer roleType;
        @Generated
        private Integer userType;
        @Generated
        private String omadacId;
        @Generated
        private Boolean verified;
        @Generated
        private Set<String> permissions;
        @Generated
        private Set<String> siteIds;
        @Generated
        private Map<String, String> siteInfos;
        @Generated
        private Boolean alert;
        @Generated
        private Boolean incidentNotification;
        @Generated
        private Boolean allSite;
        @Generated
        private String lastSite;
        @Generated
        private Date createdTime;
        @Generated
        private String parentUserId;
        @Generated
        private List<String> favorites;
        @Generated
        private List<String> favoritesCustomer;
        @Generated
        private String roleName;
        @Generated
        private Integer hotspotRoleType;
        @Generated
        private Boolean dismissFeedback;
        @Generated
        private Boolean devicesUpgradeNotification;
        @Generated
        private Boolean firmwareNotification;
        @Generated
        private String roleId;
        @Generated
        private String roleTypeName;
        @Generated
        private Integer userLevel;
        @Generated
        private String customerRoleId;
        @Generated
        private Set<String> customerIds;
        @Generated
        private Map<String, String> customerInfos;
        @Generated
        private Map<String, List<String>> customerFavoriteSites;
        @Generated
        private Boolean allCustomer;
        @Generated
        private String lastCustomer;
        @Generated
        private String externalUserGroupId;
        @Generated
        private Boolean openApiRequest;
        @Generated
        private Integer grantType;
        @Generated
        private String parentExternalUserId;
        @Generated
        private String idpId;
        @Generated
        private Boolean temporaryEnable;
        @Generated
        private Long startTime;
        @Generated
        private Long endTime;

        @Generated
        UserDTOBuilder() {
        }

        @Generated
        public UserDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public UserDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public UserDTOBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public UserDTOBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public UserDTOBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Deprecated
        @Generated
        public UserDTOBuilder roleType(Integer roleType) {
            this.roleType = roleType;
            return this;
        }

        @Generated
        public UserDTOBuilder userType(Integer userType) {
            this.userType = userType;
            return this;
        }

        @Generated
        public UserDTOBuilder omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this;
        }

        @Generated
        public UserDTOBuilder verified(Boolean verified) {
            this.verified = verified;
            return this;
        }

        @Deprecated
        @Generated
        public UserDTOBuilder permissions(Set<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        @Generated
        public UserDTOBuilder siteIds(Set<String> siteIds) {
            this.siteIds = siteIds;
            return this;
        }

        @Generated
        public UserDTOBuilder siteInfos(Map<String, String> siteInfos) {
            this.siteInfos = siteInfos;
            return this;
        }

        @Generated
        public UserDTOBuilder alert(Boolean alert) {
            this.alert = alert;
            return this;
        }

        @Generated
        public UserDTOBuilder incidentNotification(Boolean incidentNotification) {
            this.incidentNotification = incidentNotification;
            return this;
        }

        @Generated
        public UserDTOBuilder allSite(Boolean allSite) {
            this.allSite = allSite;
            return this;
        }

        @Generated
        public UserDTOBuilder lastSite(String lastSite) {
            this.lastSite = lastSite;
            return this;
        }

        @Generated
        public UserDTOBuilder createdTime(Date createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public UserDTOBuilder parentUserId(String parentUserId) {
            this.parentUserId = parentUserId;
            return this;
        }

        @Generated
        public UserDTOBuilder favorites(List<String> favorites) {
            this.favorites = favorites;
            return this;
        }

        @Generated
        public UserDTOBuilder favoritesCustomer(List<String> favoritesCustomer) {
            this.favoritesCustomer = favoritesCustomer;
            return this;
        }

        @Deprecated
        @Generated
        public UserDTOBuilder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Generated
        public UserDTOBuilder hotspotRoleType(Integer hotspotRoleType) {
            this.hotspotRoleType = hotspotRoleType;
            return this;
        }

        @Generated
        public UserDTOBuilder dismissFeedback(Boolean dismissFeedback) {
            this.dismissFeedback = dismissFeedback;
            return this;
        }

        @Generated
        public UserDTOBuilder devicesUpgradeNotification(Boolean devicesUpgradeNotification) {
            this.devicesUpgradeNotification = devicesUpgradeNotification;
            return this;
        }

        @Generated
        public UserDTOBuilder firmwareNotification(Boolean firmwareNotification) {
            this.firmwareNotification = firmwareNotification;
            return this;
        }

        @Generated
        public UserDTOBuilder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        @Generated
        public UserDTOBuilder roleTypeName(String roleTypeName) {
            this.roleTypeName = roleTypeName;
            return this;
        }

        @Generated
        public UserDTOBuilder userLevel(Integer userLevel) {
            this.userLevel = userLevel;
            return this;
        }

        @Generated
        public UserDTOBuilder customerRoleId(String customerRoleId) {
            this.customerRoleId = customerRoleId;
            return this;
        }

        @Generated
        public UserDTOBuilder customerIds(Set<String> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        @Generated
        public UserDTOBuilder customerInfos(Map<String, String> customerInfos) {
            this.customerInfos = customerInfos;
            return this;
        }

        @Generated
        public UserDTOBuilder customerFavoriteSites(Map<String, List<String>> customerFavoriteSites) {
            this.customerFavoriteSites = customerFavoriteSites;
            return this;
        }

        @Generated
        public UserDTOBuilder allCustomer(Boolean allCustomer) {
            this.allCustomer = allCustomer;
            return this;
        }

        @Deprecated
        @Generated
        public UserDTOBuilder lastCustomer(String lastCustomer) {
            this.lastCustomer = lastCustomer;
            return this;
        }

        @Generated
        public UserDTOBuilder externalUserGroupId(String externalUserGroupId) {
            this.externalUserGroupId = externalUserGroupId;
            return this;
        }

        @Generated
        public UserDTOBuilder openApiRequest(Boolean openApiRequest) {
            this.openApiRequest = openApiRequest;
            return this;
        }

        @Generated
        public UserDTOBuilder grantType(Integer grantType) {
            this.grantType = grantType;
            return this;
        }

        @Generated
        public UserDTOBuilder parentExternalUserId(String parentExternalUserId) {
            this.parentExternalUserId = parentExternalUserId;
            return this;
        }

        @Generated
        public UserDTOBuilder idpId(String idpId) {
            this.idpId = idpId;
            return this;
        }

        @Generated
        public UserDTOBuilder temporaryEnable(Boolean temporaryEnable) {
            this.temporaryEnable = temporaryEnable;
            return this;
        }

        @Generated
        public UserDTOBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public UserDTOBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        @Generated
        public UserDTO build() {
            return new UserDTO(this.id, this.name, this.email, this.accountId, this.tenantId, this.roleType, this.userType, this.omadacId, this.verified, this.permissions, this.siteIds, this.siteInfos, this.alert, this.incidentNotification, this.allSite, this.lastSite, this.createdTime, this.parentUserId, this.favorites, this.favoritesCustomer, this.roleName, this.hotspotRoleType, this.dismissFeedback, this.devicesUpgradeNotification, this.firmwareNotification, this.roleId, this.roleTypeName, this.userLevel, this.customerRoleId, this.customerIds, this.customerInfos, this.customerFavoriteSites, this.allCustomer, this.lastCustomer, this.externalUserGroupId, this.openApiRequest, this.grantType, this.parentExternalUserId, this.idpId, this.temporaryEnable, this.startTime, this.endTime);
        }

        @Generated
        public String toString() {
            return "UserDTO.UserDTOBuilder(id=" + this.id + ", name=" + this.name + ", email=" + this.email + ", accountId=" + this.accountId + ", tenantId=" + this.tenantId + ", roleType=" + this.roleType + ", userType=" + this.userType + ", omadacId=" + this.omadacId + ", verified=" + this.verified + ", permissions=" + this.permissions + ", siteIds=" + this.siteIds + ", siteInfos=" + this.siteInfos + ", alert=" + this.alert + ", incidentNotification=" + this.incidentNotification + ", allSite=" + this.allSite + ", lastSite=" + this.lastSite + ", createdTime=" + this.createdTime + ", parentUserId=" + this.parentUserId + ", favorites=" + this.favorites + ", favoritesCustomer=" + this.favoritesCustomer + ", roleName=" + this.roleName + ", hotspotRoleType=" + this.hotspotRoleType + ", dismissFeedback=" + this.dismissFeedback + ", devicesUpgradeNotification=" + this.devicesUpgradeNotification + ", firmwareNotification=" + this.firmwareNotification + ", roleId=" + this.roleId + ", roleTypeName=" + this.roleTypeName + ", userLevel=" + this.userLevel + ", customerRoleId=" + this.customerRoleId + ", customerIds=" + this.customerIds + ", customerInfos=" + this.customerInfos + ", customerFavoriteSites=" + this.customerFavoriteSites + ", allCustomer=" + this.allCustomer + ", lastCustomer=" + this.lastCustomer + ", externalUserGroupId=" + this.externalUserGroupId + ", openApiRequest=" + this.openApiRequest + ", grantType=" + this.grantType + ", parentExternalUserId=" + this.parentExternalUserId + ", idpId=" + this.idpId + ", temporaryEnable=" + this.temporaryEnable + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
        }
    }
}

