/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.external.dto.openapi;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;

public class CreateMspUserVO {
    @Schema(name="type", description="Type of user should be a value as follows: 0:local user; 1: cloud user")
    @NotNull(message="user type should not be null")
    private @NotNull(message="user type should not be null") Integer type;
    @Schema(name="name", description="User name. When creating cloud user, you should set TP-LINK ID. It should contain 1 to 128 ASCII visible characters and start with letters, numbers, and underscores.")
    @NotNull(message="user name should not be null")
    @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    private @NotNull(message="user name should not be null") @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") String name;
    @Schema(name="password", description="Password of local user should contain 8 to 128 ASCII visible characters.And password must be a combination of uppercase letters, lowercase letters, numbers, and special symbols. Symbols such as ! # $ % & * @ ^ are supported.")
    @Pattern(regexp="^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\!\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~])(?!.*[\\00-\\040\\042\\077\\0177]).{8,128}$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Pattern(regexp="^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\!\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~])(?!.*[\\00-\\040\\042\\077\\0177]).{8,128}$", message="Invalid password.") String password;
    @Schema(name="email", description="Email of user")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    @Schema(name="roleId", description="Msp role ID of user")
    @NotNull(message="user role id should not be null")
    private @NotNull(message="user role id should not be null") String roleId;
    @Schema(name="customerRoleId", description="Msp user's customer role ID when visit customer")
    @NotNull(message="msp user customer role id should not be null")
    private @NotNull(message="msp user customer role id should not be null") String customerRoleId;
    @Schema(name="allCustomer", description="Whether msp user has all customer permission, including new created customer.")
    @NotNull(message="allCustomer should not be null")
    private @NotNull(message="allCustomer should not be null") Boolean allCustomer;
    @Schema(name="customers", description="User customer privilege list")
    private Set<String> customers;
    @Schema(name="alert", description="Whether this user want to receive alert emails")
    private Boolean alert;
    @Schema(name="temporaryEnable", description="Whether the user wants to enable the temporary worker permission")
    private Boolean temporaryEnable;
    @Schema(name="startTime", description="The start time of the user's validity period. time range: start timestamp (Millisecond).")
    private Long startTime;
    @Schema(name="endTime", description="The end time of the user's validity period. time range: end timestamp (Millisecond).")
    private Long endTime;

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getCustomerRoleId() {
        return this.customerRoleId;
    }

    @Generated
    public Boolean getAllCustomer() {
        return this.allCustomer;
    }

    @Generated
    public Set<String> getCustomers() {
        return this.customers;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Boolean getTemporaryEnable() {
        return this.temporaryEnable;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    @Generated
    public void setCustomerRoleId(String customerRoleId) {
        this.customerRoleId = customerRoleId;
    }

    @Generated
    public void setAllCustomer(Boolean allCustomer) {
        this.allCustomer = allCustomer;
    }

    @Generated
    public void setCustomers(Set<String> customers) {
        this.customers = customers;
    }

    @Generated
    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    @Generated
    public void setTemporaryEnable(Boolean temporaryEnable) {
        this.temporaryEnable = temporaryEnable;
    }

    @Generated
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public CreateMspUserVO() {
    }

    @Generated
    public CreateMspUserVO(Integer type, String name, String password, String email, String roleId, String customerRoleId, Boolean allCustomer, Set<String> customers, Boolean alert, Boolean temporaryEnable, Long startTime, Long endTime) {
        this.type = type;
        this.name = name;
        this.password = password;
        this.email = email;
        this.roleId = roleId;
        this.customerRoleId = customerRoleId;
        this.allCustomer = allCustomer;
        this.customers = customers;
        this.alert = alert;
        this.temporaryEnable = temporaryEnable;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Generated
    public String toString() {
        return "CreateMspUserVO(type=" + this.getType() + ", name=" + this.getName() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", roleId=" + this.getRoleId() + ", customerRoleId=" + this.getCustomerRoleId() + ", allCustomer=" + this.getAllCustomer() + ", customers=" + this.getCustomers() + ", alert=" + this.getAlert() + ", temporaryEnable=" + this.getTemporaryEnable() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

