/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.external.dto.ipaccessrule;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

public class IpAccessRuleVO {
    private String id;
    private String omadacId;
    @NotNull
    @NumberSet(value={0, 1, 2}, message="Ip Access Rule parameter [ipAccessType] should be 0 or 1 or 2")
    private Integer ipAccessType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid single ip address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid single ip address.") String singleIpAddress;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid single subnet mask.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", message="Invalid single subnet mask.") String singleSubnetMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range start address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range start address.") String ipRangeStart;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range end address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip range end address.") String ipRangeEnd;
    private String protocolVersion;
    private Boolean currentIp;
    @NotNull
    private String description;

    public IpAccessRuleVO(String id, String omadacId, Integer ipAccessType, String singleIpAddress, String singleSubnetMask, String ipRangeStart, String ipRangeEnd, Boolean currentIp, String description) {
        this.id = id;
        this.omadacId = omadacId;
        this.ipAccessType = ipAccessType;
        this.singleIpAddress = singleIpAddress;
        this.singleSubnetMask = singleSubnetMask;
        this.ipRangeStart = ipRangeStart;
        this.ipRangeEnd = ipRangeEnd;
        this.currentIp = currentIp;
        this.description = description;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public Integer getIpAccessType() {
        return this.ipAccessType;
    }

    @Generated
    public String getSingleIpAddress() {
        return this.singleIpAddress;
    }

    @Generated
    public String getSingleSubnetMask() {
        return this.singleSubnetMask;
    }

    @Generated
    public String getIpRangeStart() {
        return this.ipRangeStart;
    }

    @Generated
    public String getIpRangeEnd() {
        return this.ipRangeEnd;
    }

    @Generated
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Generated
    public Boolean getCurrentIp() {
        return this.currentIp;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setIpAccessType(Integer ipAccessType) {
        this.ipAccessType = ipAccessType;
    }

    @Generated
    public void setSingleIpAddress(String singleIpAddress) {
        this.singleIpAddress = singleIpAddress;
    }

    @Generated
    public void setSingleSubnetMask(String singleSubnetMask) {
        this.singleSubnetMask = singleSubnetMask;
    }

    @Generated
    public void setIpRangeStart(String ipRangeStart) {
        this.ipRangeStart = ipRangeStart;
    }

    @Generated
    public void setIpRangeEnd(String ipRangeEnd) {
        this.ipRangeEnd = ipRangeEnd;
    }

    @Generated
    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Generated
    public void setCurrentIp(Boolean currentIp) {
        this.currentIp = currentIp;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public IpAccessRuleVO() {
    }

    @Generated
    public IpAccessRuleVO(String id, String omadacId, Integer ipAccessType, String singleIpAddress, String singleSubnetMask, String ipRangeStart, String ipRangeEnd, String protocolVersion, Boolean currentIp, String description) {
        this.id = id;
        this.omadacId = omadacId;
        this.ipAccessType = ipAccessType;
        this.singleIpAddress = singleIpAddress;
        this.singleSubnetMask = singleSubnetMask;
        this.ipRangeStart = ipRangeStart;
        this.ipRangeEnd = ipRangeEnd;
        this.protocolVersion = protocolVersion;
        this.currentIp = currentIp;
        this.description = description;
    }

    @Generated
    public String toString() {
        return "IpAccessRuleVO(id=" + this.getId() + ", omadacId=" + this.getOmadacId() + ", ipAccessType=" + this.getIpAccessType() + ", singleIpAddress=" + this.getSingleIpAddress() + ", singleSubnetMask=" + this.getSingleSubnetMask() + ", ipRangeStart=" + this.getIpRangeStart() + ", ipRangeEnd=" + this.getIpRangeEnd() + ", protocolVersion=" + this.getProtocolVersion() + ", currentIp=" + this.getCurrentIp() + ", description=" + this.getDescription() + ")";
    }
}

