/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.external.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.f.a;
import com.tplink.smb.omada.identityaccess.api.external.dto.MspInfoVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.PrivilegeResultVO;
import com.tplink.smb.omada.identityaccess.api.external.dto.RoleDetailVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class UserVO {
    private String id;
    @NotNull
    private Integer type;
    private Integer roleType;
    private String roleId;
    private String roleName;
    @NotNull
    @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    private @NotNull @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") String name;
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{6,126}[\\041-\\0176]$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{6,126}[\\041-\\0176]$", message="Invalid password.") String password;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String omadacId;
    private String mspId;
    private Boolean adopt;
    private Boolean manage;
    private Boolean license;
    private Boolean licenseBind;
    private Boolean siteManage;
    private Boolean verified;
    private Boolean alert;
    private PrivilegeResultVO privilege;
    private List<PrivilegeResultVO> sitePrivileges;
    private String token;
    private String viewerParentUserId;
    private Boolean showTree;
    private String parentUserId;
    private List<String> favorites;
    private List<String> favoritesCustomer;
    private Integer disaster;
    private Boolean needFeedback;
    @JsonIgnore
    private String lastSite;
    @JsonIgnore
    private Boolean allSite;
    @JsonIgnore
    private Set<String> siteIds;
    private Boolean defaultSite;
    private boolean forceModify;
    private boolean dbnormal;
    private Integer view;
    private Boolean incidentNotification;
    private Boolean root;
    private Integer pattern;
    private MspInfoVO mspInfo;
    private Integer userLevel;
    private RoleDetailVO roleDetail;
    private Boolean temporaryEnable;
    private Long startTime;
    private Long endTime;

    public boolean validate() {
        this.type = this.getType();
        if (this.type == null) {
            return false;
        }
        UserTypeEnumDTO userTypeEnum = UserTypeEnumDTO.resolve((Integer)this.type);
        if (userTypeEnum == null) {
            return false;
        }
        if (UserTypeEnumDTO.CLOUD_USER.equals((Object)userTypeEnum) && !a.b((String)this.name)) {
            return false;
        }
        if (!T.a((String)this.password) && !a.c((String)this.password)) {
            return false;
        }
        return T.a((String)this.email) || a.a((String)this.email);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getRoleType() {
        return this.roleType;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getRoleName() {
        return this.roleName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getMspId() {
        return this.mspId;
    }

    @Generated
    public Boolean getAdopt() {
        return this.adopt;
    }

    @Generated
    public Boolean getManage() {
        return this.manage;
    }

    @Generated
    public Boolean getLicense() {
        return this.license;
    }

    @Generated
    public Boolean getLicenseBind() {
        return this.licenseBind;
    }

    @Generated
    public Boolean getSiteManage() {
        return this.siteManage;
    }

    @Generated
    public Boolean getVerified() {
        return this.verified;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public PrivilegeResultVO getPrivilege() {
        return this.privilege;
    }

    @Generated
    public List<PrivilegeResultVO> getSitePrivileges() {
        return this.sitePrivileges;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getViewerParentUserId() {
        return this.viewerParentUserId;
    }

    @Generated
    public Boolean getShowTree() {
        return this.showTree;
    }

    @Generated
    public String getParentUserId() {
        return this.parentUserId;
    }

    @Generated
    public List<String> getFavorites() {
        return this.favorites;
    }

    @Generated
    public List<String> getFavoritesCustomer() {
        return this.favoritesCustomer;
    }

    @Generated
    public Integer getDisaster() {
        return this.disaster;
    }

    @Generated
    public Boolean getNeedFeedback() {
        return this.needFeedback;
    }

    @Generated
    public String getLastSite() {
        return this.lastSite;
    }

    @Generated
    public Boolean getAllSite() {
        return this.allSite;
    }

    @Generated
    public Set<String> getSiteIds() {
        return this.siteIds;
    }

    @Generated
    public Boolean getDefaultSite() {
        return this.defaultSite;
    }

    @Generated
    public boolean isForceModify() {
        return this.forceModify;
    }

    @Generated
    public boolean isDbnormal() {
        return this.dbnormal;
    }

    @Generated
    public Integer getView() {
        return this.view;
    }

    @Generated
    public Boolean getIncidentNotification() {
        return this.incidentNotification;
    }

    @Generated
    public Boolean getRoot() {
        return this.root;
    }

    @Generated
    public Integer getPattern() {
        return this.pattern;
    }

    @Generated
    public MspInfoVO getMspInfo() {
        return this.mspInfo;
    }

    @Generated
    public Integer getUserLevel() {
        return this.userLevel;
    }

    @Generated
    public RoleDetailVO getRoleDetail() {
        return this.roleDetail;
    }

    @Generated
    public Boolean getTemporaryEnable() {
        return this.temporaryEnable;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public UserVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public UserVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public UserVO setRoleType(Integer roleType) {
        this.roleType = roleType;
        return this;
    }

    @Generated
    public UserVO setRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Generated
    public UserVO setRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @Generated
    public UserVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public UserVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public UserVO setEmail(String email) {
        this.email = email;
        return this;
    }

    @Generated
    public UserVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public UserVO setMspId(String mspId) {
        this.mspId = mspId;
        return this;
    }

    @Generated
    public UserVO setAdopt(Boolean adopt) {
        this.adopt = adopt;
        return this;
    }

    @Generated
    public UserVO setManage(Boolean manage) {
        this.manage = manage;
        return this;
    }

    @Generated
    public UserVO setLicense(Boolean license) {
        this.license = license;
        return this;
    }

    @Generated
    public UserVO setLicenseBind(Boolean licenseBind) {
        this.licenseBind = licenseBind;
        return this;
    }

    @Generated
    public UserVO setSiteManage(Boolean siteManage) {
        this.siteManage = siteManage;
        return this;
    }

    @Generated
    public UserVO setVerified(Boolean verified) {
        this.verified = verified;
        return this;
    }

    @Generated
    public UserVO setAlert(Boolean alert) {
        this.alert = alert;
        return this;
    }

    @Generated
    public UserVO setPrivilege(PrivilegeResultVO privilege) {
        this.privilege = privilege;
        return this;
    }

    @Generated
    public UserVO setSitePrivileges(List<PrivilegeResultVO> sitePrivileges) {
        this.sitePrivileges = sitePrivileges;
        return this;
    }

    @Generated
    public UserVO setToken(String token) {
        this.token = token;
        return this;
    }

    @Generated
    public UserVO setViewerParentUserId(String viewerParentUserId) {
        this.viewerParentUserId = viewerParentUserId;
        return this;
    }

    @Generated
    public UserVO setShowTree(Boolean showTree) {
        this.showTree = showTree;
        return this;
    }

    @Generated
    public UserVO setParentUserId(String parentUserId) {
        this.parentUserId = parentUserId;
        return this;
    }

    @Generated
    public UserVO setFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @Generated
    public UserVO setFavoritesCustomer(List<String> favoritesCustomer) {
        this.favoritesCustomer = favoritesCustomer;
        return this;
    }

    @Generated
    public UserVO setDisaster(Integer disaster) {
        this.disaster = disaster;
        return this;
    }

    @Generated
    public UserVO setNeedFeedback(Boolean needFeedback) {
        this.needFeedback = needFeedback;
        return this;
    }

    @JsonIgnore
    @Generated
    public UserVO setLastSite(String lastSite) {
        this.lastSite = lastSite;
        return this;
    }

    @JsonIgnore
    @Generated
    public UserVO setAllSite(Boolean allSite) {
        this.allSite = allSite;
        return this;
    }

    @JsonIgnore
    @Generated
    public UserVO setSiteIds(Set<String> siteIds) {
        this.siteIds = siteIds;
        return this;
    }

    @Generated
    public UserVO setDefaultSite(Boolean defaultSite) {
        this.defaultSite = defaultSite;
        return this;
    }

    @Generated
    public UserVO setForceModify(boolean forceModify) {
        this.forceModify = forceModify;
        return this;
    }

    @Generated
    public UserVO setDbnormal(boolean dbnormal) {
        this.dbnormal = dbnormal;
        return this;
    }

    @Generated
    public UserVO setView(Integer view) {
        this.view = view;
        return this;
    }

    @Generated
    public UserVO setIncidentNotification(Boolean incidentNotification) {
        this.incidentNotification = incidentNotification;
        return this;
    }

    @Generated
    public UserVO setRoot(Boolean root) {
        this.root = root;
        return this;
    }

    @Generated
    public UserVO setPattern(Integer pattern) {
        this.pattern = pattern;
        return this;
    }

    @Generated
    public UserVO setMspInfo(MspInfoVO mspInfo) {
        this.mspInfo = mspInfo;
        return this;
    }

    @Generated
    public UserVO setUserLevel(Integer userLevel) {
        this.userLevel = userLevel;
        return this;
    }

    @Generated
    public UserVO setRoleDetail(RoleDetailVO roleDetail) {
        this.roleDetail = roleDetail;
        return this;
    }

    @Generated
    public UserVO setTemporaryEnable(Boolean temporaryEnable) {
        this.temporaryEnable = temporaryEnable;
        return this;
    }

    @Generated
    public UserVO setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public UserVO setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public UserVO() {
    }

    @Generated
    public String toString() {
        return "UserVO(id=" + this.getId() + ", type=" + this.getType() + ", roleType=" + this.getRoleType() + ", roleId=" + this.getRoleId() + ", roleName=" + this.getRoleName() + ", name=" + this.getName() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", omadacId=" + this.getOmadacId() + ", mspId=" + this.getMspId() + ", adopt=" + this.getAdopt() + ", manage=" + this.getManage() + ", license=" + this.getLicense() + ", licenseBind=" + this.getLicenseBind() + ", siteManage=" + this.getSiteManage() + ", verified=" + this.getVerified() + ", alert=" + this.getAlert() + ", privilege=" + this.getPrivilege() + ", sitePrivileges=" + this.getSitePrivileges() + ", token=" + this.getToken() + ", viewerParentUserId=" + this.getViewerParentUserId() + ", showTree=" + this.getShowTree() + ", parentUserId=" + this.getParentUserId() + ", favorites=" + this.getFavorites() + ", favoritesCustomer=" + this.getFavoritesCustomer() + ", disaster=" + this.getDisaster() + ", needFeedback=" + this.getNeedFeedback() + ", lastSite=" + this.getLastSite() + ", allSite=" + this.getAllSite() + ", siteIds=" + this.getSiteIds() + ", defaultSite=" + this.getDefaultSite() + ", forceModify=" + this.isForceModify() + ", dbnormal=" + this.isDbnormal() + ", view=" + this.getView() + ", incidentNotification=" + this.getIncidentNotification() + ", root=" + this.getRoot() + ", pattern=" + this.getPattern() + ", mspInfo=" + this.getMspInfo() + ", userLevel=" + this.getUserLevel() + ", roleDetail=" + this.getRoleDetail() + ", temporaryEnable=" + this.getTemporaryEnable() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

