/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.external.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.f.a;
import com.tplink.smb.omada.identityaccess.api.external.dto.SitePrivilegeVO;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

public class ModifyUserVO {
    @NotNull
    private Integer type;
    private String roleId;
    @NotNull
    @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") String name;
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{6,126}[\\041-\\0176]$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{6,126}[\\041-\\0176]$", message="Invalid password.") String password;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    private String omadacId;
    private Boolean alert;
    @Deprecated
    private SitePrivilegeVO privilege;
    private String viewerParentUserId;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String token;
    private Boolean incidentNotification;
    private boolean forceModify;
    private List<SitePrivilegeVO> sitePrivileges;
    private Boolean temporaryEnable;
    private Long startTime;
    private Long endTime;

    public boolean validate() {
        this.type = this.getType();
        if (this.type == null) {
            return false;
        }
        UserTypeEnumDTO userTypeEnum = UserTypeEnumDTO.resolve((Integer)this.type);
        if (userTypeEnum == null) {
            return false;
        }
        if (UserTypeEnumDTO.CLOUD_USER.equals((Object)userTypeEnum) && !a.b((String)this.name)) {
            return false;
        }
        if (!T.a((String)this.password) && !a.c((String)this.password)) {
            return false;
        }
        return T.a((String)this.email) || a.a((String)this.email);
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Deprecated
    @Generated
    public SitePrivilegeVO getPrivilege() {
        return this.privilege;
    }

    @Generated
    public String getViewerParentUserId() {
        return this.viewerParentUserId;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public Boolean getIncidentNotification() {
        return this.incidentNotification;
    }

    @Generated
    public boolean isForceModify() {
        return this.forceModify;
    }

    @Generated
    public List<SitePrivilegeVO> getSitePrivileges() {
        return this.sitePrivileges;
    }

    @Generated
    public Boolean getTemporaryEnable() {
        return this.temporaryEnable;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public ModifyUserVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public ModifyUserVO setRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Generated
    public ModifyUserVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ModifyUserVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public ModifyUserVO setEmail(String email) {
        this.email = email;
        return this;
    }

    @Generated
    public ModifyUserVO setOmadacId(String omadacId) {
        this.omadacId = omadacId;
        return this;
    }

    @Generated
    public ModifyUserVO setAlert(Boolean alert) {
        this.alert = alert;
        return this;
    }

    @Deprecated
    @Generated
    public ModifyUserVO setPrivilege(SitePrivilegeVO privilege) {
        this.privilege = privilege;
        return this;
    }

    @Generated
    public ModifyUserVO setViewerParentUserId(String viewerParentUserId) {
        this.viewerParentUserId = viewerParentUserId;
        return this;
    }

    @Generated
    public ModifyUserVO setToken(String token) {
        this.token = token;
        return this;
    }

    @Generated
    public ModifyUserVO setIncidentNotification(Boolean incidentNotification) {
        this.incidentNotification = incidentNotification;
        return this;
    }

    @Generated
    public ModifyUserVO setForceModify(boolean forceModify) {
        this.forceModify = forceModify;
        return this;
    }

    @Generated
    public ModifyUserVO setSitePrivileges(List<SitePrivilegeVO> sitePrivileges) {
        this.sitePrivileges = sitePrivileges;
        return this;
    }

    @Generated
    public ModifyUserVO setTemporaryEnable(Boolean temporaryEnable) {
        this.temporaryEnable = temporaryEnable;
        return this;
    }

    @Generated
    public ModifyUserVO setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public ModifyUserVO setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public ModifyUserVO() {
    }

    @Generated
    public String toString() {
        return "ModifyUserVO(type=" + this.getType() + ", roleId=" + this.getRoleId() + ", name=" + this.getName() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", omadacId=" + this.getOmadacId() + ", alert=" + this.getAlert() + ", privilege=" + this.getPrivilege() + ", viewerParentUserId=" + this.getViewerParentUserId() + ", token=" + this.getToken() + ", incidentNotification=" + this.getIncidentNotification() + ", forceModify=" + this.isForceModify() + ", sitePrivileges=" + this.getSitePrivileges() + ", temporaryEnable=" + this.getTemporaryEnable() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

