/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.openapi.vo.CreatedResIdOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.vouchergroup.VoucherScheduleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class VoucherScheduleOpenApiVO {
    @JsonIgnore
    private static final ImmutableSet<Integer> WEEKLY_DAYS_RANGE = ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object[])new Integer[]{7});
    @Schema(name="type", description="The type of schedule. It should be a value as follows: 0: Limit time by daily, 1: Limit time by weekly")
    @NotNull(message="Parameter [type] should not be null.")
    @NumberSet(value={0, 1})
    private @NotNull(message="Parameter [type] should not be null.") Integer type;
    @Schema(name="dailyStartHour", description="The hour of start time, should be within the range of 0-23. When parameter [type] is 0, parameter [dailyStartHour] is required")
    @Range(min=0L, max=23L)
    private @Range(min=0L, max=23L) Integer dailyStartHour;
    @Schema(name="dailyStartMin", description="The minute of start time, should be within the range of 0-59 When parameter [type] is 0, parameter [dailyStartMin] is required")
    @Range(min=0L, max=59L)
    private @Range(min=0L, max=59L) Integer dailyStartMin;
    @Schema(name="dailyEndHour", description="The hour of end time, should be within the range of 0-23 When parameter [type] is 0, parameter [dailyEndHour] is required")
    @Range(min=0L, max=23L)
    private @Range(min=0L, max=23L) Integer dailyEndHour;
    @Schema(name="dailyEndMin", description="The minute of end time, should be within the range of 0-59 When parameter [type] is 0, parameter [dailyEndMin] is required")
    @Range(min=0L, max=59L)
    private @Range(min=0L, max=59L) Integer dailyEndMin;
    @Schema(name="weeklyEnableDays", description="The effective days of week, array number should be within the range of 1-7, 1 represents Monday, 2 represents Tuesday... 7 represents Sunday. When parameter [type] is 1, parameter [weeklyEnableDays] is required")
    private Set<Integer> weeklyEnableDays;

    @JsonIgnore
    public VoucherScheduleVO toVO() {
        return VoucherScheduleVO.builder().type(this.type).dailyStartHour(this.dailyStartHour).dailyStartMin(this.dailyStartMin).dailyEndHour(this.dailyEndHour).dailyEndMin(this.dailyEndMin).weeklyEnableDays(this.weeklyEnableDays).build();
    }

    @JsonIgnore
    public static VoucherScheduleOpenApiVO toOpenApiVO(VoucherScheduleVO vo) {
        if (vo == null) {
            return null;
        }
        return VoucherScheduleOpenApiVO.builder().type(vo.getType()).dailyStartHour(vo.getDailyStartHour()).dailyStartMin(vo.getDailyStartMin()).dailyEndHour(vo.getDailyEndHour()).dailyEndMin(vo.getDailyEndMin()).weeklyEnableDays(vo.getWeeklyEnableDays()).build();
    }

    @JsonIgnore
    public OperationResponse<CreatedResIdOpenApiVO> validate() {
        if (Objects.equals(this.type, 0)) {
            if (this.dailyStartHour == null) {
                return new OperationResponse(b.d, "Parameter [dailyStartHour] should not be null", null);
            }
            if (this.dailyStartMin == null) {
                return new OperationResponse(b.d, "Parameter [dailyStartMin] should not be null", null);
            }
            if (this.dailyEndHour == null) {
                return new OperationResponse(b.d, "Parameter [dailyEndHour] should not be null", null);
            }
            if (this.dailyEndMin == null) {
                return new OperationResponse(b.d, "Parameter [dailyEndMin] should not be null", null);
            }
            if (this.weeklyEnableDays != null) {
                return new OperationResponse(b.d, "Parameter [weeklyEnableDays] should be null", null);
            }
            if (this.dailyStartHour > this.dailyEndHour) {
                return new OperationResponse(b.d, "Parameter [dailyStartHour] should not lager than parameter [dailyEndHour]", null);
            }
            if (this.dailyStartHour.equals(this.dailyEndHour) && this.dailyStartMin > this.dailyEndMin) {
                return new OperationResponse(b.d, "Parameter [dailyStartMin] should not lager than parameter [dailyEndMin]", null);
            }
        } else {
            if (CollectionUtils.isEmpty(this.weeklyEnableDays)) {
                return new OperationResponse(b.d, "Parameter [weeklyEnableDays] should not be empty", null);
            }
            if (this.dailyStartHour != null) {
                return new OperationResponse(b.d, "Parameter [dailyStartHour] should be null", null);
            }
            if (this.dailyStartMin != null) {
                return new OperationResponse(b.d, "Parameter [dailyStartMin] should be null", null);
            }
            if (this.dailyEndHour != null) {
                return new OperationResponse(b.d, "Parameter [dailyEndHour] should be null", null);
            }
            if (this.dailyEndMin != null) {
                return new OperationResponse(b.d, "Parameter [dailyEndMin] should be null", null);
            }
            if (!WEEKLY_DAYS_RANGE.containsAll(this.weeklyEnableDays)) {
                return new OperationResponse(b.d, "Parameter [weeklyEnableDays] is invalid", null);
            }
            this.weeklyEnableDays = this.weeklyEnableDays.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return new OperationResponse(b.a);
    }

    @Generated
    public static VoucherScheduleOpenApiVOBuilder builder() {
        return new VoucherScheduleOpenApiVOBuilder();
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Integer getDailyStartHour() {
        return this.dailyStartHour;
    }

    @Generated
    public Integer getDailyStartMin() {
        return this.dailyStartMin;
    }

    @Generated
    public Integer getDailyEndHour() {
        return this.dailyEndHour;
    }

    @Generated
    public Integer getDailyEndMin() {
        return this.dailyEndMin;
    }

    @Generated
    public Set<Integer> getWeeklyEnableDays() {
        return this.weeklyEnableDays;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setDailyStartHour(Integer dailyStartHour) {
        this.dailyStartHour = dailyStartHour;
    }

    @Generated
    public void setDailyStartMin(Integer dailyStartMin) {
        this.dailyStartMin = dailyStartMin;
    }

    @Generated
    public void setDailyEndHour(Integer dailyEndHour) {
        this.dailyEndHour = dailyEndHour;
    }

    @Generated
    public void setDailyEndMin(Integer dailyEndMin) {
        this.dailyEndMin = dailyEndMin;
    }

    @Generated
    public void setWeeklyEnableDays(Set<Integer> weeklyEnableDays) {
        this.weeklyEnableDays = weeklyEnableDays;
    }

    @Generated
    public String toString() {
        return "VoucherScheduleOpenApiVO(type=" + this.getType() + ", dailyStartHour=" + this.getDailyStartHour() + ", dailyStartMin=" + this.getDailyStartMin() + ", dailyEndHour=" + this.getDailyEndHour() + ", dailyEndMin=" + this.getDailyEndMin() + ", weeklyEnableDays=" + this.getWeeklyEnableDays() + ")";
    }

    @Generated
    public VoucherScheduleOpenApiVO(Integer type, Integer dailyStartHour, Integer dailyStartMin, Integer dailyEndHour, Integer dailyEndMin, Set<Integer> weeklyEnableDays) {
        this.type = type;
        this.dailyStartHour = dailyStartHour;
        this.dailyStartMin = dailyStartMin;
        this.dailyEndHour = dailyEndHour;
        this.dailyEndMin = dailyEndMin;
        this.weeklyEnableDays = weeklyEnableDays;
    }

    @Generated
    public VoucherScheduleOpenApiVO() {
    }

    @Generated
    public static class VoucherScheduleOpenApiVOBuilder {
        @Generated
        private Integer type;
        @Generated
        private Integer dailyStartHour;
        @Generated
        private Integer dailyStartMin;
        @Generated
        private Integer dailyEndHour;
        @Generated
        private Integer dailyEndMin;
        @Generated
        private Set<Integer> weeklyEnableDays;

        @Generated
        VoucherScheduleOpenApiVOBuilder() {
        }

        @Generated
        public VoucherScheduleOpenApiVOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        @Generated
        public VoucherScheduleOpenApiVOBuilder dailyStartHour(Integer dailyStartHour) {
            this.dailyStartHour = dailyStartHour;
            return this;
        }

        @Generated
        public VoucherScheduleOpenApiVOBuilder dailyStartMin(Integer dailyStartMin) {
            this.dailyStartMin = dailyStartMin;
            return this;
        }

        @Generated
        public VoucherScheduleOpenApiVOBuilder dailyEndHour(Integer dailyEndHour) {
            this.dailyEndHour = dailyEndHour;
            return this;
        }

        @Generated
        public VoucherScheduleOpenApiVOBuilder dailyEndMin(Integer dailyEndMin) {
            this.dailyEndMin = dailyEndMin;
            return this;
        }

        @Generated
        public VoucherScheduleOpenApiVOBuilder weeklyEnableDays(Set<Integer> weeklyEnableDays) {
            this.weeklyEnableDays = weeklyEnableDays;
            return this;
        }

        @Generated
        public VoucherScheduleOpenApiVO build() {
            return new VoucherScheduleOpenApiVO(this.type, this.dailyStartHour, this.dailyStartMin, this.dailyEndHour, this.dailyEndMin, this.weeklyEnableDays);
        }

        @Generated
        public String toString() {
            return "VoucherScheduleOpenApiVO.VoucherScheduleOpenApiVOBuilder(type=" + this.type + ", dailyStartHour=" + this.dailyStartHour + ", dailyStartMin=" + this.dailyStartMin + ", dailyEndHour=" + this.dailyEndHour + ", dailyEndMin=" + this.dailyEndMin + ", weeklyEnableDays=" + this.weeklyEnableDays + ")";
        }
    }
}

