/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.portal.api.openapi.vo.CustomRateLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.RateLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.VoucherVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

public class VoucherOpenApiVO {
    @Schema(name="id", description="Voucher ID")
    private String id;
    @Schema(name="code", description="Voucher code")
    private String code;
    @Schema(name="createdTime", description="Create timestamp for the voucher, unit: millisecond")
    private Long createdTime;
    @Schema(name="limitType", description="The limitations of the voucher. It should be a value as follows: 0: Limited Usage Counts, 1: Limited Online Users, 2: Unlimited")
    private Integer limitType;
    @Schema(name="limitNum", description="The number of limitations. It should be within the range of 1\u2013999. If Parameter [limitType] is 0 or 1, [limitNum] should not be null.When Parameter [limitType] is 0, [limitNum] represents the maximum number of times this voucher can be used.When Parameter [limitType] is 1, [limitNum] represents the maximum number of users this voucher can be used at the same time.")
    private Integer limitNum;
    @Schema(name="used", description="The number of times the voucher is used")
    private Integer used;
    @Schema(name="durationType", description="The duration type of the voucher. It should be a value as follows: 0: Client duration, each client expires after the duration is used. 1: Voucher duration, after reaching the voucher duration, clients using the voucher will expire")
    private Integer durationType;
    @Schema(name="duration", description="Duration of one use, unit: minute. It should be within the range of 1\u201314400000.")
    private Long duration;
    @Schema(name="timingType", description="The timing type of the voucher. It should be a value as follows: 0: Timing by time, clients can use vouchers for specified time duration. 1: Timing by usage, clients can use vouchers for the duration of actual usage")
    private Integer timingType;
    @Schema(name="expirationTime", description="The timestamp of the expiration of the voucher, unit: millisecond")
    private Long expirationTime;
    @Schema(name="effectiveTime", description="The timestamp when the voucher takes effect, unit: millisecond")
    private Long effectiveTime;
    @Schema(name="description", description="Description of the voucher")
    private String description;
    @Schema(name="rateLimit", description="Rate limit configuring.")
    private RateLimitOpenApiVO rateLimit;
    @Schema(name="trafficLimitEnable", description="Whether to enable traffic limit")
    private Boolean trafficLimitEnable;
    @Schema(name="trafficLimit", description="Traffic limit in MB. It should be within the range of 1\u201310485760")
    private Long trafficLimit;
    @Schema(name="trafficLimitFrequency", description="Frequency of traffic limit should be a value as follows: 0: total; 1: daily; 2: weekly; 3: monthly.")
    private Integer trafficLimitFrequency;
    @Schema(name="trafficLeft", description="Is there remaining traffic of traffic for the voucher")
    private Boolean trafficLeft;
    @Schema(name="startTime", description="The time when the voucher was first used, 0 represents it hasn't started using yet")
    private Long startTime;
    @Schema(name="startTime", description="The expiration date of the voucher")
    private Long endTime;
    @Schema(name="valid", description="Can the voucher still be used")
    private Boolean valid;
    @Schema(name="trafficUsed", description="Used traffic of the voucher, unit: Byte")
    private Long trafficUsed;
    @Schema(name="unitPrice", description="Price of single voucher. It should be within the range of 1\u2013999999999")
    private String unitPrice;
    @Schema(name="currency", description="Currency Short Code of voucher. For the values of Currency Short Code, refer to section 5.4.2 of the Open API Access Guide.")
    private String currency;
    @Schema(name="portalNames", description="Bound portal name list")
    private List<String> portalNames;
    @Schema(name="logout", description="Whether the voucher support portal logout functionality")
    private Boolean logout;
    @Schema(name="validity", description="Information on the validity period of the voucher")
    private String validity;
    @Schema(name="printComments", description="Customized print information for voters")
    private String printComments;
    @Schema(name="ssidNameList", description="Ssid name for voucher")
    private List<String> ssidNameList;
    @Schema(name="ssidNameList", description="SSIDs for voucher")
    private List<String> ssidList;
    @Schema(name="networkNameList", description="Network name for voucher")
    private List<String> networkNameList;
    @Schema(name="networkNameList", description="Networks for voucher")
    private List<String> networkList;
    @Schema(name="picId", description="Voucher logo picture ID")
    private String picId;
    @Schema(name="title", description="Title for voucher")
    private String title;
    @Schema(name="position", description="Position for logo or title")
    private Integer position;
    @Schema(name="logoSize", description="Size of logo on the pattern of the voucher. It should be within the range of 12-18.")
    private Integer logoSize;
    @Schema(name="titleSize", description="Size of title on the pattern of the voucher. It should be within the range of 50-175")
    private Integer titleSize;

    @JsonIgnore
    public static VoucherOpenApiVO toOpenApiVO(VoucherVO vo) {
        if (vo == null) {
            return null;
        }
        VoucherOpenApiVO voucherOpenApiVO = new VoucherOpenApiVO();
        voucherOpenApiVO.setId(vo.getId());
        voucherOpenApiVO.setCode(vo.getCode());
        voucherOpenApiVO.setCreatedTime(vo.getCreatedTime());
        voucherOpenApiVO.setLimitType(vo.getType());
        voucherOpenApiVO.setLimitNum(vo.getMaxUsers());
        voucherOpenApiVO.setUsed(vo.getUsed());
        voucherOpenApiVO.setDurationType(vo.getDurationType());
        voucherOpenApiVO.setDuration(vo.getDuration());
        voucherOpenApiVO.setTimingType(Boolean.TRUE.equals(vo.getUpTimeLimitEnable()) ? 1 : 0);
        voucherOpenApiVO.setExpirationTime(vo.getExpirationTime());
        voucherOpenApiVO.setEffectiveTime(vo.getEffectiveTime());
        voucherOpenApiVO.setDescription(vo.getNote());
        voucherOpenApiVO.setRateLimit(VoucherOpenApiVO.toRateLimitOpenApiVO(vo));
        voucherOpenApiVO.setTrafficLimitEnable(vo.getTrafficLimitEnable());
        voucherOpenApiVO.setTrafficLimit(vo.getTrafficLimit());
        voucherOpenApiVO.setTrafficLimitFrequency(vo.getTrafficLimitFrequency());
        voucherOpenApiVO.setTrafficLeft(vo.getTrafficLeft());
        voucherOpenApiVO.setTrafficUsed(vo.getTrafficUsed());
        voucherOpenApiVO.setStartTime(vo.getStartTime());
        voucherOpenApiVO.setEndTime(vo.getEndTime());
        voucherOpenApiVO.setValid(vo.getValid());
        voucherOpenApiVO.setUnitPrice(vo.getUnitPrice());
        voucherOpenApiVO.setCurrency(vo.getCurrency());
        voucherOpenApiVO.setPortalNames(vo.getPortalNames());
        voucherOpenApiVO.setLogout(vo.getLogout());
        voucherOpenApiVO.setValidity(vo.getValidity());
        voucherOpenApiVO.setPrintComments(vo.getPrintComments());
        voucherOpenApiVO.setSsidNameList(vo.getSsidNameList());
        voucherOpenApiVO.setNetworkNameList(vo.getNetworkNameList());
        voucherOpenApiVO.setSsidList(vo.getSsidList());
        voucherOpenApiVO.setNetworkList(vo.getNetworkList());
        voucherOpenApiVO.setPicId(vo.getPicId());
        voucherOpenApiVO.setTitle(vo.getTitle());
        voucherOpenApiVO.setPosition(vo.getPosition());
        voucherOpenApiVO.setLogoSize(vo.getLogoSize());
        voucherOpenApiVO.setTitleSize(vo.getTitleSize());
        return voucherOpenApiVO;
    }

    @JsonIgnore
    private static RateLimitOpenApiVO toRateLimitOpenApiVO(VoucherVO groupVO) {
        RateLimitOpenApiVO vo = new RateLimitOpenApiVO();
        if (groupVO.getRateLimitId() == null) {
            vo.setMode(0);
            vo.setCustomRateLimit(CustomRateLimitOpenApiVO.builder().downLimitEnable(groupVO.getDownLimitEnable()).downLimit(groupVO.getDownLimit()).upLimitEnable(groupVO.getUpLimitEnable()).upLimit(groupVO.getUpLimit()).build());
        } else {
            vo.setMode(1);
            vo.setRateLimitProfileId(groupVO.getRateLimitId());
        }
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Integer getLimitType() {
        return this.limitType;
    }

    @Generated
    public Integer getLimitNum() {
        return this.limitNum;
    }

    @Generated
    public Integer getUsed() {
        return this.used;
    }

    @Generated
    public Integer getDurationType() {
        return this.durationType;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Long getEffectiveTime() {
        return this.effectiveTime;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public RateLimitOpenApiVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public Boolean getTrafficLeft() {
        return this.trafficLeft;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Boolean getValid() {
        return this.valid;
    }

    @Generated
    public Long getTrafficUsed() {
        return this.trafficUsed;
    }

    @Generated
    public String getUnitPrice() {
        return this.unitPrice;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<String> getPortalNames() {
        return this.portalNames;
    }

    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public String getValidity() {
        return this.validity;
    }

    @Generated
    public String getPrintComments() {
        return this.printComments;
    }

    @Generated
    public List<String> getSsidNameList() {
        return this.ssidNameList;
    }

    @Generated
    public List<String> getSsidList() {
        return this.ssidList;
    }

    @Generated
    public List<String> getNetworkNameList() {
        return this.networkNameList;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public String getPicId() {
        return this.picId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public Integer getPosition() {
        return this.position;
    }

    @Generated
    public Integer getLogoSize() {
        return this.logoSize;
    }

    @Generated
    public Integer getTitleSize() {
        return this.titleSize;
    }

    @Generated
    public VoucherOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setCode(String code) {
        this.code = code;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setCreatedTime(Long createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setLimitType(Integer limitType) {
        this.limitType = limitType;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setUsed(Integer used) {
        this.used = used;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setDurationType(Integer durationType) {
        this.durationType = durationType;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTimingType(Integer timingType) {
        this.timingType = timingType;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setEffectiveTime(Long effectiveTime) {
        this.effectiveTime = effectiveTime;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setRateLimit(RateLimitOpenApiVO rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTrafficLeft(Boolean trafficLeft) {
        this.trafficLeft = trafficLeft;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setValid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTrafficUsed(Long trafficUsed) {
        this.trafficUsed = trafficUsed;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setPortalNames(List<String> portalNames) {
        this.portalNames = portalNames;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setLogout(Boolean logout) {
        this.logout = logout;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setValidity(String validity) {
        this.validity = validity;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setPrintComments(String printComments) {
        this.printComments = printComments;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setSsidNameList(List<String> ssidNameList) {
        this.ssidNameList = ssidNameList;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setSsidList(List<String> ssidList) {
        this.ssidList = ssidList;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setNetworkNameList(List<String> networkNameList) {
        this.networkNameList = networkNameList;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setNetworkList(List<String> networkList) {
        this.networkList = networkList;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setPicId(String picId) {
        this.picId = picId;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTitle(String title) {
        this.title = title;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setPosition(Integer position) {
        this.position = position;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setLogoSize(Integer logoSize) {
        this.logoSize = logoSize;
        return this;
    }

    @Generated
    public VoucherOpenApiVO setTitleSize(Integer titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Generated
    public String toString() {
        return "VoucherOpenApiVO(id=" + this.getId() + ", code=" + this.getCode() + ", createdTime=" + this.getCreatedTime() + ", limitType=" + this.getLimitType() + ", limitNum=" + this.getLimitNum() + ", used=" + this.getUsed() + ", durationType=" + this.getDurationType() + ", duration=" + this.getDuration() + ", timingType=" + this.getTimingType() + ", expirationTime=" + this.getExpirationTime() + ", effectiveTime=" + this.getEffectiveTime() + ", description=" + this.getDescription() + ", rateLimit=" + this.getRateLimit() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", trafficLeft=" + this.getTrafficLeft() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", valid=" + this.getValid() + ", trafficUsed=" + this.getTrafficUsed() + ", unitPrice=" + this.getUnitPrice() + ", currency=" + this.getCurrency() + ", portalNames=" + this.getPortalNames() + ", logout=" + this.getLogout() + ", validity=" + this.getValidity() + ", printComments=" + this.getPrintComments() + ", ssidNameList=" + this.getSsidNameList() + ", ssidList=" + this.getSsidList() + ", networkNameList=" + this.getNetworkNameList() + ", networkList=" + this.getNetworkList() + ", picId=" + this.getPicId() + ", title=" + this.getTitle() + ", position=" + this.getPosition() + ", logoSize=" + this.getLogoSize() + ", titleSize=" + this.getTitleSize() + ")";
    }

    @Generated
    public VoucherOpenApiVO(String id, String code, Long createdTime, Integer limitType, Integer limitNum, Integer used, Integer durationType, Long duration, Integer timingType, Long expirationTime, Long effectiveTime, String description, RateLimitOpenApiVO rateLimit, Boolean trafficLimitEnable, Long trafficLimit, Integer trafficLimitFrequency, Boolean trafficLeft, Long startTime, Long endTime, Boolean valid, Long trafficUsed, String unitPrice, String currency, List<String> portalNames, Boolean logout, String validity, String printComments, List<String> ssidNameList, List<String> ssidList, List<String> networkNameList, List<String> networkList, String picId, String title, Integer position, Integer logoSize, Integer titleSize) {
        this.id = id;
        this.code = code;
        this.createdTime = createdTime;
        this.limitType = limitType;
        this.limitNum = limitNum;
        this.used = used;
        this.durationType = durationType;
        this.duration = duration;
        this.timingType = timingType;
        this.expirationTime = expirationTime;
        this.effectiveTime = effectiveTime;
        this.description = description;
        this.rateLimit = rateLimit;
        this.trafficLimitEnable = trafficLimitEnable;
        this.trafficLimit = trafficLimit;
        this.trafficLimitFrequency = trafficLimitFrequency;
        this.trafficLeft = trafficLeft;
        this.startTime = startTime;
        this.endTime = endTime;
        this.valid = valid;
        this.trafficUsed = trafficUsed;
        this.unitPrice = unitPrice;
        this.currency = currency;
        this.portalNames = portalNames;
        this.logout = logout;
        this.validity = validity;
        this.printComments = printComments;
        this.ssidNameList = ssidNameList;
        this.ssidList = ssidList;
        this.networkNameList = networkNameList;
        this.networkList = networkList;
        this.picId = picId;
        this.title = title;
        this.position = position;
        this.logoSize = logoSize;
        this.titleSize = titleSize;
    }

    @Generated
    public VoucherOpenApiVO() {
    }
}

