/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.portal.api.openapi.vo.CustomRateLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.RateLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherScheduleOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.vouchergroup.VoucherGroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;

public class VoucherGroupOpenApiVO {
    @Schema(name="id", description="Voucher group ID")
    private String id;
    @Schema(name="name", description="Voucher group ID")
    private String name;
    @Schema(name="createdTime", description="Create timestamp for the voucher group, unit: millisecond")
    private Long createdTime;
    @Schema(name="creatorName", description="Username of the creator of the voucher group")
    private String creatorName;
    @Schema(name="creatorName", description="Role of the creator of the voucher group")
    private String creatorRole;
    @Schema(name="limitType", description="The limitations of the voucher. It should be a value as follows: 0: Limited Usage Counts, 1: Limited Online Users, 2: Unlimited")
    private Integer limitType;
    @Schema(name="limitNum", description="The number of limitations. It should be within the range of 1\u2013999. If Parameter [limitType] is 0 or 1, [limitNum] should not be null.When Parameter [limitType] is 0, [limitNum] represents the maximum number of times this voucher can be used.When Parameter [limitType] is 1, [limitNum] represents the maximum number of users this voucher can be used at the same time.")
    private Integer limitNum;
    @Schema(name="durationType", description="The duration type of the voucher. It should be a value as follows: 0: Client duration, each client expires after the duration is used. 1: Voucher duration, after reaching the voucher duration, clients using the voucher will expire")
    private Integer durationType;
    @Schema(name="duration", description="Duration of one use, unit: minute. It should be within the range of 1\u201314400000.")
    private Long duration;
    @Schema(name="timingType", description="The timing type of the voucher. It should be a value as follows: 0: Timing by time, clients can use vouchers for specified time duration. 1: Timing by usage, clients can use vouchers for the duration of actual usage")
    private Integer timingType;
    @Schema(name="rateLimit", description="Rate limit configuring.")
    private RateLimitOpenApiVO rateLimit;
    @Schema(name="trafficLimitEnable", description="Whether to enable traffic limit")
    private Boolean trafficLimitEnable;
    @Schema(name="trafficLimit", description="Traffic limit in MB. It should be within the range of 1\u201310485760")
    private Long trafficLimit;
    @Schema(name="trafficLimitFrequency", description="Frequency of traffic limit should be a value as follows: 0: total; 1: daily; 2: weekly; 3: monthly.")
    private Integer trafficLimitFrequency;
    @Schema(name="unitPrice", description="Price of single voucher. It should be within the range of 1\u2013999999999")
    private String unitPrice;
    @Schema(name="currency", description="Currency Short Code of voucher. For the values of Currency Short Code, refer to section 5.4.2 of the Open API Access Guide.")
    private String currency;
    @Schema(name="portalNames", description="Bound portal name list")
    private List<String> portalNames;
    @Schema(name="applyToAllPortals", description="Is the voucher effective for all portals, including all newly created portals")
    private Boolean applyToAllPortals;
    @Schema(name="expirationTime", description="The timestamp of the expiration of the voucher, unit: millisecond")
    private Long expirationTime;
    @Schema(name="effectiveTime", description="The timestamp when the voucher takes effect, unit: millisecond")
    private Long effectiveTime;
    @Schema(name="validityType", description="The validity type of the voucher. It should be a value as follows: 0: Voucher can be used at any time, parameter [effectiveTime], [expirationTime] and [schedule] should be null. 1: Voucher can be used between the effective time and expiration time, parameter [effectiveTime] and [expirationTime] should not be null, parameter [schedule] should be null. 2: Voucher can be used within a specified time period by schedule, parameter [effectiveTime] and [expirationTime] should be null, parameter [schedule] should not be null")
    private Integer validityType;
    @Schema(name="schedule", description="Specified time period that voucher can be used. When parameter [validityType] is 2, parameter [schedule] is required")
    @Valid
    private VoucherScheduleOpenApiVO schedule;
    @Schema(name="logout", description="Whether the voucher support portal logout functionality")
    private Boolean logout;
    @Schema(name="description", description="Description of the voucher group")
    private String description;
    @Schema(name="printComments", description="Print comments of the voucher group")
    private String printComments;
    @Schema(name="unusedCount", description="Unused voucher counts of the voucher group")
    private Integer unusedCount;
    @Schema(name="usedCount", description="Used voucher counts of the voucher group")
    private Integer usedCount;
    @Schema(name="inUseCount", description="In use voucher counts of the voucher group")
    private Integer inUseCount;
    @Schema(name="expiredCount", description="Expired voucher counts of the voucher group")
    private Integer expiredCount;
    @Schema(name="totalCount", description="Total voucher counts of the voucher group")
    private Integer totalCount;
    @Schema(name="totalAmount", description="Total voucher amount of the voucher group")
    private String totalAmount;

    @JsonIgnore
    public static VoucherGroupOpenApiVO toOpenApiVO(VoucherGroupVO vo) {
        if (vo == null) {
            return null;
        }
        VoucherGroupOpenApiVO voucherGroupOpenApiVO = new VoucherGroupOpenApiVO();
        voucherGroupOpenApiVO.setId(vo.getId());
        voucherGroupOpenApiVO.setName(vo.getName());
        voucherGroupOpenApiVO.setCreatedTime(vo.getCreatedTime());
        voucherGroupOpenApiVO.setCreatorName(vo.getCreatorName());
        voucherGroupOpenApiVO.setCreatorRole(vo.getCreatorRole());
        voucherGroupOpenApiVO.setLimitType(vo.getType());
        voucherGroupOpenApiVO.setLimitNum(vo.getMaxUsers());
        voucherGroupOpenApiVO.setDurationType(vo.getDurationType());
        voucherGroupOpenApiVO.setDuration(vo.getDuration());
        voucherGroupOpenApiVO.setTimingType(Boolean.TRUE.equals(vo.getUpTimeLimitEnable()) ? 1 : 0);
        voucherGroupOpenApiVO.setRateLimit(VoucherGroupOpenApiVO.toRateLimitOpenApiVO(vo));
        voucherGroupOpenApiVO.setTrafficLimitEnable(vo.getTrafficLimitEnable());
        voucherGroupOpenApiVO.setTrafficLimit(vo.getTrafficLimit());
        voucherGroupOpenApiVO.setTrafficLimitFrequency(vo.getTrafficLimitFrequency());
        voucherGroupOpenApiVO.setUnitPrice(vo.getUnitPrice());
        voucherGroupOpenApiVO.setCurrency(vo.getCurrency());
        voucherGroupOpenApiVO.setPortalNames(vo.getPortalNames());
        voucherGroupOpenApiVO.setApplyToAllPortals(vo.getApplyToAllPortals());
        voucherGroupOpenApiVO.setExpirationTime(vo.getExpirationTime());
        voucherGroupOpenApiVO.setEffectiveTime(vo.getEffectiveTime());
        voucherGroupOpenApiVO.setValidityType(vo.getValidityType());
        voucherGroupOpenApiVO.setSchedule(VoucherScheduleOpenApiVO.toOpenApiVO(vo.getSchedule()));
        voucherGroupOpenApiVO.setLogout(vo.getLogout());
        voucherGroupOpenApiVO.setDescription(vo.getDescription());
        voucherGroupOpenApiVO.setPrintComments(vo.getPrintComments());
        voucherGroupOpenApiVO.setUnusedCount(vo.getUnusedCount());
        voucherGroupOpenApiVO.setUsedCount(vo.getUsedCount());
        voucherGroupOpenApiVO.setInUseCount(vo.getInUseCount());
        voucherGroupOpenApiVO.setExpiredCount(vo.getExpiredCount());
        voucherGroupOpenApiVO.setTotalCount(vo.getTotalCount());
        voucherGroupOpenApiVO.setTotalAmount(vo.getTotalAmount());
        return voucherGroupOpenApiVO;
    }

    @JsonIgnore
    private static RateLimitOpenApiVO toRateLimitOpenApiVO(VoucherGroupVO groupVO) {
        RateLimitOpenApiVO vo = new RateLimitOpenApiVO();
        if (groupVO.getRateLimitId() == null) {
            vo.setMode(0);
            vo.setCustomRateLimit(CustomRateLimitOpenApiVO.builder().downLimitEnable(groupVO.getDownLimitEnable()).downLimit(groupVO.getDownLimit()).upLimitEnable(groupVO.getUpLimitEnable()).upLimit(groupVO.getUpLimit()).build());
        } else {
            vo.setMode(1);
            vo.setRateLimitProfileId(groupVO.getRateLimitId());
        }
        return vo;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public String getCreatorName() {
        return this.creatorName;
    }

    @Generated
    public String getCreatorRole() {
        return this.creatorRole;
    }

    @Generated
    public Integer getLimitType() {
        return this.limitType;
    }

    @Generated
    public Integer getLimitNum() {
        return this.limitNum;
    }

    @Generated
    public Integer getDurationType() {
        return this.durationType;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public RateLimitOpenApiVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public String getUnitPrice() {
        return this.unitPrice;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<String> getPortalNames() {
        return this.portalNames;
    }

    @Generated
    public Boolean getApplyToAllPortals() {
        return this.applyToAllPortals;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Long getEffectiveTime() {
        return this.effectiveTime;
    }

    @Generated
    public Integer getValidityType() {
        return this.validityType;
    }

    @Generated
    public VoucherScheduleOpenApiVO getSchedule() {
        return this.schedule;
    }

    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPrintComments() {
        return this.printComments;
    }

    @Generated
    public Integer getUnusedCount() {
        return this.unusedCount;
    }

    @Generated
    public Integer getUsedCount() {
        return this.usedCount;
    }

    @Generated
    public Integer getInUseCount() {
        return this.inUseCount;
    }

    @Generated
    public Integer getExpiredCount() {
        return this.expiredCount;
    }

    @Generated
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @Generated
    public VoucherGroupOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setCreatedTime(Long createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setCreatorName(String creatorName) {
        this.creatorName = creatorName;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setCreatorRole(String creatorRole) {
        this.creatorRole = creatorRole;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setLimitType(Integer limitType) {
        this.limitType = limitType;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setDurationType(Integer durationType) {
        this.durationType = durationType;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setTimingType(Integer timingType) {
        this.timingType = timingType;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setRateLimit(RateLimitOpenApiVO rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setPortalNames(List<String> portalNames) {
        this.portalNames = portalNames;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setApplyToAllPortals(Boolean applyToAllPortals) {
        this.applyToAllPortals = applyToAllPortals;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setEffectiveTime(Long effectiveTime) {
        this.effectiveTime = effectiveTime;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setValidityType(Integer validityType) {
        this.validityType = validityType;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setSchedule(VoucherScheduleOpenApiVO schedule) {
        this.schedule = schedule;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setLogout(Boolean logout) {
        this.logout = logout;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setPrintComments(String printComments) {
        this.printComments = printComments;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setUnusedCount(Integer unusedCount) {
        this.unusedCount = unusedCount;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setUsedCount(Integer usedCount) {
        this.usedCount = usedCount;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setInUseCount(Integer inUseCount) {
        this.inUseCount = inUseCount;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setExpiredCount(Integer expiredCount) {
        this.expiredCount = expiredCount;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Generated
    public VoucherGroupOpenApiVO setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Generated
    public String toString() {
        return "VoucherGroupOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", createdTime=" + this.getCreatedTime() + ", creatorName=" + this.getCreatorName() + ", creatorRole=" + this.getCreatorRole() + ", limitType=" + this.getLimitType() + ", limitNum=" + this.getLimitNum() + ", durationType=" + this.getDurationType() + ", duration=" + this.getDuration() + ", timingType=" + this.getTimingType() + ", rateLimit=" + this.getRateLimit() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", unitPrice=" + this.getUnitPrice() + ", currency=" + this.getCurrency() + ", portalNames=" + this.getPortalNames() + ", applyToAllPortals=" + this.getApplyToAllPortals() + ", expirationTime=" + this.getExpirationTime() + ", effectiveTime=" + this.getEffectiveTime() + ", validityType=" + this.getValidityType() + ", schedule=" + this.getSchedule() + ", logout=" + this.getLogout() + ", description=" + this.getDescription() + ", printComments=" + this.getPrintComments() + ", unusedCount=" + this.getUnusedCount() + ", usedCount=" + this.getUsedCount() + ", inUseCount=" + this.getInUseCount() + ", expiredCount=" + this.getExpiredCount() + ", totalCount=" + this.getTotalCount() + ", totalAmount=" + this.getTotalAmount() + ")";
    }

    @Generated
    public VoucherGroupOpenApiVO(String id, String name, Long createdTime, String creatorName, String creatorRole, Integer limitType, Integer limitNum, Integer durationType, Long duration, Integer timingType, RateLimitOpenApiVO rateLimit, Boolean trafficLimitEnable, Long trafficLimit, Integer trafficLimitFrequency, String unitPrice, String currency, List<String> portalNames, Boolean applyToAllPortals, Long expirationTime, Long effectiveTime, Integer validityType, VoucherScheduleOpenApiVO schedule, Boolean logout, String description, String printComments, Integer unusedCount, Integer usedCount, Integer inUseCount, Integer expiredCount, Integer totalCount, String totalAmount) {
        this.id = id;
        this.name = name;
        this.createdTime = createdTime;
        this.creatorName = creatorName;
        this.creatorRole = creatorRole;
        this.limitType = limitType;
        this.limitNum = limitNum;
        this.durationType = durationType;
        this.duration = duration;
        this.timingType = timingType;
        this.rateLimit = rateLimit;
        this.trafficLimitEnable = trafficLimitEnable;
        this.trafficLimit = trafficLimit;
        this.trafficLimitFrequency = trafficLimitFrequency;
        this.unitPrice = unitPrice;
        this.currency = currency;
        this.portalNames = portalNames;
        this.applyToAllPortals = applyToAllPortals;
        this.expirationTime = expirationTime;
        this.effectiveTime = effectiveTime;
        this.validityType = validityType;
        this.schedule = schedule;
        this.logout = logout;
        this.description = description;
        this.printComments = printComments;
        this.unusedCount = unusedCount;
        this.usedCount = usedCount;
        this.inUseCount = inUseCount;
        this.expiredCount = expiredCount;
        this.totalCount = totalCount;
        this.totalAmount = totalAmount;
    }

    @Generated
    public VoucherGroupOpenApiVO() {
    }
}

