/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.portal.api.openapi.vo.CustomRateLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.RateLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.SimpleVoucherOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.StatisticsCountOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherPatternOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherScheduleOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.vouchergroup.VoucherGroupGridVO;
import com.tplink.smb.omada.portal.api.web.vo.vouchergroup.VoucherPatternVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class VoucherGroupGridOpenApiVO {
    @Schema(name="id", description="Voucher group ID")
    private String id;
    @Schema(name="name", description="Voucher group ID")
    private String name;
    @Schema(name="createdTime", description="Create timestamp for the voucher group, unit: millisecond")
    private Long createdTime;
    @Schema(name="creatorName", description="Username of the creator of the voucher group")
    private String creatorName;
    @Schema(name="creatorName", description="Role of the creator of the voucher group")
    private String creatorRole;
    @Schema(name="limitType", description="The limitations of the voucher. It should be a value as follows: 0: Limited Usage Counts, 1: Limited Online Users, 2: Unlimited")
    private Integer limitType;
    @Schema(name="limitNum", description="The number of limitations. It should be within the range of 1\u2013999. If Parameter [limitType] is 0 or 1, [limitNum] should not be null.When Parameter [limitType] is 0, [limitNum] represents the maximum number of times this voucher can be used.When Parameter [limitType] is 1, [limitNum] represents the maximum number of users this voucher can be used at the same time.")
    private Integer limitNum;
    @Schema(name="durationType", description="The duration type of the voucher. It should be a value as follows: 0: Client duration, each client expires after the duration is used. 1: Voucher duration, after reaching the voucher duration, clients using the voucher will expire")
    private Integer durationType;
    @Schema(name="duration", description="Duration of one use, unit: minute. It should be within the range of 1\u201314400000.")
    private Long duration;
    @Schema(name="timingType", description="The timing type of the voucher. It should be a value as follows: 0: Timing by time, clients can use vouchers for specified time duration. 1: Timing by usage, clients can use vouchers for the duration of actual usage")
    private Integer timingType;
    @Schema(name="rateLimit", description="Rate limit configuring.")
    private RateLimitOpenApiVO rateLimit;
    @Schema(name="trafficLimitEnable", description="Whether to enable traffic limit")
    private Boolean trafficLimitEnable;
    @Schema(name="trafficLimit", description="Traffic limit in MB. It should be within the range of 1\u201310485760")
    private Long trafficLimit;
    @Schema(name="trafficLimitFrequency", description="Frequency of traffic limit should be a value as follows: 0: total; 1: daily; 2: weekly; 3: monthly.")
    private Integer trafficLimitFrequency;
    @Schema(name="unitPrice", description="Price of single voucher. It should be within the range of 1\u2013999999999")
    private String unitPrice;
    @Schema(name="currency", description="Currency Short Code of voucher. For the values of Currency Short Code, refer to section 5.4.2 of the Open API Access Guide.")
    private String currency;
    @Schema(name="portalNames", description="Bound portal name list")
    private List<String> portalNames;
    @Schema(name="applyToAllPortals", description="Is the voucher effective for all portals, including all newly created portals")
    private Boolean applyToAllPortals;
    @Schema(name="expirationTime", description="The timestamp of the expiration of the voucher, unit: millisecond")
    private Long expirationTime;
    @Schema(name="effectiveTime", description="The timestamp when the voucher takes effect, unit: millisecond")
    private Long effectiveTime;
    @Schema(name="validityType", description="The validity type of the voucher. It should be a value as follows: 0: Voucher can be used at any time, parameter [effectiveTime], [expirationTime] and [schedule] should be null. 1: Voucher can be used between the effective time and expiration time, parameter [effectiveTime] and [expirationTime] should not be null, parameter [schedule] should be null. 2: Voucher can be used within a specified time period by schedule, parameter [effectiveTime] and [expirationTime] should be null, parameter [schedule] should not be null")
    private Integer validityType;
    @Schema(name="schedule", description="Specified time period that voucher can be used. When parameter [validityType] is 2, parameter [schedule] is required")
    @Valid
    private VoucherScheduleOpenApiVO schedule;
    @Schema(name="logout", description="Whether the voucher support portal logout functionality")
    private Boolean logout;
    @Schema(name="description", description="Description of the voucher group")
    private String description;
    @Schema(name="printComments", description="Print comments of the voucher group")
    private String printComments;
    @Schema(name="voucherPattern", description="Voucher pattern ")
    private VoucherPatternOpenApiVO voucherPattern;
    @Schema(name="unusedCount", description="Unused voucher counts of the voucher group, affected by search")
    private Integer unusedCount;
    @Schema(name="usedCount", description="Used voucher counts of the voucher group, affected by search")
    private Integer usedCount;
    @Schema(name="inUseCount", description="In use voucher counts of the voucher group, affected by search")
    private Integer inUseCount;
    @Schema(name="expiredCount", description="Expired voucher counts of the voucher group, affected by search")
    private Integer expiredCount;
    @Schema(name="totalCount", description="Total voucher counts of the voucher group, affected by search")
    private Integer totalCount;
    @Schema(name="unusedAmount", description="Unused voucher amount of the voucher group, unaffected by search")
    private String unusedAmount;
    @Schema(name="usedAmount", description="Used voucher amount of the voucher group, unaffected by search")
    private String usedAmount;
    @Schema(name="totalAmount", description="Total voucher amount of the voucher group, unaffected by search")
    private String totalAmount;
    @Valid
    @Schema(name="statisticsCount", description="Represents the quantity of statistics for the voucher group, unaffected by search")
    private StatisticsCountOpenApiVO statisticsCount;
    @Schema(name="totalRows", description="Total rows of vouchers in the voucher group, affected by search")
    private long totalRows = 0L;
    @Schema(name="currentPage", description="Current page number")
    private int currentPage = 1;
    @Schema(name="currentSize", description="Number of entries per page")
    private int currentSize = 10;
    @Schema(name="data", description="Voucher pagination data of the voucher group")
    private List<SimpleVoucherOpenApiVO> data;

    @JsonIgnore
    public static VoucherGroupGridOpenApiVO toOpenApiVO(VoucherGroupGridVO vo) {
        if (vo == null) {
            return null;
        }
        VoucherGroupGridOpenApiVO voucherGroupGridOpenApiVO = new VoucherGroupGridOpenApiVO();
        voucherGroupGridOpenApiVO.setId(vo.getId());
        voucherGroupGridOpenApiVO.setName(vo.getName());
        voucherGroupGridOpenApiVO.setCreatedTime(vo.getCreatedTime());
        voucherGroupGridOpenApiVO.setCreatorName(vo.getCreatorName());
        voucherGroupGridOpenApiVO.setCreatorRole(vo.getCreatorRole());
        voucherGroupGridOpenApiVO.setLimitType(vo.getType());
        voucherGroupGridOpenApiVO.setLimitNum(vo.getMaxUsers());
        voucherGroupGridOpenApiVO.setDurationType(vo.getDurationType());
        voucherGroupGridOpenApiVO.setDuration(vo.getDuration());
        voucherGroupGridOpenApiVO.setTimingType(Boolean.TRUE.equals(vo.getUpTimeLimitEnable()) ? 1 : 0);
        voucherGroupGridOpenApiVO.setRateLimit(VoucherGroupGridOpenApiVO.toRateLimitOpenApiVO(vo));
        voucherGroupGridOpenApiVO.setTrafficLimitEnable(vo.getTrafficLimitEnable());
        voucherGroupGridOpenApiVO.setTrafficLimit(vo.getTrafficLimit());
        voucherGroupGridOpenApiVO.setTrafficLimitFrequency(vo.getTrafficLimitFrequency());
        voucherGroupGridOpenApiVO.setUnitPrice(vo.getUnitPrice());
        voucherGroupGridOpenApiVO.setCurrency(vo.getCurrency());
        voucherGroupGridOpenApiVO.setPortalNames(vo.getPortalNames());
        voucherGroupGridOpenApiVO.setApplyToAllPortals(vo.getApplyToAllPortals());
        voucherGroupGridOpenApiVO.setExpirationTime(vo.getExpirationTime());
        voucherGroupGridOpenApiVO.setEffectiveTime(vo.getEffectiveTime());
        voucherGroupGridOpenApiVO.setValidityType(vo.getValidityType());
        voucherGroupGridOpenApiVO.setSchedule(VoucherScheduleOpenApiVO.toOpenApiVO(vo.getSchedule()));
        voucherGroupGridOpenApiVO.setLogout(vo.getLogout());
        voucherGroupGridOpenApiVO.setDescription(vo.getDescription());
        voucherGroupGridOpenApiVO.setPrintComments(vo.getPrintComments());
        voucherGroupGridOpenApiVO.setVoucherPattern(VoucherGroupGridOpenApiVO.toVoucherPatternOpenApiVO(vo.getPattern()));
        voucherGroupGridOpenApiVO.setUnusedCount(vo.getUnusedCount());
        voucherGroupGridOpenApiVO.setUsedCount(vo.getUsedCount());
        voucherGroupGridOpenApiVO.setInUseCount(vo.getInUseCount());
        voucherGroupGridOpenApiVO.setExpiredCount(vo.getExpiredCount());
        voucherGroupGridOpenApiVO.setTotalCount(vo.getTotalCount());
        voucherGroupGridOpenApiVO.setUnusedAmount(vo.getUnusedAmount());
        voucherGroupGridOpenApiVO.setUsedAmount(vo.getUsedAmount());
        voucherGroupGridOpenApiVO.setTotalAmount(vo.getTotalAmount());
        voucherGroupGridOpenApiVO.setStatisticsCount(StatisticsCountOpenApiVO.toOpenApiVO(vo.getStatisticsCount()));
        voucherGroupGridOpenApiVO.setTotalRows(vo.getTotalRows());
        voucherGroupGridOpenApiVO.setCurrentPage(vo.getCurrentPage());
        voucherGroupGridOpenApiVO.setCurrentSize(vo.getCurrentSize());
        voucherGroupGridOpenApiVO.setData(vo.getData().stream().map(SimpleVoucherOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return voucherGroupGridOpenApiVO;
    }

    @JsonIgnore
    private static RateLimitOpenApiVO toRateLimitOpenApiVO(VoucherGroupGridVO groupVO) {
        RateLimitOpenApiVO vo = new RateLimitOpenApiVO();
        if (groupVO.getRateLimitId() == null) {
            vo.setMode(0);
            vo.setCustomRateLimit(CustomRateLimitOpenApiVO.builder().downLimitEnable(groupVO.getDownLimitEnable()).downLimit(groupVO.getDownLimit()).upLimitEnable(groupVO.getUpLimitEnable()).upLimit(groupVO.getUpLimit()).build());
        } else {
            vo.setMode(1);
            vo.setRateLimitProfileId(groupVO.getRateLimitId());
        }
        return vo;
    }

    @JsonIgnore
    private static VoucherPatternOpenApiVO toVoucherPatternOpenApiVO(VoucherPatternVO vo) {
        VoucherPatternOpenApiVO voucherPatternOpenApiVO = new VoucherPatternOpenApiVO();
        voucherPatternOpenApiVO.setPatternType(vo.getPatternType());
        voucherPatternOpenApiVO.setPatternCode(vo.getPatternCode());
        voucherPatternOpenApiVO.setPosition(vo.getPosition());
        voucherPatternOpenApiVO.setLogoPicture(vo.getLogoPicture());
        voucherPatternOpenApiVO.setLogoSize(vo.getLogoSize());
        voucherPatternOpenApiVO.setTitle(vo.getTitle());
        voucherPatternOpenApiVO.setTitleSize(vo.getTitleSize());
        voucherPatternOpenApiVO.setSsidNetworkNameList(vo.getSsidNetworkNameList());
        voucherPatternOpenApiVO.setSsidList(vo.getSsidList());
        voucherPatternOpenApiVO.setNetworkList(vo.getNetworkList());
        voucherPatternOpenApiVO.setDurationEnable(vo.getDurationEnable());
        voucherPatternOpenApiVO.setLimitEnable(vo.getLimitEnable());
        voucherPatternOpenApiVO.setValidity(vo.getValidity());
        return voucherPatternOpenApiVO;
    }

    @Generated
    public static VoucherGroupGridOpenApiVOBuilder builder() {
        return new VoucherGroupGridOpenApiVOBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public String getCreatorName() {
        return this.creatorName;
    }

    @Generated
    public String getCreatorRole() {
        return this.creatorRole;
    }

    @Generated
    public Integer getLimitType() {
        return this.limitType;
    }

    @Generated
    public Integer getLimitNum() {
        return this.limitNum;
    }

    @Generated
    public Integer getDurationType() {
        return this.durationType;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public RateLimitOpenApiVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public String getUnitPrice() {
        return this.unitPrice;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<String> getPortalNames() {
        return this.portalNames;
    }

    @Generated
    public Boolean getApplyToAllPortals() {
        return this.applyToAllPortals;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Long getEffectiveTime() {
        return this.effectiveTime;
    }

    @Generated
    public Integer getValidityType() {
        return this.validityType;
    }

    @Generated
    public VoucherScheduleOpenApiVO getSchedule() {
        return this.schedule;
    }

    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPrintComments() {
        return this.printComments;
    }

    @Generated
    public VoucherPatternOpenApiVO getVoucherPattern() {
        return this.voucherPattern;
    }

    @Generated
    public Integer getUnusedCount() {
        return this.unusedCount;
    }

    @Generated
    public Integer getUsedCount() {
        return this.usedCount;
    }

    @Generated
    public Integer getInUseCount() {
        return this.inUseCount;
    }

    @Generated
    public Integer getExpiredCount() {
        return this.expiredCount;
    }

    @Generated
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public String getUnusedAmount() {
        return this.unusedAmount;
    }

    @Generated
    public String getUsedAmount() {
        return this.usedAmount;
    }

    @Generated
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @Generated
    public StatisticsCountOpenApiVO getStatisticsCount() {
        return this.statisticsCount;
    }

    @Generated
    public long getTotalRows() {
        return this.totalRows;
    }

    @Generated
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public int getCurrentSize() {
        return this.currentSize;
    }

    @Generated
    public List<SimpleVoucherOpenApiVO> getData() {
        return this.data;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setCreatedTime(Long createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setCreatorName(String creatorName) {
        this.creatorName = creatorName;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setCreatorRole(String creatorRole) {
        this.creatorRole = creatorRole;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setLimitType(Integer limitType) {
        this.limitType = limitType;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setDurationType(Integer durationType) {
        this.durationType = durationType;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setTimingType(Integer timingType) {
        this.timingType = timingType;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setRateLimit(RateLimitOpenApiVO rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setPortalNames(List<String> portalNames) {
        this.portalNames = portalNames;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setApplyToAllPortals(Boolean applyToAllPortals) {
        this.applyToAllPortals = applyToAllPortals;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setEffectiveTime(Long effectiveTime) {
        this.effectiveTime = effectiveTime;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setValidityType(Integer validityType) {
        this.validityType = validityType;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setSchedule(VoucherScheduleOpenApiVO schedule) {
        this.schedule = schedule;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setLogout(Boolean logout) {
        this.logout = logout;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setPrintComments(String printComments) {
        this.printComments = printComments;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setVoucherPattern(VoucherPatternOpenApiVO voucherPattern) {
        this.voucherPattern = voucherPattern;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setUnusedCount(Integer unusedCount) {
        this.unusedCount = unusedCount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setUsedCount(Integer usedCount) {
        this.usedCount = usedCount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setInUseCount(Integer inUseCount) {
        this.inUseCount = inUseCount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setExpiredCount(Integer expiredCount) {
        this.expiredCount = expiredCount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setUnusedAmount(String unusedAmount) {
        this.unusedAmount = unusedAmount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setUsedAmount(String usedAmount) {
        this.usedAmount = usedAmount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setStatisticsCount(StatisticsCountOpenApiVO statisticsCount) {
        this.statisticsCount = statisticsCount;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setTotalRows(long totalRows) {
        this.totalRows = totalRows;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setCurrentSize(int currentSize) {
        this.currentSize = currentSize;
        return this;
    }

    @Generated
    public VoucherGroupGridOpenApiVO setData(List<SimpleVoucherOpenApiVO> data) {
        this.data = data;
        return this;
    }

    @Generated
    public String toString() {
        return "VoucherGroupGridOpenApiVO(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", createdTime=" + this.getCreatedTime() + ", creatorName=" + this.getCreatorName() + ", creatorRole=" + this.getCreatorRole() + ", limitType=" + this.getLimitType() + ", limitNum=" + this.getLimitNum() + ", durationType=" + this.getDurationType() + ", duration=" + this.getDuration() + ", timingType=" + this.getTimingType() + ", rateLimit=" + this.getRateLimit() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", unitPrice=" + this.getUnitPrice() + ", currency=" + this.getCurrency() + ", portalNames=" + this.getPortalNames() + ", applyToAllPortals=" + this.getApplyToAllPortals() + ", expirationTime=" + this.getExpirationTime() + ", effectiveTime=" + this.getEffectiveTime() + ", validityType=" + this.getValidityType() + ", schedule=" + this.getSchedule() + ", logout=" + this.getLogout() + ", description=" + this.getDescription() + ", printComments=" + this.getPrintComments() + ", voucherPattern=" + this.getVoucherPattern() + ", unusedCount=" + this.getUnusedCount() + ", usedCount=" + this.getUsedCount() + ", inUseCount=" + this.getInUseCount() + ", expiredCount=" + this.getExpiredCount() + ", totalCount=" + this.getTotalCount() + ", unusedAmount=" + this.getUnusedAmount() + ", usedAmount=" + this.getUsedAmount() + ", totalAmount=" + this.getTotalAmount() + ", statisticsCount=" + this.getStatisticsCount() + ", totalRows=" + this.getTotalRows() + ", currentPage=" + this.getCurrentPage() + ", currentSize=" + this.getCurrentSize() + ", data=" + this.getData() + ")";
    }

    @Generated
    public VoucherGroupGridOpenApiVO(String id, String name, Long createdTime, String creatorName, String creatorRole, Integer limitType, Integer limitNum, Integer durationType, Long duration, Integer timingType, RateLimitOpenApiVO rateLimit, Boolean trafficLimitEnable, Long trafficLimit, Integer trafficLimitFrequency, String unitPrice, String currency, List<String> portalNames, Boolean applyToAllPortals, Long expirationTime, Long effectiveTime, Integer validityType, VoucherScheduleOpenApiVO schedule, Boolean logout, String description, String printComments, VoucherPatternOpenApiVO voucherPattern, Integer unusedCount, Integer usedCount, Integer inUseCount, Integer expiredCount, Integer totalCount, String unusedAmount, String usedAmount, String totalAmount, StatisticsCountOpenApiVO statisticsCount, long totalRows, int currentPage, int currentSize, List<SimpleVoucherOpenApiVO> data) {
        this.id = id;
        this.name = name;
        this.createdTime = createdTime;
        this.creatorName = creatorName;
        this.creatorRole = creatorRole;
        this.limitType = limitType;
        this.limitNum = limitNum;
        this.durationType = durationType;
        this.duration = duration;
        this.timingType = timingType;
        this.rateLimit = rateLimit;
        this.trafficLimitEnable = trafficLimitEnable;
        this.trafficLimit = trafficLimit;
        this.trafficLimitFrequency = trafficLimitFrequency;
        this.unitPrice = unitPrice;
        this.currency = currency;
        this.portalNames = portalNames;
        this.applyToAllPortals = applyToAllPortals;
        this.expirationTime = expirationTime;
        this.effectiveTime = effectiveTime;
        this.validityType = validityType;
        this.schedule = schedule;
        this.logout = logout;
        this.description = description;
        this.printComments = printComments;
        this.voucherPattern = voucherPattern;
        this.unusedCount = unusedCount;
        this.usedCount = usedCount;
        this.inUseCount = inUseCount;
        this.expiredCount = expiredCount;
        this.totalCount = totalCount;
        this.unusedAmount = unusedAmount;
        this.usedAmount = usedAmount;
        this.totalAmount = totalAmount;
        this.statisticsCount = statisticsCount;
        this.totalRows = totalRows;
        this.currentPage = currentPage;
        this.currentSize = currentSize;
        this.data = data;
    }

    @Generated
    public VoucherGroupGridOpenApiVO() {
    }

    @Generated
    public static class VoucherGroupGridOpenApiVOBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private Long createdTime;
        @Generated
        private String creatorName;
        @Generated
        private String creatorRole;
        @Generated
        private Integer limitType;
        @Generated
        private Integer limitNum;
        @Generated
        private Integer durationType;
        @Generated
        private Long duration;
        @Generated
        private Integer timingType;
        @Generated
        private RateLimitOpenApiVO rateLimit;
        @Generated
        private Boolean trafficLimitEnable;
        @Generated
        private Long trafficLimit;
        @Generated
        private Integer trafficLimitFrequency;
        @Generated
        private String unitPrice;
        @Generated
        private String currency;
        @Generated
        private List<String> portalNames;
        @Generated
        private Boolean applyToAllPortals;
        @Generated
        private Long expirationTime;
        @Generated
        private Long effectiveTime;
        @Generated
        private Integer validityType;
        @Generated
        private VoucherScheduleOpenApiVO schedule;
        @Generated
        private Boolean logout;
        @Generated
        private String description;
        @Generated
        private String printComments;
        @Generated
        private VoucherPatternOpenApiVO voucherPattern;
        @Generated
        private Integer unusedCount;
        @Generated
        private Integer usedCount;
        @Generated
        private Integer inUseCount;
        @Generated
        private Integer expiredCount;
        @Generated
        private Integer totalCount;
        @Generated
        private String unusedAmount;
        @Generated
        private String usedAmount;
        @Generated
        private String totalAmount;
        @Generated
        private StatisticsCountOpenApiVO statisticsCount;
        @Generated
        private long totalRows;
        @Generated
        private int currentPage;
        @Generated
        private int currentSize;
        @Generated
        private List<SimpleVoucherOpenApiVO> data;

        @Generated
        VoucherGroupGridOpenApiVOBuilder() {
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder createdTime(Long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder creatorName(String creatorName) {
            this.creatorName = creatorName;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder creatorRole(String creatorRole) {
            this.creatorRole = creatorRole;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder limitType(Integer limitType) {
            this.limitType = limitType;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder limitNum(Integer limitNum) {
            this.limitNum = limitNum;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder durationType(Integer durationType) {
            this.durationType = durationType;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder timingType(Integer timingType) {
            this.timingType = timingType;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder rateLimit(RateLimitOpenApiVO rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder trafficLimitEnable(Boolean trafficLimitEnable) {
            this.trafficLimitEnable = trafficLimitEnable;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder trafficLimit(Long trafficLimit) {
            this.trafficLimit = trafficLimit;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder trafficLimitFrequency(Integer trafficLimitFrequency) {
            this.trafficLimitFrequency = trafficLimitFrequency;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder unitPrice(String unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder portalNames(List<String> portalNames) {
            this.portalNames = portalNames;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder applyToAllPortals(Boolean applyToAllPortals) {
            this.applyToAllPortals = applyToAllPortals;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder expirationTime(Long expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder effectiveTime(Long effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder validityType(Integer validityType) {
            this.validityType = validityType;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder schedule(VoucherScheduleOpenApiVO schedule) {
            this.schedule = schedule;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder logout(Boolean logout) {
            this.logout = logout;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder printComments(String printComments) {
            this.printComments = printComments;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder voucherPattern(VoucherPatternOpenApiVO voucherPattern) {
            this.voucherPattern = voucherPattern;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder unusedCount(Integer unusedCount) {
            this.unusedCount = unusedCount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder usedCount(Integer usedCount) {
            this.usedCount = usedCount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder inUseCount(Integer inUseCount) {
            this.inUseCount = inUseCount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder expiredCount(Integer expiredCount) {
            this.expiredCount = expiredCount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder unusedAmount(String unusedAmount) {
            this.unusedAmount = unusedAmount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder usedAmount(String usedAmount) {
            this.usedAmount = usedAmount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder totalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder statisticsCount(StatisticsCountOpenApiVO statisticsCount) {
            this.statisticsCount = statisticsCount;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder totalRows(long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder currentPage(int currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder currentSize(int currentSize) {
            this.currentSize = currentSize;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVOBuilder data(List<SimpleVoucherOpenApiVO> data) {
            this.data = data;
            return this;
        }

        @Generated
        public VoucherGroupGridOpenApiVO build() {
            return new VoucherGroupGridOpenApiVO(this.id, this.name, this.createdTime, this.creatorName, this.creatorRole, this.limitType, this.limitNum, this.durationType, this.duration, this.timingType, this.rateLimit, this.trafficLimitEnable, this.trafficLimit, this.trafficLimitFrequency, this.unitPrice, this.currency, this.portalNames, this.applyToAllPortals, this.expirationTime, this.effectiveTime, this.validityType, this.schedule, this.logout, this.description, this.printComments, this.voucherPattern, this.unusedCount, this.usedCount, this.inUseCount, this.expiredCount, this.totalCount, this.unusedAmount, this.usedAmount, this.totalAmount, this.statisticsCount, this.totalRows, this.currentPage, this.currentSize, this.data);
        }

        @Generated
        public String toString() {
            return "VoucherGroupGridOpenApiVO.VoucherGroupGridOpenApiVOBuilder(id=" + this.id + ", name=" + this.name + ", createdTime=" + this.createdTime + ", creatorName=" + this.creatorName + ", creatorRole=" + this.creatorRole + ", limitType=" + this.limitType + ", limitNum=" + this.limitNum + ", durationType=" + this.durationType + ", duration=" + this.duration + ", timingType=" + this.timingType + ", rateLimit=" + this.rateLimit + ", trafficLimitEnable=" + this.trafficLimitEnable + ", trafficLimit=" + this.trafficLimit + ", trafficLimitFrequency=" + this.trafficLimitFrequency + ", unitPrice=" + this.unitPrice + ", currency=" + this.currency + ", portalNames=" + this.portalNames + ", applyToAllPortals=" + this.applyToAllPortals + ", expirationTime=" + this.expirationTime + ", effectiveTime=" + this.effectiveTime + ", validityType=" + this.validityType + ", schedule=" + this.schedule + ", logout=" + this.logout + ", description=" + this.description + ", printComments=" + this.printComments + ", voucherPattern=" + this.voucherPattern + ", unusedCount=" + this.unusedCount + ", usedCount=" + this.usedCount + ", inUseCount=" + this.inUseCount + ", expiredCount=" + this.expiredCount + ", totalCount=" + this.totalCount + ", unusedAmount=" + this.unusedAmount + ", usedAmount=" + this.usedAmount + ", totalAmount=" + this.totalAmount + ", statisticsCount=" + this.statisticsCount + ", totalRows=" + this.totalRows + ", currentPage=" + this.currentPage + ", currentSize=" + this.currentSize + ", data=" + this.data + ")";
        }
    }
}

