/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.portal.api.web.vo.VoucherBriefVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

public class VoucherBriefOpenApiVO {
    @Schema(name="code", description="Voucher code")
    private String code;
    @Schema(name="limitType", description="The limitations of the voucher. It should be a value as follows: 0: Limited Usage Counts, 1: Limited Online Users, 2: Unlimited")
    private Integer limitType;
    @Schema(name="limitNum", description="The number of limitations. It should be within the range of 1\u2013999. If Parameter [limitType] is 0 or 1, [limitNum] should not be null.When Parameter [limitType] is 0, [limitNum] represents the maximum number of times this voucher can be used.When Parameter [limitType] is 1, [limitNum] represents the maximum number of users this voucher can be used at the same time.")
    private Integer limitNum;
    @Schema(name="durationType", description="The duration type of the voucher. It should be a value as follows: 0: Client duration, each client expires after the duration is used. 1: Voucher duration, after reaching the voucher duration, clients using the voucher will expire")
    private Integer durationType;
    @Schema(name="duration", description="Duration of one use, unit: minute. It should be within the range of 1\u201314400000.")
    private Long duration;
    @Schema(name="unitPrice", description="Price of single voucher. It should be within the range of 1\u2013999999999")
    private String unitPrice;
    @Schema(name="currency", description="Currency Short Code of voucher. For the values of Currency Short Code, refer to section 5.4.2 of the Open API Access Guide.")
    private String currency;
    @Schema(name="validity", description="The validity period information of the voucher")
    private String validity;
    @Schema(name="printComments", description="Print comments of the voucher")
    private String printComments;
    @Schema(name="ssidNameList", description="Ssid name for voucher")
    private List<String> ssidNameList;
    @Schema(name="networkNameList", description="Network name for voucher")
    private List<String> networkNameList;
    @Schema(name="patternType", description="Voucher pattern type. 0: Logo, 1: Title, 3: Disabled")
    private Integer patternType;
    @Schema(name="picId", description="Voucher logo picture ID")
    private String picId;
    @Schema(name="title", description="Title for voucher")
    private String title;
    @Schema(name="position", description="Position for logo or title")
    private Integer position;
    @Schema(name="logoSize", description="Size of logo on the pattern of the voucher. It should be within the range of 12-18.")
    private Integer logoSize;
    @Schema(name="titleSize", description="Size of title on the pattern of the voucher. It should be within the range of 50-175")
    private Integer titleSize;

    @JsonIgnore
    public static VoucherBriefOpenApiVO toOpenApiVO(VoucherBriefVO vo) {
        if (vo == null) {
            return null;
        }
        VoucherBriefOpenApiVO voucherBriefOpenApiVO = new VoucherBriefOpenApiVO();
        voucherBriefOpenApiVO.setCode(vo.getCode());
        voucherBriefOpenApiVO.setLimitType(vo.getType());
        voucherBriefOpenApiVO.setLimitNum(vo.getMaxUsers());
        voucherBriefOpenApiVO.setDurationType(vo.getDurationType());
        voucherBriefOpenApiVO.setDuration(vo.getDuration());
        voucherBriefOpenApiVO.setUnitPrice(vo.getUnitPrice());
        voucherBriefOpenApiVO.setCurrency(vo.getCurrency());
        voucherBriefOpenApiVO.setValidity(vo.getValidity());
        voucherBriefOpenApiVO.setPrintComments(vo.getPrintComments());
        voucherBriefOpenApiVO.setSsidNameList(vo.getSsidNameList());
        voucherBriefOpenApiVO.setNetworkNameList(vo.getNetworkNameList());
        voucherBriefOpenApiVO.setPatternType(vo.getPatternType());
        voucherBriefOpenApiVO.setPicId(vo.getPicId());
        voucherBriefOpenApiVO.setTitle(vo.getTitle());
        voucherBriefOpenApiVO.setPosition(vo.getPosition());
        voucherBriefOpenApiVO.setLogoSize(vo.getLogoSize());
        voucherBriefOpenApiVO.setTitleSize(vo.getTitleSize());
        return voucherBriefOpenApiVO;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Integer getLimitType() {
        return this.limitType;
    }

    @Generated
    public Integer getLimitNum() {
        return this.limitNum;
    }

    @Generated
    public Integer getDurationType() {
        return this.durationType;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public String getUnitPrice() {
        return this.unitPrice;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getValidity() {
        return this.validity;
    }

    @Generated
    public String getPrintComments() {
        return this.printComments;
    }

    @Generated
    public List<String> getSsidNameList() {
        return this.ssidNameList;
    }

    @Generated
    public List<String> getNetworkNameList() {
        return this.networkNameList;
    }

    @Generated
    public Integer getPatternType() {
        return this.patternType;
    }

    @Generated
    public String getPicId() {
        return this.picId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public Integer getPosition() {
        return this.position;
    }

    @Generated
    public Integer getLogoSize() {
        return this.logoSize;
    }

    @Generated
    public Integer getTitleSize() {
        return this.titleSize;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setLimitType(Integer limitType) {
        this.limitType = limitType;
    }

    @Generated
    public void setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
    }

    @Generated
    public void setDurationType(Integer durationType) {
        this.durationType = durationType;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setValidity(String validity) {
        this.validity = validity;
    }

    @Generated
    public void setPrintComments(String printComments) {
        this.printComments = printComments;
    }

    @Generated
    public void setSsidNameList(List<String> ssidNameList) {
        this.ssidNameList = ssidNameList;
    }

    @Generated
    public void setNetworkNameList(List<String> networkNameList) {
        this.networkNameList = networkNameList;
    }

    @Generated
    public void setPatternType(Integer patternType) {
        this.patternType = patternType;
    }

    @Generated
    public void setPicId(String picId) {
        this.picId = picId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setPosition(Integer position) {
        this.position = position;
    }

    @Generated
    public void setLogoSize(Integer logoSize) {
        this.logoSize = logoSize;
    }

    @Generated
    public void setTitleSize(Integer titleSize) {
        this.titleSize = titleSize;
    }

    @Generated
    public String toString() {
        return "VoucherBriefOpenApiVO(code=" + this.getCode() + ", limitType=" + this.getLimitType() + ", limitNum=" + this.getLimitNum() + ", durationType=" + this.getDurationType() + ", duration=" + this.getDuration() + ", unitPrice=" + this.getUnitPrice() + ", currency=" + this.getCurrency() + ", validity=" + this.getValidity() + ", printComments=" + this.getPrintComments() + ", ssidNameList=" + this.getSsidNameList() + ", networkNameList=" + this.getNetworkNameList() + ", patternType=" + this.getPatternType() + ", picId=" + this.getPicId() + ", title=" + this.getTitle() + ", position=" + this.getPosition() + ", logoSize=" + this.getLogoSize() + ", titleSize=" + this.getTitleSize() + ")";
    }
}

