/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.web.vo.vouchergroup.SelectVoucherGroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;

public class SelectVoucherGroupOpenApiVO {
    @Schema(name="type", description="Select type. It should be a value as follows: 0: Represents selecting all voucher groups, this selection does not pass parameter [groupIds]. 1: Parameter [groupIds] includes the IDs of the voucher groups to be selected. 2: Parameter [groupIds] includes the IDs of the voucher groups not to be selected")
    @NotNull(message="Parameter [type] must not be null.")
    @NumberSet(value={0, 1, 2}, message="Parameter [type], should be 0, 1 or 2")
    private @NotNull(message="Parameter [type] must not be null.") Integer type;
    @Schema(name="groupIds", description="ID list of voucher groups. Voucher group can be created using 'Create Voucher Group' interface, and Voucher Group ID can be obtained from 'Get Voucher Group list' interface")
    private List<String> groupIds;
    @Schema(name="searchKey", description="Fuzzy query parameters, support field: voucher group name, voucher code")
    private String searchKey;
    @Schema(name="timeStart", description="Start timestamp filter query parameters, unit: MS")
    private Long timeStart;
    @Schema(name="timeStart", description="End timestamp filter query parameters, unit: MS")
    private Long timeEnd;

    @JsonIgnore
    public SelectVoucherGroupVO toVO() {
        String type = null;
        switch (this.type) {
            case 0: {
                type = "all";
                break;
            }
            case 1: {
                type = "include";
                break;
            }
            case 2: {
                type = "exclude";
                break;
            }
        }
        return new SelectVoucherGroupVO().setType(type).setIds(this.groupIds).setSearchKey(this.searchKey).setFilters(new SelectVoucherGroupVO.Filters().setTimeStart(this.timeStart).setTimeEnd(this.timeEnd));
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Generated
    public String getSearchKey() {
        return this.searchKey;
    }

    @Generated
    public Long getTimeStart() {
        return this.timeStart;
    }

    @Generated
    public Long getTimeEnd() {
        return this.timeEnd;
    }

    @Generated
    public SelectVoucherGroupOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public SelectVoucherGroupOpenApiVO setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    @Generated
    public SelectVoucherGroupOpenApiVO setSearchKey(String searchKey) {
        this.searchKey = searchKey;
        return this;
    }

    @Generated
    public SelectVoucherGroupOpenApiVO setTimeStart(Long timeStart) {
        this.timeStart = timeStart;
        return this;
    }

    @Generated
    public SelectVoucherGroupOpenApiVO setTimeEnd(Long timeEnd) {
        this.timeEnd = timeEnd;
        return this;
    }

    @Generated
    public String toString() {
        return "SelectVoucherGroupOpenApiVO(type=" + this.getType() + ", groupIds=" + this.getGroupIds() + ", searchKey=" + this.getSearchKey() + ", timeStart=" + this.getTimeStart() + ", timeEnd=" + this.getTimeEnd() + ")";
    }
}

