/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;

public class SelectIdsOpenApiVO {
    @Schema(name="type", description="Select type. It should be a value as follows: 0: Represents selecting all vouchers in the voucher group, this selection does not pass parameter [ids]. 1: Parameter [ids] includes the IDs of vouchers in the voucher group to be selected. 2: Parameter [ids] includes the IDs of vouchers in the voucher group not to be selected")
    @NotNull(message="Parameter [type] must not be null.")
    @NumberSet(value={0, 1, 2}, message="Parameter [type], should be 0, 1 or 2")
    private @NotNull(message="Parameter [type] must not be null.") Integer type;
    @Schema(name="ids", description="ID list of vouchers. Voucher can be created using 'Create Voucher Group' interface, and Voucher ID can be obtained from 'Get Voucher Group Detail' interface")
    private List<String> ids;
    @Schema(name="groupId", description="Voucher Group ID. Voucher group can be created using 'Create Voucher Group' interface, and Voucher Group ID can be obtained from 'Get Voucher Group list' interface")
    @NotNull(message="Parameter [groupId] must not be null.")
    private @NotNull(message="Parameter [groupId] must not be null.") String groupId;
    @Schema(name="searchKey", description="Fuzzy query parameters, support field: voucher code")
    private String searchKey;
    @Schema(name="status", description="voucher status filter query parameters. It should be a value as follows: 0: Unused vouchers, 1: In use vouchers, 2: Expired vouchers")
    private Integer status;

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<String> getIds() {
        return this.ids;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getSearchKey() {
        return this.searchKey;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public SelectIdsOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public SelectIdsOpenApiVO setIds(List<String> ids) {
        this.ids = ids;
        return this;
    }

    @Generated
    public SelectIdsOpenApiVO setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Generated
    public SelectIdsOpenApiVO setSearchKey(String searchKey) {
        this.searchKey = searchKey;
        return this;
    }

    @Generated
    public SelectIdsOpenApiVO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @Generated
    public String toString() {
        return "SelectIdsOpenApiVO(type=" + this.getType() + ", ids=" + this.getIds() + ", groupId=" + this.getGroupId() + ", searchKey=" + this.getSearchKey() + ", status=" + this.getStatus() + ")";
    }
}

