/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.gridquery.OpenApiQueryDataVO;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.web.vo.ExportVoucherVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;

public class ExportVoucherOpenApiVO {
    @NotNull(message="Parameter [type] must not be null.")
    @NumberSet(value={0, 1}, message="Parameter [format], should be 0 or 1")
    @Schema(name="format", description="Export file format, should be a value as follows: 0: csv, 1: xlsx")
    private @NotNull(message="Parameter [type] must not be null.") Integer format;
    @Schema(name="queryData", description="Query criteria for voucher groups")
    private OpenApiQueryDataVO queryData;
    @Schema(name="type", description="Select type. It should be a value as follows: 0: Represents selecting all voucher groups, this selection does not pass parameter [groupIds]. 1: Parameter [groupIds] includes the IDs of the voucher groups to be selected. 2: Parameter [groupIds] includes the IDs of the voucher groups not to be selected")
    @NotNull(message="Parameter [type] must not be null.")
    @NumberSet(value={0, 1, 2}, message="Parameter [type], should be 0, 1 or 2")
    private @NotNull(message="Parameter [type] must not be null.") Integer type;
    @Schema(name="groupIds", description="ID list of voucher groups. Voucher group can be created using 'Create Voucher Group' interface, and Voucher Group ID can be obtained from 'Get Voucher Group list' interface")
    private List<String> groupIds;

    @JsonIgnore
    public ExportVoucherVO toVO() {
        String type = null;
        switch (this.type) {
            case 0: {
                type = "all";
                break;
            }
            case 1: {
                type = "include";
                break;
            }
            case 2: {
                type = "exclude";
                break;
            }
        }
        ExportVoucherVO exportVoucherVO = new ExportVoucherVO();
        exportVoucherVO.setFormat(this.format);
        exportVoucherVO.setQueryDataVO(QueryDataVO.buildByOpenApiVO((OpenApiQueryDataVO)this.queryData));
        exportVoucherVO.setType(type);
        exportVoucherVO.setIds(this.groupIds);
        return exportVoucherVO;
    }

    @Generated
    public Integer getFormat() {
        return this.format;
    }

    @Generated
    public OpenApiQueryDataVO getQueryData() {
        return this.queryData;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Generated
    public ExportVoucherOpenApiVO setFormat(Integer format) {
        this.format = format;
        return this;
    }

    @Generated
    public ExportVoucherOpenApiVO setQueryData(OpenApiQueryDataVO queryData) {
        this.queryData = queryData;
        return this;
    }

    @Generated
    public ExportVoucherOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public ExportVoucherOpenApiVO setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    @Generated
    public String toString() {
        return "ExportVoucherOpenApiVO(format=" + this.getFormat() + ", queryData=" + this.getQueryData() + ", type=" + this.getType() + ", groupIds=" + this.getGroupIds() + ")";
    }
}

