/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.voucher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.openapi.vo.CreatedResIdOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.RateLimitOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.voucher.VoucherScheduleOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class CreateVoucherGroupOpenApiVO {
    @Schema(name="name", description="Voucher group name. It should contain 1-32 characters")
    @NotNull(message="Parameter [name] must not be null.")
    @Length(min=1, max=32, message="Parameter [name] should be 1~32 UTF-8 characters.")
    private @NotNull(message="Parameter [name] must not be null.") @Length(min=1, max=32, message="Parameter [name] should be 1~32 UTF-8 characters.") String name;
    @Schema(name="amount", description="The amount of vouchers created. It should be within the range of 1-5000")
    @NotNull(message="Parameter [amount] must not be null.")
    @Range(min=1L, max=5000L, message="Parameter [amount], should from 1 to 5000")
    private @NotNull(message="Parameter [amount] must not be null.") @Range(min=1L, max=5000L, message="Parameter [amount], should from 1 to 5000") Integer amount;
    @Schema(name="codeLength", description="The length of voucher code. It should be within the range of 6\u201310.")
    @NotNull(message="Parameter [codeLength] must not be null.")
    @Range(min=6L, max=10L, message="Parameter [codeLength], should from 6 to 10")
    private @NotNull(message="Parameter [codeLength] must not be null.") @Range(min=6L, max=10L, message="Parameter [codeLength], should from 6 to 10") Integer codeLength;
    @Schema(name="codeForm", description="The character types contained in the voucher code. It should be a value as follows: 0: Number, 1: Letter. For example, [0] indicates that the code only contains numbers; [0, 1] indicates that the code contains numbers and letters")
    @NotNull(message="Parameter [codeForm] must not be null.")
    private @NotNull(message="Parameter [codeForm] must not be null.") Set<Integer> codeForm;
    @Schema(name="limitType", description="The limitations of the voucher. It should be a value as follows: 0: Limited Usage Counts, 1: Limited Online Users, 2: Unlimited")
    @NotNull(message="Parameter [limitType] must not be null.")
    @NumberSet(value={0, 1, 2}, message="Parameter [limitType], should be 0, 1 or 2")
    private @NotNull(message="Parameter [limitType] must not be null.") Integer limitType;
    @Schema(name="limitNum", description="The number of limitations. It should be within the range of 1\u2013999. If Parameter [limitType] is 0 or 1, [limitNum] should not be null.When Parameter [limitType] is 0, [limitNum] represents the maximum number of times this voucher can be used.When Parameter [limitType] is 1, [limitNum] represents the maximum number of users this voucher can be used at the same time.")
    @Range(min=1L, max=999L, message="Parameter [limitNum], should from 1 to 999")
    private @Range(min=1L, max=999L, message="Parameter [limitNum], should from 1 to 999") Integer limitNum;
    @Schema(name="durationType", description="The duration type of the voucher. It should be a value as follows: 0: Client duration, each client expires after the duration is used. 1: Voucher duration, after reaching the voucher duration, clients using the voucher will expire")
    @NotNull(message="Parameter [durationType] must not be null.")
    @NumberSet(value={0, 1}, message="Parameter [durationType], should be 0 or 1")
    private @NotNull(message="Parameter [durationType] must not be null.") Integer durationType;
    @Schema(name="duration", description="Duration of one use, unit: minute. It should be within the range of 1\u201314400000.")
    @NotNull(message="Parameter [duration] must not be null.")
    @Range(min=1L, max=14400000L, message="Parameter [duration], should from 1 to 14400000")
    private @NotNull(message="Parameter [duration] must not be null.") @Range(min=1L, max=14400000L, message="Parameter [duration], should from 1 to 14400000") Long duration;
    @Schema(name="timingType", description="The timing type of the voucher. It should be a value as follows: 0: Timing by time, clients can use vouchers for specified time duration. 1: Timing by usage, clients can use vouchers for the duration of actual usage")
    @NotNull(message="Parameter [timingType] must not be null.")
    @NumberSet(value={0, 1}, message="Parameter [timingType], should be 0 or 1")
    private @NotNull(message="Parameter [timingType] must not be null.") Integer timingType;
    @Schema(name="rateLimit", description="When configuring rate limit, can only configure one of rateLimitProfileId or customRateLimit")
    @NotNull(message="Parameter [rateLimit] must not be null.")
    @Valid
    private @NotNull(message="Parameter [rateLimit] must not be null.") @Valid RateLimitOpenApiVO rateLimit;
    @Schema(name="trafficLimitEnable", description="Whether to enable traffic limit")
    @NotNull(message="Parameter [trafficLimitEnable] must not be null.")
    private @NotNull(message="Parameter [trafficLimitEnable] must not be null.") Boolean trafficLimitEnable;
    @Schema(name="trafficLimit", description="Traffic limit in MB. It should be within the range of 1\u201310485760")
    @Range(min=0L, max=0xA00000L, message="Value of trafficLimit is from 1 to 10485760 MB.")
    private @Range(min=0L, max=0xA00000L, message="Value of trafficLimit is from 1 to 10485760 MB.") Long trafficLimit;
    @Schema(name="trafficLimitFrequency", description="Frequency of traffic limit should be a value as follows: 0: total; 1: daily; 2: weekly; 3: monthly.")
    @Range(min=0L, max=3L, message="TrafficLimitFrequency should be a value as follows: 0, 1, 2, 3.")
    private @Range(min=0L, max=3L, message="TrafficLimitFrequency should be a value as follows: 0, 1, 2, 3.") Integer trafficLimitFrequency;
    @Schema(name="unitPrice", description="Price of single voucher. It should be within the range of 1\u2013999999999")
    @Range(min=1L, max=999999999L, message="Parameter [unitPrice], should from 1 to 999999999")
    private @Range(min=1L, max=999999999L, message="Parameter [unitPrice], should from 1 to 999999999") Long unitPrice;
    @Schema(name="currency", description="Currency Short Code of voucher. For the values of Currency Short Code, refer to section 5.4.2 of the Open API Access Guide.")
    private String currency;
    @Schema(name="applyToAllPortals", description="Is the voucher effective for all portals, including all newly created portals")
    @NotNull(message="Parameter [applyToAllPortals] should not be null.")
    private @NotNull(message="Parameter [applyToAllPortals] should not be null.") Boolean applyToAllPortals;
    @Schema(name="portals", description="Bound portal ID list. Portal can be created using 'Add portal' interface, and portal ID can be obtained from 'Get portal list in a site' interface")
    private List<String> portals;
    @Schema(name="expirationTime", description="The timestamp of the expiration of the voucher, unit: millisecond. When parameter [validityType] is 1, parameter [expirationTime] is required")
    private Long expirationTime;
    @Schema(name="effectiveTime", description="The timestamp when the voucher takes effect, unit: millisecond. When parameter [validityType] is 1, parameter [effectiveTime] is required")
    private Long effectiveTime;
    @Schema(name="logout", description="Whether the voucher support portal logout functionality")
    private Boolean logout;
    @Schema(name="description", description="Description of the voucher group")
    private String description;
    @Schema(name="printComments", description="Print comments of the voucher group")
    @Length(max=256, message="Parameter [printCommand] should be 0~256 characters.")
    private @Length(max=256, message="Parameter [printCommand] should be 0~256 characters.") String printComments;
    @Schema(name="validityType", description="The validity type of the voucher. It should be a value as follows: 0: Voucher can be used at any time, parameter [effectiveTime], [expirationTime] and [schedule] should be null. 1: Voucher can be used between the effective time and expiration time, parameter [effectiveTime] and [expirationTime] should not be null, parameter [schedule] should be null. 2: Voucher can be used within a specified time period by schedule, parameter [effectiveTime] and [expirationTime] should be null, parameter [schedule] should not be null")
    @NumberSet(value={0, 1, 2})
    private Integer validityType;
    @Schema(name="schedule", description="Specified time period that voucher can be used. When parameter [validityType] is 2, parameter [schedule] is required")
    @Valid
    private VoucherScheduleOpenApiVO schedule;
    @JsonIgnore
    private static final ImmutableSet<Integer> CODE_FORM_RANGE = ImmutableSet.of((Object)0, (Object)1);

    @JsonIgnore
    public OperationResponse<CreatedResIdOpenApiVO> validateAndCompatible() {
        if (this.codeForm.isEmpty() || !CODE_FORM_RANGE.containsAll(this.codeForm)) {
            return new OperationResponse(b.d, "Parameter [codeForm] is invalid", null);
        }
        if ((Objects.equals(this.limitType, 0) || Objects.equals(this.limitType, 1)) && this.limitNum == null) {
            return new OperationResponse(b.d, "Parameter [limitNum] should not be null when [limitType] is 0 or 1", null);
        }
        if (T.a((String)this.rateLimit.getRateLimitProfileId()) && Objects.isNull(this.rateLimit.getCustomRateLimit())) {
            return new OperationResponse(b.d.b(), "At least one item needs to be configured for rateLimitProfileId and customRateLimit.", null);
        }
        if (this.rateLimit.getMode() == 0 && Objects.isNull(this.rateLimit.getCustomRateLimit())) {
            return new OperationResponse(b.d, "Parameter [customRateLimit] should not be null when [mode] is 0", null);
        }
        if (this.rateLimit.getMode() == 1 && T.a((String)this.rateLimit.getRateLimitProfileId())) {
            return new OperationResponse(b.d, "Parameter [rateLimitProfileId] should not be null when [mode] is 1", null);
        }
        if (Boolean.TRUE.equals(this.trafficLimitEnable) && (this.trafficLimit == null || this.trafficLimitFrequency == null)) {
            return new OperationResponse(b.d, "Parameter [trafficLimit] or [trafficLimitFrequency] should not be null when [trafficLimitEnable] is true", null);
        }
        if (this.unitPrice != null && this.currency == null || this.currency != null && this.unitPrice == null) {
            return new OperationResponse(b.d, "The parameters [unitPrice] and [currency] should be configured simultaneously or not", null);
        }
        if (this.validityType == null) {
            this.validityType = this.expirationTime != null && this.effectiveTime != null ? 1 : 0;
        }
        switch (this.validityType) {
            case 0: {
                if (this.effectiveTime == null && this.expirationTime == null && this.schedule == null) break;
                return new OperationResponse(b.d, "Parameters [effectiveTime], [expirationTime] and [schedule] should be null", null);
            }
            case 1: {
                if (this.effectiveTime == null || this.expirationTime == null) {
                    return new OperationResponse(b.d, "Parameters [effectiveTime] and [expirationTime] should not be null", null);
                }
                if (this.expirationTime <= System.currentTimeMillis()) {
                    return new OperationResponse(b.d, "Parameter [expirationTime] should not be less than the current time", null);
                }
                if (this.effectiveTime < this.expirationTime) break;
                return new OperationResponse(b.d, "Parameter [expirationTime] should not be less than [effectiveTime]", null);
            }
            case 2: {
                if (this.schedule == null) {
                    return new OperationResponse(b.d, "Parameters [schedule] should not be null", null);
                }
                return this.schedule.validate();
            }
            default: {
                return new OperationResponse(b.d, "Parameters [validityType] is invalid", null);
            }
        }
        return new OperationResponse(b.a);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getAmount() {
        return this.amount;
    }

    @Generated
    public Integer getCodeLength() {
        return this.codeLength;
    }

    @Generated
    public Set<Integer> getCodeForm() {
        return this.codeForm;
    }

    @Generated
    public Integer getLimitType() {
        return this.limitType;
    }

    @Generated
    public Integer getLimitNum() {
        return this.limitNum;
    }

    @Generated
    public Integer getDurationType() {
        return this.durationType;
    }

    @Generated
    public Long getDuration() {
        return this.duration;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public RateLimitOpenApiVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public Long getUnitPrice() {
        return this.unitPrice;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getApplyToAllPortals() {
        return this.applyToAllPortals;
    }

    @Generated
    public List<String> getPortals() {
        return this.portals;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Long getEffectiveTime() {
        return this.effectiveTime;
    }

    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPrintComments() {
        return this.printComments;
    }

    @Generated
    public Integer getValidityType() {
        return this.validityType;
    }

    @Generated
    public VoucherScheduleOpenApiVO getSchedule() {
        return this.schedule;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @Generated
    public void setCodeLength(Integer codeLength) {
        this.codeLength = codeLength;
    }

    @Generated
    public void setCodeForm(Set<Integer> codeForm) {
        this.codeForm = codeForm;
    }

    @Generated
    public void setLimitType(Integer limitType) {
        this.limitType = limitType;
    }

    @Generated
    public void setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
    }

    @Generated
    public void setDurationType(Integer durationType) {
        this.durationType = durationType;
    }

    @Generated
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Generated
    public void setTimingType(Integer timingType) {
        this.timingType = timingType;
    }

    @Generated
    public void setRateLimit(RateLimitOpenApiVO rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Generated
    public void setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
    }

    @Generated
    public void setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
    }

    @Generated
    public void setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
    }

    @Generated
    public void setUnitPrice(Long unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setApplyToAllPortals(Boolean applyToAllPortals) {
        this.applyToAllPortals = applyToAllPortals;
    }

    @Generated
    public void setPortals(List<String> portals) {
        this.portals = portals;
    }

    @Generated
    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Generated
    public void setEffectiveTime(Long effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    @Generated
    public void setLogout(Boolean logout) {
        this.logout = logout;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPrintComments(String printComments) {
        this.printComments = printComments;
    }

    @Generated
    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    @Generated
    public void setSchedule(VoucherScheduleOpenApiVO schedule) {
        this.schedule = schedule;
    }

    @Generated
    public String toString() {
        return "CreateVoucherGroupOpenApiVO(name=" + this.getName() + ", amount=" + this.getAmount() + ", codeLength=" + this.getCodeLength() + ", codeForm=" + this.getCodeForm() + ", limitType=" + this.getLimitType() + ", limitNum=" + this.getLimitNum() + ", durationType=" + this.getDurationType() + ", duration=" + this.getDuration() + ", timingType=" + this.getTimingType() + ", rateLimit=" + this.getRateLimit() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", unitPrice=" + this.getUnitPrice() + ", currency=" + this.getCurrency() + ", applyToAllPortals=" + this.getApplyToAllPortals() + ", portals=" + this.getPortals() + ", expirationTime=" + this.getExpirationTime() + ", effectiveTime=" + this.getEffectiveTime() + ", logout=" + this.getLogout() + ", description=" + this.getDescription() + ", printComments=" + this.getPrintComments() + ", validityType=" + this.getValidityType() + ", schedule=" + this.getSchedule() + ")";
    }
}

