/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.portal.api.openapi.vo.AuthTimeOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.SmsSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import lombok.Generated;

public class SmsSettingResOpenApiVO {
    @Schema(name="sid", description="Twilio SID")
    private String sid;
    @Schema(name="authToken", description="Twilio auth token")
    private String authToken;
    @Schema(name="phoneNum", description="Twilio phone number. String value, should contain at least 6 digits such as \"+123456\".")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String phoneNum;
    @Schema(name="maxVerificationCodeEnable", description="Whether to control the limit of authentication for the same phone number.")
    private Boolean maxVerificationCodeEnable;
    @Schema(name="maxVerificationCodeTimes", description="User limit with the same phone number, should be within the range of 1\u201310. Required when parameter [maxVerificationCodeEnable] is true.")
    private Integer maxVerificationCodeTimes;
    @Schema(name="authTimeout", description="Portal auth timeout setting.")
    private AuthTimeOpenApiVO authTimeout;
    @Schema(name="countryCode", description="Preset Contry code. String value such as \"+86\".")
    private String countryCode;

    public static SmsSettingResOpenApiVO fromVO(SmsSettingVO vo) {
        if (vo == null) {
            return null;
        }
        SmsSettingResOpenApiVO smsSettingResOpenApiVO = new SmsSettingResOpenApiVO();
        smsSettingResOpenApiVO.setSid(vo.getSid());
        smsSettingResOpenApiVO.setAuthToken(vo.getAuthToken());
        smsSettingResOpenApiVO.setPhoneNum(vo.getPhoneNum());
        smsSettingResOpenApiVO.setMaxVerificationCodeEnable(vo.getUserLimitEnable());
        smsSettingResOpenApiVO.setMaxVerificationCodeTimes(vo.getUserLimit());
        smsSettingResOpenApiVO.setAuthTimeout(Optional.ofNullable(vo.getAuthTimeout()).map(AuthTimeOpenApiVO::fromVO).orElse(null));
        smsSettingResOpenApiVO.setCountryCode(vo.getCountryCode());
        return smsSettingResOpenApiVO;
    }

    @Generated
    public String getSid() {
        return this.sid;
    }

    @Generated
    public String getAuthToken() {
        return this.authToken;
    }

    @Generated
    public String getPhoneNum() {
        return this.phoneNum;
    }

    @Generated
    public Boolean getMaxVerificationCodeEnable() {
        return this.maxVerificationCodeEnable;
    }

    @Generated
    public Integer getMaxVerificationCodeTimes() {
        return this.maxVerificationCodeTimes;
    }

    @Generated
    public AuthTimeOpenApiVO getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public void setSid(String sid) {
        this.sid = sid;
    }

    @Generated
    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    @Generated
    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    @Generated
    public void setMaxVerificationCodeEnable(Boolean maxVerificationCodeEnable) {
        this.maxVerificationCodeEnable = maxVerificationCodeEnable;
    }

    @Generated
    public void setMaxVerificationCodeTimes(Integer maxVerificationCodeTimes) {
        this.maxVerificationCodeTimes = maxVerificationCodeTimes;
    }

    @Generated
    public void setAuthTimeout(AuthTimeOpenApiVO authTimeout) {
        this.authTimeout = authTimeout;
    }

    @Generated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public String toString() {
        return "SmsSettingResOpenApiVO(sid=" + this.getSid() + ", authToken=" + this.getAuthToken() + ", phoneNum=" + this.getPhoneNum() + ", maxVerificationCodeEnable=" + this.getMaxVerificationCodeEnable() + ", maxVerificationCodeTimes=" + this.getMaxVerificationCodeTimes() + ", authTimeout=" + this.getAuthTimeout() + ", countryCode=" + this.getCountryCode() + ")";
    }

    @Generated
    public SmsSettingResOpenApiVO() {
    }

    @Generated
    public SmsSettingResOpenApiVO(String sid, String authToken, String phoneNum, Boolean maxVerificationCodeEnable, Integer maxVerificationCodeTimes, AuthTimeOpenApiVO authTimeout, String countryCode) {
        this.sid = sid;
        this.authToken = authToken;
        this.phoneNum = phoneNum;
        this.maxVerificationCodeEnable = maxVerificationCodeEnable;
        this.maxVerificationCodeTimes = maxVerificationCodeTimes;
        this.authTimeout = authTimeout;
        this.countryCode = countryCode;
    }
}

