/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalAuthTimeoutOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SmsSetting", description="Sms Portal Setting.")
public class SmsSettingOpenApiVO {
    @Schema(name="sid", description="Twilio SID")
    @NotNull(message="SMS parameter [sid] should not be null")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="SMS parameter [sid] should not be null") String sid;
    @Schema(name="authToken", description="Twilio auth token")
    @NotNull(message="SMS parameter [authToken] should not be null")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="SMS parameter [authToken] should not be null") String authToken;
    @Schema(name="phoneNum", description="Twilio phone number. String value, should contain at least 6 digits such as \"+123456\".")
    @NotNull(message="SMS parameter [phoneNum] should not be null")
    @Pattern(regexp="\\+\\d{6,}", message="Invalid Sms Twilio phone number")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="SMS parameter [phoneNum] should not be null") @Pattern(regexp="\\+\\d{6,}", message="Invalid Sms Twilio phone number") String phoneNum;
    @Schema(name="userLimitEnable", description="Whether to control the limit of authentication for the same phone number.")
    @NotNull(message="SMS parameter [userLimitEnable] should not be null")
    private @NotNull(message="SMS parameter [userLimitEnable] should not be null") Boolean userLimitEnable;
    @Schema(name="userLimit", description="User limit with the same phone number, should be within the range of 1\u201310. Required when parameter [userLimitEnable] is true.")
    @Range(min=1L, max=10L, message="Sms user limit should be from 1 to 10.")
    private @Range(min=1L, max=10L, message="Sms user limit should be from 1 to 10.") Integer userLimit;
    @Schema(name="authTimeout", description="Portal auth timeout setting.")
    @NotNull(message="SMS parameter [authTimeOut] should not be null")
    @Valid
    private @NotNull(message="SMS parameter [authTimeOut] should not be null") @Valid PortalAuthTimeoutOpenApiVO authTimeout;
    @Schema(name="countryCode", description="Preset Contry code. String value such as \"+86\".")
    @Pattern(regexp="^$|^\\+(93|374|994|973|880|975|673|855|86|670|995|852|91|62|98|964|972|81|962|850|82|965|996|856|961|853|60|960|976|95|977|968|92|970|63|974|7|966|65|94|963|886|992|66|90|90|993|971|998|84|967|355|376|43|375|32|387|359|3491|385|357|420|45|372|298|358|33|49|350|30|36|354|353|39|371|423|370|352|389|356|373|377|382|31|47|48|351|40|378|381|421|386|34|46|41|380|44|379|213|244|229|267|226|257|237|3491|238|236|235|269|242|243|253|20|240|291|251|241|220|233|224|245|225|254|266|231|218|261|265|223|222|230|212|258|264|227|234|262|250|239|221|248|232|252|27|211|34|249|268|255|228|216|256|260|263|1684|61|682|679|689|1671|692|691|687|64|1670|680|675|685|677|676|688|678|1684|1264|1268|297|247|1|1246|501|1441|1|1345|506|53|1767|1809|1809201|503|299|1473|590|1671|502|509|504|1876|596|52|1664|599|505|1670|507|1787|1869|1758|508|1784|1868|1649|1|1284|1340|54|591|55|56|57|593|500|594|592|595|51|597|598|58|383)$", message="SMS parameter [countryCode] is invalid.")
    private @Pattern(regexp="^$|^\\+(93|374|994|973|880|975|673|855|86|670|995|852|91|62|98|964|972|81|962|850|82|965|996|856|961|853|60|960|976|95|977|968|92|970|63|974|7|966|65|94|963|886|992|66|90|90|993|971|998|84|967|355|376|43|375|32|387|359|3491|385|357|420|45|372|298|358|33|49|350|30|36|354|353|39|371|423|370|352|389|356|373|377|382|31|47|48|351|40|378|381|421|386|34|46|41|380|44|379|213|244|229|267|226|257|237|3491|238|236|235|269|242|243|253|20|240|291|251|241|220|233|224|245|225|254|266|231|218|261|265|223|222|230|212|258|264|227|234|262|250|239|221|248|232|252|27|211|34|249|268|255|228|216|256|260|263|1684|61|682|679|689|1671|692|691|687|64|1670|680|675|685|677|676|688|678|1684|1264|1268|297|247|1|1246|501|1441|1|1345|506|53|1767|1809|1809201|503|299|1473|590|1671|502|509|504|1876|596|52|1664|599|505|1670|507|1787|1869|1758|508|1784|1868|1649|1|1284|1340|54|591|55|56|57|593|500|594|592|595|51|597|598|58|383)$", message="SMS parameter [countryCode] is invalid.") String countryCode;

    @Generated
    public String getSid() {
        return this.sid;
    }

    @Generated
    public String getAuthToken() {
        return this.authToken;
    }

    @Generated
    public String getPhoneNum() {
        return this.phoneNum;
    }

    @Generated
    public Boolean getUserLimitEnable() {
        return this.userLimitEnable;
    }

    @Generated
    public Integer getUserLimit() {
        return this.userLimit;
    }

    @Generated
    public PortalAuthTimeoutOpenApiVO getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public void setSid(String sid) {
        this.sid = sid;
    }

    @Generated
    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    @Generated
    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    @Generated
    public void setUserLimitEnable(Boolean userLimitEnable) {
        this.userLimitEnable = userLimitEnable;
    }

    @Generated
    public void setUserLimit(Integer userLimit) {
        this.userLimit = userLimit;
    }

    @Generated
    public void setAuthTimeout(PortalAuthTimeoutOpenApiVO authTimeout) {
        this.authTimeout = authTimeout;
    }

    @Generated
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public String toString() {
        return "SmsSettingOpenApiVO(sid=" + this.getSid() + ", authToken=" + this.getAuthToken() + ", phoneNum=" + this.getPhoneNum() + ", userLimitEnable=" + this.getUserLimitEnable() + ", userLimit=" + this.getUserLimit() + ", authTimeout=" + this.getAuthTimeout() + ", countryCode=" + this.getCountryCode() + ")";
    }

    @Generated
    public SmsSettingOpenApiVO() {
    }

    @Generated
    public SmsSettingOpenApiVO(String sid, String authToken, String phoneNum, Boolean userLimitEnable, Integer userLimit, PortalAuthTimeoutOpenApiVO authTimeout, String countryCode) {
        this.sid = sid;
        this.authToken = authToken;
        this.phoneNum = phoneNum;
        this.userLimitEnable = userLimitEnable;
        this.userLimit = userLimit;
        this.authTimeout = authTimeout;
        this.countryCode = countryCode;
    }
}

