/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.openapi.vo.GoogleOAuthSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.ExternalPortalSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.ExternalRadiusSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.HotspotRadiusSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.HotspotSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.ImportedPortalPageOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.LdapSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.NoAuthSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalAuthTimeoutOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalCustomizeOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.SimplePasswordSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.SmsSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.SocialLoginSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.validate.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.groups.Default;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@Schema(name="PortalSetting", description="Portal Setting.")
public class PortalSettingOpenApiVO {
    public static final String PORTAL_NAME_REGEX = "^[^ ]$|^[^ ].{0,126}[^ ]$";
    public static final String BUTTON_TEXT_REGEX = "^[^ ]$|^[^ ].{0,30}[^ ]$";
    public static final String WELCOME_INFO_REGEX = "^.{1,31}$";
    @Schema(name="name", description="Portal Name, should contain 1 to 128 characters")
    @NotNull(message="PortalSetting parameter [name] should not be null", groups={a.a.class})
    @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Portal name is invalid.")
    private @NotNull(message="PortalSetting parameter [name] should not be null", groups={a.a.class}) @Pattern(regexp="^[^ ]$|^[^ ].{0,126}[^ ]$", message="Portal name is invalid.") String name;
    @Schema(name="enable", description="Portal Enable")
    @NotNull(message="PortalSetting parameter [enable] should not be null", groups={Default.class, a.l.class})
    private @NotNull(message="PortalSetting parameter [enable] should not be null", groups={Default.class, a.l.class}) Boolean enable;
    @Schema(name="ssidList", description="SSID ID list bound with this Portal. SSID can be created using 'Create new SSID' ('Create new SSID template') interface, and SSID ID can be obtained from 'Get SSID list' ('Get SSID template list') interface")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private List<String> ssidList;
    @Schema(name="networkList", description="Lan network ID list bound with this Portal. LAN Network can be created using 'Create LAN network' ('Create LAN network template') interface, and LAN Network ID can be obtained from 'Get LAN network list' ('Get LAN network template list') interface")
    private List<String> networkList;
    @Schema(name="authType", description="Auth Type, should be a value as follows: <br/>0\uff1aNo Authentication; 1\uff1aSimple Password;<br/>2: External Radius Server; 4\uff1aExternal Portal Server;<br/>11\uff1aHotspot; 15: Ldap; 16: Social Login")
    @NotNull(message="PortalSetting parameter [authType] should not be null")
    @NumberSet(value={0, 1, 2, 4, 11, 15, 16}, message="Invalid portal auth type.")
    private @NotNull(message="PortalSetting parameter [authType] should not be null") Integer authType;
    @Schema(name="authTimeout", description="Portal auth timeout setting.Not null when auth type is [No Authentication, Simple Password, Radius Server].")
    @Valid
    @NotNull(groups={a.k.class, a.m.class, a.d.class}, message="PortalSetting parameter [authTimeout] should not be null")
    private @Valid @NotNull(groups={a.k.class, a.m.class, a.d.class}, message="PortalSetting parameter [authTimeout] should not be null") PortalAuthTimeoutOpenApiVO authTimeout;
    @Schema(name="httpsRedirectEnable", description="With this option enabled, unauthenticated clients will be redirected to the Portal page when they are trying to browse HTTPS websites.")
    @NotNull(message="PortalSetting parameter [httpsRedirectEnable] should not be null")
    private @NotNull(message="PortalSetting parameter [httpsRedirectEnable] should not be null") Boolean httpsRedirectEnable;
    @Schema(name="landingPage", description="LandingPage enum: 1: Redirect to the original URL, 2: Redirect to Promotional URL, 3: Redirect to Logout Page. <br/>With The Original URL selected, clients are directed to the URL they request for after they pass Portal authentication. <br/>With The Promotional URL selected, clients are directed to the specified URL here after they pass Portal authentication. <br/>With The Logout Page selected, clients are directed to the Portal Logout Page after they pass Portal authentication. ")
    @NumberSet(value={1, 2, 3}, message="PortalSetting parameter [landingPage] should be 1 or 2 or 3")
    @NotNull(groups={a.k.class, a.m.class, a.i.class, a.d.class, a.c.class}, message="PortalSetting parameter [landingPage] should not be null")
    private @NotNull(groups={a.k.class, a.m.class, a.i.class, a.d.class, a.c.class}, message="PortalSetting parameter [landingPage] should not be null") Integer landingPage;
    @Schema(name="landingUrlScheme", description="If Parameter [landingPage] is 2(Redirect to Promotional URL),this Parameter is requested, content is http or https.")
    @Pattern(regexp="http|https", message="PortalSetting parameter [landingUrlScheme] should be \"http\" or \"https\"")
    private @Pattern(regexp="http|https", message="PortalSetting parameter [landingUrlScheme] should be \"http\" or \"https\"") String landingUrlScheme;
    @Schema(name="landingUrl", description="If Parameter [landingPage] is 2(Redirect to Promotional URL),this Parameter is requested.")
    @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$", message="Value of landingUrl is invalid.")
    private @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$", message="Value of landingUrl is invalid.") String landingUrl;
    @Schema(name="noAuth", description="No Auth Portal setting, required when Parameter[authType] is 0.")
    @Valid
    private NoAuthSettingOpenApiVO noAuth;
    @Schema(name="simplePassword", description="Simple Password Portal setting, required when Parameter[authType] is 1.")
    @Valid
    private SimplePasswordSettingOpenApiVO simplePassword;
    @Schema(name="hotspot", description="Hotspot enabled type setting, required when Parameter[authType] is 11.")
    @Valid
    private HotspotSettingOpenApiVO hotspot;
    @Schema(name="socialLogin", description="Social login setting, required when Parameter[authType] is 16. Should be a value as follows:<br/>17: Google")
    @Valid
    private SocialLoginSettingOpenApiVO socialLogin;
    @Schema(name="google", description="Google OAuth setting, required when [authType] is 16 and social auth [enabledTypes] contains 17.")
    @Valid
    private GoogleOAuthSettingOpenApiVO google;
    @Schema(name="sms", description="Hotspot: SMS Portal setting, required when [authType] is 11 and hotspot [enabledTypes] contains 6.")
    @Valid
    @Null(message="Basic user should not use sms portal", groups={a.b.class})
    private @Valid @Null(message="Basic user should not use sms portal", groups={a.b.class}) SmsSettingOpenApiVO sms;
    @Schema(name="portalFormId", description="Portal form ID, required when [authType] is 11 and hotspot [enabledTypes] contains 12.")
    private String portalFormId;
    @Schema(name="hotspotRadius", description="Hotspot: RADIUS Portal setting, required when [authType] is 11 and hotspot [enabledTypes] contains 8.")
    @Valid
    private HotspotRadiusSettingOpenApiVO hotspotRadius;
    @Schema(name="externalPortal", description="External Server Portal setting, required when [authType] is 4.")
    @Valid
    private ExternalPortalSettingOpenApiVO externalPortal;
    @Schema(name="externalRadius", description="External Radius Portal setting, required when [authType] is 2.")
    @Valid
    private ExternalRadiusSettingOpenApiVO externalRadius;
    @Schema(name="ldap", description="LDAP Portal setting, required when [authType] is 15.")
    @Valid
    private LdapSettingOpenApiVO ldap;
    @NumberSet(value={1, 2})
    @Schema(name="pageType", description="Page type, should be a value as follows: 1: Use default page, 2: use uploaded page. When [pageType] is null, it defaults to 1")
    private Integer pageType;
    @Schema(name="importedPortalPage", description="Imported portal page, required when parameter [pageType] is 2")
    @Valid
    private ImportedPortalPageOpenApiVO importedPortalPage;
    @Schema(name="portalCustomize", description="Portal Customize, required when parameter [pageType] is 1 or null")
    @Valid
    private PortalCustomizeOpenApiVO portalCustomize;

    @JsonIgnore
    public OperationResponse<Object> valid() {
        if ((this.pageType == null || Objects.equals(1, this.pageType)) && this.portalCustomize == null && !Objects.equals(4, this.authType)) {
            return new OperationResponse(b.d, "Parameter [portalCustomize] should not be null.", null);
        }
        if (Objects.equals(2, this.pageType) && this.importedPortalPage == null) {
            return new OperationResponse(b.d, "Parameter [importedPortalPage] should not be null.", null);
        }
        return new OperationResponse(b.a);
    }

    @Generated
    public static PortalSettingOpenApiVOBuilder builder() {
        return new PortalSettingOpenApiVOBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<String> getSsidList() {
        return this.ssidList;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public PortalAuthTimeoutOpenApiVO getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public Boolean getHttpsRedirectEnable() {
        return this.httpsRedirectEnable;
    }

    @Generated
    public Integer getLandingPage() {
        return this.landingPage;
    }

    @Generated
    public String getLandingUrlScheme() {
        return this.landingUrlScheme;
    }

    @Generated
    public String getLandingUrl() {
        return this.landingUrl;
    }

    @Generated
    public NoAuthSettingOpenApiVO getNoAuth() {
        return this.noAuth;
    }

    @Generated
    public SimplePasswordSettingOpenApiVO getSimplePassword() {
        return this.simplePassword;
    }

    @Generated
    public HotspotSettingOpenApiVO getHotspot() {
        return this.hotspot;
    }

    @Generated
    public SocialLoginSettingOpenApiVO getSocialLogin() {
        return this.socialLogin;
    }

    @Generated
    public GoogleOAuthSettingOpenApiVO getGoogle() {
        return this.google;
    }

    @Generated
    public SmsSettingOpenApiVO getSms() {
        return this.sms;
    }

    @Generated
    public String getPortalFormId() {
        return this.portalFormId;
    }

    @Generated
    public HotspotRadiusSettingOpenApiVO getHotspotRadius() {
        return this.hotspotRadius;
    }

    @Generated
    public ExternalPortalSettingOpenApiVO getExternalPortal() {
        return this.externalPortal;
    }

    @Generated
    public ExternalRadiusSettingOpenApiVO getExternalRadius() {
        return this.externalRadius;
    }

    @Generated
    public LdapSettingOpenApiVO getLdap() {
        return this.ldap;
    }

    @Generated
    public Integer getPageType() {
        return this.pageType;
    }

    @Generated
    public ImportedPortalPageOpenApiVO getImportedPortalPage() {
        return this.importedPortalPage;
    }

    @Generated
    public PortalCustomizeOpenApiVO getPortalCustomize() {
        return this.portalCustomize;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setSsidList(List<String> ssidList) {
        this.ssidList = ssidList;
    }

    @Generated
    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setAuthTimeout(PortalAuthTimeoutOpenApiVO authTimeout) {
        this.authTimeout = authTimeout;
    }

    @Generated
    public void setHttpsRedirectEnable(Boolean httpsRedirectEnable) {
        this.httpsRedirectEnable = httpsRedirectEnable;
    }

    @Generated
    public void setLandingPage(Integer landingPage) {
        this.landingPage = landingPage;
    }

    @Generated
    public void setLandingUrlScheme(String landingUrlScheme) {
        this.landingUrlScheme = landingUrlScheme;
    }

    @Generated
    public void setLandingUrl(String landingUrl) {
        this.landingUrl = landingUrl;
    }

    @Generated
    public void setNoAuth(NoAuthSettingOpenApiVO noAuth) {
        this.noAuth = noAuth;
    }

    @Generated
    public void setSimplePassword(SimplePasswordSettingOpenApiVO simplePassword) {
        this.simplePassword = simplePassword;
    }

    @Generated
    public void setHotspot(HotspotSettingOpenApiVO hotspot) {
        this.hotspot = hotspot;
    }

    @Generated
    public void setSocialLogin(SocialLoginSettingOpenApiVO socialLogin) {
        this.socialLogin = socialLogin;
    }

    @Generated
    public void setGoogle(GoogleOAuthSettingOpenApiVO google) {
        this.google = google;
    }

    @Generated
    public void setSms(SmsSettingOpenApiVO sms) {
        this.sms = sms;
    }

    @Generated
    public void setPortalFormId(String portalFormId) {
        this.portalFormId = portalFormId;
    }

    @Generated
    public void setHotspotRadius(HotspotRadiusSettingOpenApiVO hotspotRadius) {
        this.hotspotRadius = hotspotRadius;
    }

    @Generated
    public void setExternalPortal(ExternalPortalSettingOpenApiVO externalPortal) {
        this.externalPortal = externalPortal;
    }

    @Generated
    public void setExternalRadius(ExternalRadiusSettingOpenApiVO externalRadius) {
        this.externalRadius = externalRadius;
    }

    @Generated
    public void setLdap(LdapSettingOpenApiVO ldap) {
        this.ldap = ldap;
    }

    @Generated
    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    @Generated
    public void setImportedPortalPage(ImportedPortalPageOpenApiVO importedPortalPage) {
        this.importedPortalPage = importedPortalPage;
    }

    @Generated
    public void setPortalCustomize(PortalCustomizeOpenApiVO portalCustomize) {
        this.portalCustomize = portalCustomize;
    }

    @Generated
    public String toString() {
        return "PortalSettingOpenApiVO(name=" + this.getName() + ", enable=" + this.getEnable() + ", ssidList=" + this.getSsidList() + ", networkList=" + this.getNetworkList() + ", authType=" + this.getAuthType() + ", authTimeout=" + this.getAuthTimeout() + ", httpsRedirectEnable=" + this.getHttpsRedirectEnable() + ", landingPage=" + this.getLandingPage() + ", landingUrlScheme=" + this.getLandingUrlScheme() + ", landingUrl=" + this.getLandingUrl() + ", noAuth=" + this.getNoAuth() + ", simplePassword=" + this.getSimplePassword() + ", hotspot=" + this.getHotspot() + ", socialLogin=" + this.getSocialLogin() + ", google=" + this.getGoogle() + ", sms=" + this.getSms() + ", portalFormId=" + this.getPortalFormId() + ", hotspotRadius=" + this.getHotspotRadius() + ", externalPortal=" + this.getExternalPortal() + ", externalRadius=" + this.getExternalRadius() + ", ldap=" + this.getLdap() + ", pageType=" + this.getPageType() + ", importedPortalPage=" + this.getImportedPortalPage() + ", portalCustomize=" + this.getPortalCustomize() + ")";
    }

    @Generated
    public PortalSettingOpenApiVO(String name, Boolean enable, List<String> ssidList, List<String> networkList, Integer authType, PortalAuthTimeoutOpenApiVO authTimeout, Boolean httpsRedirectEnable, Integer landingPage, String landingUrlScheme, String landingUrl, NoAuthSettingOpenApiVO noAuth, SimplePasswordSettingOpenApiVO simplePassword, HotspotSettingOpenApiVO hotspot, SocialLoginSettingOpenApiVO socialLogin, GoogleOAuthSettingOpenApiVO google, SmsSettingOpenApiVO sms, String portalFormId, HotspotRadiusSettingOpenApiVO hotspotRadius, ExternalPortalSettingOpenApiVO externalPortal, ExternalRadiusSettingOpenApiVO externalRadius, LdapSettingOpenApiVO ldap, Integer pageType, ImportedPortalPageOpenApiVO importedPortalPage, PortalCustomizeOpenApiVO portalCustomize) {
        this.name = name;
        this.enable = enable;
        this.ssidList = ssidList;
        this.networkList = networkList;
        this.authType = authType;
        this.authTimeout = authTimeout;
        this.httpsRedirectEnable = httpsRedirectEnable;
        this.landingPage = landingPage;
        this.landingUrlScheme = landingUrlScheme;
        this.landingUrl = landingUrl;
        this.noAuth = noAuth;
        this.simplePassword = simplePassword;
        this.hotspot = hotspot;
        this.socialLogin = socialLogin;
        this.google = google;
        this.sms = sms;
        this.portalFormId = portalFormId;
        this.hotspotRadius = hotspotRadius;
        this.externalPortal = externalPortal;
        this.externalRadius = externalRadius;
        this.ldap = ldap;
        this.pageType = pageType;
        this.importedPortalPage = importedPortalPage;
        this.portalCustomize = portalCustomize;
    }

    @Generated
    public PortalSettingOpenApiVO() {
    }

    @Generated
    public static class PortalSettingOpenApiVOBuilder {
        @Generated
        private String name;
        @Generated
        private Boolean enable;
        @Generated
        private List<String> ssidList;
        @Generated
        private List<String> networkList;
        @Generated
        private Integer authType;
        @Generated
        private PortalAuthTimeoutOpenApiVO authTimeout;
        @Generated
        private Boolean httpsRedirectEnable;
        @Generated
        private Integer landingPage;
        @Generated
        private String landingUrlScheme;
        @Generated
        private String landingUrl;
        @Generated
        private NoAuthSettingOpenApiVO noAuth;
        @Generated
        private SimplePasswordSettingOpenApiVO simplePassword;
        @Generated
        private HotspotSettingOpenApiVO hotspot;
        @Generated
        private SocialLoginSettingOpenApiVO socialLogin;
        @Generated
        private GoogleOAuthSettingOpenApiVO google;
        @Generated
        private SmsSettingOpenApiVO sms;
        @Generated
        private String portalFormId;
        @Generated
        private HotspotRadiusSettingOpenApiVO hotspotRadius;
        @Generated
        private ExternalPortalSettingOpenApiVO externalPortal;
        @Generated
        private ExternalRadiusSettingOpenApiVO externalRadius;
        @Generated
        private LdapSettingOpenApiVO ldap;
        @Generated
        private Integer pageType;
        @Generated
        private ImportedPortalPageOpenApiVO importedPortalPage;
        @Generated
        private PortalCustomizeOpenApiVO portalCustomize;

        @Generated
        PortalSettingOpenApiVOBuilder() {
        }

        @Generated
        public PortalSettingOpenApiVOBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder ssidList(List<String> ssidList) {
            this.ssidList = ssidList;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder networkList(List<String> networkList) {
            this.networkList = networkList;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder authType(Integer authType) {
            this.authType = authType;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder authTimeout(PortalAuthTimeoutOpenApiVO authTimeout) {
            this.authTimeout = authTimeout;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder httpsRedirectEnable(Boolean httpsRedirectEnable) {
            this.httpsRedirectEnable = httpsRedirectEnable;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder landingPage(Integer landingPage) {
            this.landingPage = landingPage;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder landingUrlScheme(String landingUrlScheme) {
            this.landingUrlScheme = landingUrlScheme;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder landingUrl(String landingUrl) {
            this.landingUrl = landingUrl;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder noAuth(NoAuthSettingOpenApiVO noAuth) {
            this.noAuth = noAuth;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder simplePassword(SimplePasswordSettingOpenApiVO simplePassword) {
            this.simplePassword = simplePassword;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder hotspot(HotspotSettingOpenApiVO hotspot) {
            this.hotspot = hotspot;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder socialLogin(SocialLoginSettingOpenApiVO socialLogin) {
            this.socialLogin = socialLogin;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder google(GoogleOAuthSettingOpenApiVO google) {
            this.google = google;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder sms(SmsSettingOpenApiVO sms) {
            this.sms = sms;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder portalFormId(String portalFormId) {
            this.portalFormId = portalFormId;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder hotspotRadius(HotspotRadiusSettingOpenApiVO hotspotRadius) {
            this.hotspotRadius = hotspotRadius;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder externalPortal(ExternalPortalSettingOpenApiVO externalPortal) {
            this.externalPortal = externalPortal;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder externalRadius(ExternalRadiusSettingOpenApiVO externalRadius) {
            this.externalRadius = externalRadius;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder ldap(LdapSettingOpenApiVO ldap) {
            this.ldap = ldap;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder pageType(Integer pageType) {
            this.pageType = pageType;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder importedPortalPage(ImportedPortalPageOpenApiVO importedPortalPage) {
            this.importedPortalPage = importedPortalPage;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVOBuilder portalCustomize(PortalCustomizeOpenApiVO portalCustomize) {
            this.portalCustomize = portalCustomize;
            return this;
        }

        @Generated
        public PortalSettingOpenApiVO build() {
            return new PortalSettingOpenApiVO(this.name, this.enable, this.ssidList, this.networkList, this.authType, this.authTimeout, this.httpsRedirectEnable, this.landingPage, this.landingUrlScheme, this.landingUrl, this.noAuth, this.simplePassword, this.hotspot, this.socialLogin, this.google, this.sms, this.portalFormId, this.hotspotRadius, this.externalPortal, this.externalRadius, this.ldap, this.pageType, this.importedPortalPage, this.portalCustomize);
        }

        @Generated
        public String toString() {
            return "PortalSettingOpenApiVO.PortalSettingOpenApiVOBuilder(name=" + this.name + ", enable=" + this.enable + ", ssidList=" + this.ssidList + ", networkList=" + this.networkList + ", authType=" + this.authType + ", authTimeout=" + this.authTimeout + ", httpsRedirectEnable=" + this.httpsRedirectEnable + ", landingPage=" + this.landingPage + ", landingUrlScheme=" + this.landingUrlScheme + ", landingUrl=" + this.landingUrl + ", noAuth=" + this.noAuth + ", simplePassword=" + this.simplePassword + ", hotspot=" + this.hotspot + ", socialLogin=" + this.socialLogin + ", google=" + this.google + ", sms=" + this.sms + ", portalFormId=" + this.portalFormId + ", hotspotRadius=" + this.hotspotRadius + ", externalPortal=" + this.externalPortal + ", externalRadius=" + this.externalRadius + ", ldap=" + this.ldap + ", pageType=" + this.pageType + ", importedPortalPage=" + this.importedPortalPage + ", portalCustomize=" + this.portalCustomize + ")";
        }
    }
}

