/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.portal.api.openapi.vo.AuthTimeOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.GoogleOAuthSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.ExternalPortalSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.ExternalRadiusSettingResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.HotspotRadiusSettingResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.HotspotSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.LdapSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.NoAuthSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.SimplePasswordSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.SmsSettingResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.SocialLoginSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.PortalSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class PortalDetailResOpenApiVO {
    @Schema(name="id", description="Portal ID")
    private String id;
    @Schema(name="name", description="Portal name, should contain 1 to 128 characters")
    private String name;
    @Schema(name="enable", description="Portal enable status")
    private Boolean enable;
    @Schema(name="ssidList", description="SSID ID list bound with this Portal. SSID can be created using 'Create new SSID' ('Create new SSID template') interface, and SSID ID can be obtained from 'Get SSID list' ('Get SSID template list') interface")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private List<String> ssidList;
    @Schema(name="networkList", description="Lan network ID list bound with this Portal. LAN Network can be created using 'Create LAN network' ('Create LAN network template') interface, and LAN Network ID can be obtained from 'Get LAN network list' ('Get LAN network template list') interface")
    private List<String> networkList;
    @Schema(name="authType", description="Auth Type, should be a value as follows: <br/>0\uff1aNo Authentication; 1\uff1aSimple Password;<br/>2: External Radius Server; 4\uff1aExternal Portal Server;<br/>11\uff1aHotspot; 15: Ldap; 16: Social Login.")
    private Integer authType;
    @Schema(name="authTimeout", description="Portal auth timeout setting.Not null when auth type is [No Authentication, Simple Password, Radius Server].")
    private AuthTimeOpenApiVO authTimeout;
    @Schema(name="httpsRedirectEnable", description="With this option enabled, unauthenticated clients will be redirected to the Portal page when they are trying to browse HTTPS websites.")
    private Boolean httpsRedirectEnable;
    @Schema(name="landingPage", description="LandingPage enum, should be a value as follows: 1: Redirect to the original URL, 2: Redirect to Promotional URL. <br/>With The Original URL selected, clients are directed to the URL they request for after they pass Portal authentication. <br/>With The Promotional URL selected, clients are directed to the specified URL here after they pass Portal authentication.")
    private Integer landingPage;
    @Schema(name="landingUrlScheme", description="If Parameter [landingPage] is 2(Redirect to Promotional URL),this Parameter is requested, content is http or https.")
    private String landingUrlScheme;
    @Schema(name="landingUrl", description="If Parameter [landingPage] is 2(Redirect to Promotional URL),this Parameter is requested.")
    private String landingUrl;
    @Schema(name="noAuth", description="No Auth Portal setting, required when Parameter[authType] is 0.")
    private NoAuthSettingOpenApiVO noAuth;
    @Schema(name="simplePassword", description="Simple Password Portal setting, required when Parameter[authType] is 1.")
    private SimplePasswordSettingOpenApiVO simplePassword;
    @Schema(name="hotspot", description="Hotspot enabled type setting, required when Parameter[authType] is 11.")
    private HotspotSettingOpenApiVO hotspot;
    @Schema(name="socialLogin", description="Social login setting, required when Parameter[authType] is 16. Should be a value as follows:<br/>17\uff1aGoogle social login")
    @Valid
    private SocialLoginSettingOpenApiVO socialLogin;
    @Schema(name="google", description="Google OAuth setting, required when [authType] is 16 and social auth [enabledTypes] contains 17.")
    @Valid
    private GoogleOAuthSettingOpenApiVO google;
    @Schema(name="sms", description="Hotspot: SMS Portal setting, required when [authType] is 11 and hotspot [enabledTypes] contains 6.")
    private SmsSettingResOpenApiVO sms;
    @Schema(name="portalFormId", description="Portal form ID, required when [authType] is 11 and hotspot [enabledTypes] contains 12. Portal form can be created using 'Create a new authentication survey' interface, and Portal form ID can be obtained from 'Get authentication survey list' interface")
    private String portalFormId;
    @Schema(name="hotspotRadius", description="Hotspot: RADIUS Portal setting, required when [authType] is 11 and hotspot [enabledTypes] contains 8.")
    private HotspotRadiusSettingResOpenApiVO hotspotRadius;
    @Schema(name="externalPortal", description="External Server Portal setting, required when [authType] is 4.")
    private ExternalPortalSettingOpenApiVO externalPortal;
    @Schema(name="externalRadius", description="External Radius Portal setting, required when [authType] is 2.")
    private ExternalRadiusSettingResOpenApiVO externalRadius;
    @Schema(name="ldap", description="LDAP Portal setting, required when [authType] is 15.")
    private LdapSettingOpenApiVO ldap;

    public static PortalDetailResOpenApiVO fromVO(PortalSettingVO vo) {
        if (vo == null) {
            return null;
        }
        PortalDetailResOpenApiVO portalDetailResOpenApiVO = new PortalDetailResOpenApiVO();
        portalDetailResOpenApiVO.setId(vo.getId());
        portalDetailResOpenApiVO.setName(vo.getName());
        portalDetailResOpenApiVO.setEnable(vo.getEnable());
        portalDetailResOpenApiVO.setSsidList(vo.getSsidList());
        portalDetailResOpenApiVO.setNetworkList(vo.getNetworkList());
        portalDetailResOpenApiVO.setAuthType(vo.getAuthType());
        portalDetailResOpenApiVO.setAuthTimeout(Optional.ofNullable(vo.getAuthTimeout()).map(AuthTimeOpenApiVO::fromVO).orElse(null));
        portalDetailResOpenApiVO.setHttpsRedirectEnable(vo.getHttpsRedirectEnable());
        portalDetailResOpenApiVO.setLandingPage(vo.getLandingPage());
        portalDetailResOpenApiVO.setLandingUrlScheme(vo.getLandingUrlScheme());
        portalDetailResOpenApiVO.setLandingUrl(vo.getLandingUrl());
        portalDetailResOpenApiVO.setNoAuth(Optional.ofNullable(vo.getNoAuth()).map(setting -> new NoAuthSettingOpenApiVO(setting.getDailyLimitEnable())).orElse(null));
        portalDetailResOpenApiVO.setSimplePassword(Optional.ofNullable(vo.getSimplePassword()).map(setting -> new SimplePasswordSettingOpenApiVO(setting.getPassword())).orElse(null));
        portalDetailResOpenApiVO.setHotspot(Optional.ofNullable(vo.getHotspot()).map(setting -> new HotspotSettingOpenApiVO(setting.getEnabledTypes())).orElse(null));
        portalDetailResOpenApiVO.setSocialLogin(Optional.ofNullable(vo.getSocialLogin()).map(setting -> new SocialLoginSettingOpenApiVO().setEnabledTypes(setting.getEnabledTypes())).orElse(null));
        portalDetailResOpenApiVO.setGoogle(Optional.ofNullable(vo.getGoogle()).map(setting -> new GoogleOAuthSettingOpenApiVO().setClientId(setting.getClientId()).setClientSecret(setting.getClientSecret())).orElse(null));
        portalDetailResOpenApiVO.setSms(Optional.ofNullable(vo.getSms()).map(SmsSettingResOpenApiVO::fromVO).orElse(null));
        portalDetailResOpenApiVO.setPortalFormId(vo.getPortalFormId());
        portalDetailResOpenApiVO.setHotspotRadius(Optional.ofNullable(vo.getHotspotRadius()).map(HotspotRadiusSettingResOpenApiVO::fromVO).orElse(null));
        portalDetailResOpenApiVO.setExternalPortal(Optional.ofNullable(vo.getExternalPortal()).map(ExternalPortalSettingOpenApiVO::fromVO).orElse(null));
        portalDetailResOpenApiVO.setExternalRadius(Optional.ofNullable(vo.getExternalRadius()).map(ExternalRadiusSettingResOpenApiVO::fromVO).orElse(null));
        portalDetailResOpenApiVO.setLdap(Optional.ofNullable(vo.getLdap()).map(LdapSettingOpenApiVO::fromVO).orElse(null));
        return portalDetailResOpenApiVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<String> getSsidList() {
        return this.ssidList;
    }

    @Generated
    public List<String> getNetworkList() {
        return this.networkList;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public AuthTimeOpenApiVO getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public Boolean getHttpsRedirectEnable() {
        return this.httpsRedirectEnable;
    }

    @Generated
    public Integer getLandingPage() {
        return this.landingPage;
    }

    @Generated
    public String getLandingUrlScheme() {
        return this.landingUrlScheme;
    }

    @Generated
    public String getLandingUrl() {
        return this.landingUrl;
    }

    @Generated
    public NoAuthSettingOpenApiVO getNoAuth() {
        return this.noAuth;
    }

    @Generated
    public SimplePasswordSettingOpenApiVO getSimplePassword() {
        return this.simplePassword;
    }

    @Generated
    public HotspotSettingOpenApiVO getHotspot() {
        return this.hotspot;
    }

    @Generated
    public SocialLoginSettingOpenApiVO getSocialLogin() {
        return this.socialLogin;
    }

    @Generated
    public GoogleOAuthSettingOpenApiVO getGoogle() {
        return this.google;
    }

    @Generated
    public SmsSettingResOpenApiVO getSms() {
        return this.sms;
    }

    @Generated
    public String getPortalFormId() {
        return this.portalFormId;
    }

    @Generated
    public HotspotRadiusSettingResOpenApiVO getHotspotRadius() {
        return this.hotspotRadius;
    }

    @Generated
    public ExternalPortalSettingOpenApiVO getExternalPortal() {
        return this.externalPortal;
    }

    @Generated
    public ExternalRadiusSettingResOpenApiVO getExternalRadius() {
        return this.externalRadius;
    }

    @Generated
    public LdapSettingOpenApiVO getLdap() {
        return this.ldap;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setSsidList(List<String> ssidList) {
        this.ssidList = ssidList;
    }

    @Generated
    public void setNetworkList(List<String> networkList) {
        this.networkList = networkList;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setAuthTimeout(AuthTimeOpenApiVO authTimeout) {
        this.authTimeout = authTimeout;
    }

    @Generated
    public void setHttpsRedirectEnable(Boolean httpsRedirectEnable) {
        this.httpsRedirectEnable = httpsRedirectEnable;
    }

    @Generated
    public void setLandingPage(Integer landingPage) {
        this.landingPage = landingPage;
    }

    @Generated
    public void setLandingUrlScheme(String landingUrlScheme) {
        this.landingUrlScheme = landingUrlScheme;
    }

    @Generated
    public void setLandingUrl(String landingUrl) {
        this.landingUrl = landingUrl;
    }

    @Generated
    public void setNoAuth(NoAuthSettingOpenApiVO noAuth) {
        this.noAuth = noAuth;
    }

    @Generated
    public void setSimplePassword(SimplePasswordSettingOpenApiVO simplePassword) {
        this.simplePassword = simplePassword;
    }

    @Generated
    public void setHotspot(HotspotSettingOpenApiVO hotspot) {
        this.hotspot = hotspot;
    }

    @Generated
    public void setSocialLogin(SocialLoginSettingOpenApiVO socialLogin) {
        this.socialLogin = socialLogin;
    }

    @Generated
    public void setGoogle(GoogleOAuthSettingOpenApiVO google) {
        this.google = google;
    }

    @Generated
    public void setSms(SmsSettingResOpenApiVO sms) {
        this.sms = sms;
    }

    @Generated
    public void setPortalFormId(String portalFormId) {
        this.portalFormId = portalFormId;
    }

    @Generated
    public void setHotspotRadius(HotspotRadiusSettingResOpenApiVO hotspotRadius) {
        this.hotspotRadius = hotspotRadius;
    }

    @Generated
    public void setExternalPortal(ExternalPortalSettingOpenApiVO externalPortal) {
        this.externalPortal = externalPortal;
    }

    @Generated
    public void setExternalRadius(ExternalRadiusSettingResOpenApiVO externalRadius) {
        this.externalRadius = externalRadius;
    }

    @Generated
    public void setLdap(LdapSettingOpenApiVO ldap) {
        this.ldap = ldap;
    }

    @Generated
    public String toString() {
        return "PortalDetailResOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", enable=" + this.getEnable() + ", ssidList=" + this.getSsidList() + ", networkList=" + this.getNetworkList() + ", authType=" + this.getAuthType() + ", authTimeout=" + this.getAuthTimeout() + ", httpsRedirectEnable=" + this.getHttpsRedirectEnable() + ", landingPage=" + this.getLandingPage() + ", landingUrlScheme=" + this.getLandingUrlScheme() + ", landingUrl=" + this.getLandingUrl() + ", noAuth=" + this.getNoAuth() + ", simplePassword=" + this.getSimplePassword() + ", hotspot=" + this.getHotspot() + ", socialLogin=" + this.getSocialLogin() + ", google=" + this.getGoogle() + ", sms=" + this.getSms() + ", portalFormId=" + this.getPortalFormId() + ", hotspotRadius=" + this.getHotspotRadius() + ", externalPortal=" + this.getExternalPortal() + ", externalRadius=" + this.getExternalRadius() + ", ldap=" + this.getLdap() + ")";
    }

    @Generated
    public PortalDetailResOpenApiVO() {
    }

    @Generated
    public PortalDetailResOpenApiVO(String id, String name, Boolean enable, List<String> ssidList, List<String> networkList, Integer authType, AuthTimeOpenApiVO authTimeout, Boolean httpsRedirectEnable, Integer landingPage, String landingUrlScheme, String landingUrl, NoAuthSettingOpenApiVO noAuth, SimplePasswordSettingOpenApiVO simplePassword, HotspotSettingOpenApiVO hotspot, SocialLoginSettingOpenApiVO socialLogin, GoogleOAuthSettingOpenApiVO google, SmsSettingResOpenApiVO sms, String portalFormId, HotspotRadiusSettingResOpenApiVO hotspotRadius, ExternalPortalSettingOpenApiVO externalPortal, ExternalRadiusSettingResOpenApiVO externalRadius, LdapSettingOpenApiVO ldap) {
        this.id = id;
        this.name = name;
        this.enable = enable;
        this.ssidList = ssidList;
        this.networkList = networkList;
        this.authType = authType;
        this.authTimeout = authTimeout;
        this.httpsRedirectEnable = httpsRedirectEnable;
        this.landingPage = landingPage;
        this.landingUrlScheme = landingUrlScheme;
        this.landingUrl = landingUrl;
        this.noAuth = noAuth;
        this.simplePassword = simplePassword;
        this.hotspot = hotspot;
        this.socialLogin = socialLogin;
        this.google = google;
        this.sms = sms;
        this.portalFormId = portalFormId;
        this.hotspotRadius = hotspotRadius;
        this.externalPortal = externalPortal;
        this.externalRadius = externalRadius;
        this.ldap = ldap;
    }
}

