/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.tplink.smb.omada.portal.api.openapi.vo.portal.AdvertisementSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.TermsOfServiceUrlVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class PortalCustomizeOpenApiVO {
    @Schema(name="defaultLanguage", description="The controller automatically adjusts the language displayed on the Portal page according to the system language of the clients.If the language is not supported, the controller will use the default language specified here.<br/>1: en_US (English); 3: cs_CZ (\u010cesk\u00fd); 4: de_DE (Deutsch); 5: da_DK (Dansk); 6: el_GR (\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac);<br/>7: fr_FR (Fran\u00e7ais); 8: es_ES (Espa\u00f1ol); 9: nl_NL (Nederlands); 10: it_IT (Italiano); 11: pl_PL (Polski);<br/>12: pt_PT (Portugu\u00eas); 13: ru_RU (\u0420\u0443\u0441\u0441\u043a\u0438\u0439); 14: sv_SE (Svenska); 15: tr_TR (T\u00fcrk\u00e7e);<br/>16: ar_SA (\u0644\u063a\u0629 \u0639\u0631\u0628\u064a\u0629); <br/>17: ja_JP (\u65e5\u672c\u8a9e); 18: zh_TW (\u4e2d\u6587(\u7e41\u9ad4)); 19: th_TH (\u0e44\u0e17\u0e22); 20: vi_VN (Ti\u1ebfng Vi\u1ec7t); 21: ko_KR (\ud55c\uad6d\uc5b4)")
    @NotNull(message="portalCustomize parameter [defaultLanguage] should not be null")
    private @NotNull(message="portalCustomize parameter [defaultLanguage] should not be null") Integer defaultLanguage;
    @Schema(name="backgroundPictureId", description="Background picture ID")
    private String backgroundPictureId;
    @Schema(name="logoPictureId", description="Logo picture ID")
    private String logoPictureId;
    @Schema(name="logoDisplay", description="Whether to display the default logo.")
    @NotNull(message="portalCustomize parameter [logoDisplay] should not be null")
    private @NotNull(message="portalCustomize parameter [logoDisplay] should not be null") Boolean logoDisplay;
    @Schema(name="inputBoxColor", description="Input box color. Hex color code such as: #ffffff.")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of inputBoxColor is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of inputBoxColor is invalid.") String inputBoxColor;
    @Schema(name="inputBoxOpacity", description="Input box opacity, should be within the range of 0\u2013100.")
    @Range(min=0L, max=100L, message="Value of inputBoxOpacity is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of inputBoxOpacity is from 0 to 100.") Integer inputBoxOpacity;
    @Schema(name="inputTextColor", description="Input text color. Hex color code such as: #ffffff.")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of inputTextColor is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of inputTextColor is invalid.") String inputTextColor;
    @Schema(name="inputTextOpacity", description="Input text opacity, should be within the range of 0\u2013100.")
    @Range(min=0L, max=100L, message="Value of inputTextOpacity is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of inputTextOpacity is from 0 to 100.") Integer inputTextOpacity;
    @Schema(name="buttonColor", description="Button color. Hex color code such as: #ffffff.")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of buttonColor is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of buttonColor is invalid.") String buttonColor;
    @Schema(name="buttonOpacity", description="Button opacity, should be within the range of 0\u2013100.")
    @Range(min=0L, max=100L, message="Value of buttonOpacity is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of buttonOpacity is from 0 to 100.") Integer buttonOpacity;
    @Schema(name="buttonTextColor", description="Button text color. Hex color code such as: #ffffff.")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of buttonTextColor is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of buttonTextColor is invalid.") String buttonTextColor;
    @Schema(name="buttonTextOpacity", description="Button text opacity, should be within the range of 0\u2013100.")
    @Range(min=0L, max=100L, message="Value of buttonTextOpacity is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of buttonTextOpacity is from 0 to 100.") Integer buttonTextOpacity;
    @Schema(name="buttonText", description="Button text, should contain 0 to 32 characters, default value is \"Log In\".")
    @Length(max=32, message="Length of button text should less than 32.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,30}[^ ]$", message="Value of buttonText is invalid.")
    private @Length(max=32, message="Length of button text should less than 32.") @Pattern(regexp="^[^ ]$|^[^ ].{0,30}[^ ]$", message="Value of buttonText is invalid.") String buttonText;
    @Schema(name="formAuthButtonText", description="Form auth button text, should contain 0 to 32 characters, required when [authType] is 11 and hotspot [enabledTypes] contains 12.Default value is \"Take the Survey\".")
    @Length(max=32, message="Length of button text should less than 32.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,30}[^ ]$", message="Value of formAuthButtonText is invalid.")
    private @Length(max=32, message="Length of button text should less than 32.") @Pattern(regexp="^[^ ]$|^[^ ].{0,30}[^ ]$", message="Value of formAuthButtonText is invalid.") String formAuthButtonText;
    @Schema(name="welcomeEnable", description="Whether to display the welcome info")
    @NotNull(message="portalCustomize parameter [welcomeEnable] should not be null")
    private @NotNull(message="portalCustomize parameter [welcomeEnable] should not be null") Boolean welcomeEnable;
    @Schema(name="welcomeInformation", description="Welcome Information, should contain 1 to 31 characters.")
    @Length(max=31, message="Length of button text should less than 31.")
    @Pattern(regexp="^.{1,31}$", message="Value of welcomeInformation is invalid.")
    private @Length(max=31, message="Length of button text should less than 31.") @Pattern(regexp="^.{1,31}$", message="Value of welcomeInformation is invalid.") String welcomeInformation;
    @Schema(name="welcomeTextColor", description="Welcome text color. Hex color code such as: #ffffff.")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of welcomeTextColor is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="Value of welcomeTextColor is invalid.") String welcomeTextColor;
    @Schema(name="welcomeTextOpacity", description="Welcome text opacity, should be within the range of 0\u2013100.")
    @Range(min=0L, max=100L, message="Value of opacity is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of opacity is from 0 to 100.") Integer welcomeTextOpacity;
    @Schema(name="welcomeTextFontSize", description="Welcome text font size, should be within the range of 12\u201318.")
    @Range(min=12L, max=18L, message="Welcome text font size ranges from 12 to 18.")
    private @Range(min=12L, max=18L, message="Welcome text font size ranges from 12 to 18.") Integer welcomeTextFontSize;
    @Schema(name="termsOfServiceEnable", description="Whether to display terms of service.")
    @NotNull(message="portalCustomize parameter [termsOfServiceEnable] should not be null")
    private @NotNull(message="portalCustomize parameter [termsOfServiceEnable] should not be null") Boolean termsOfServiceEnable;
    @Schema(name="termsOfServiceText", description="Terms of service text, should contain 0 to 100 characters.")
    @Length(max=100, message="Length of terms of service should less than 100.")
    private @Length(max=100, message="Length of terms of service should less than 100.") String termsOfServiceText;
    @Schema(name="termsOfServiceFontSize", description="Terms of service text font size, should be within the range of 12\u201318.")
    @Range(min=12L, max=18L, message="Terms of service font size ranges from 12 to 18.")
    private @Range(min=12L, max=18L, message="Terms of service font size ranges from 12 to 18.") Integer termsOfServiceFontSize;
    @Schema(name="termsOfServiceUrlTexts", description="Terms of service url texts, match the termsOfServiceText and turn the matching characters into an openable link, Up to 3 entries are allowed for the list.")
    @Size(max=3, message="Size of terms of service urls should be less than 3")
    @Valid
    private @Size(max=3, message="Size of terms of service urls should be less than 3") @Valid List<TermsOfServiceUrlVO> termsOfServiceUrlTexts;
    @Schema(name="copyrightEnable", description="Whether to dispaly the copyright.")
    @NotNull(message="portalCustomize parameter [copyrightEnable] should not be null")
    private @NotNull(message="portalCustomize parameter [copyrightEnable] should not be null") Boolean copyrightEnable;
    @Schema(name="copyright", description="Copyright text, should contain 0 to 200 characters.")
    @Length(max=200, message="Length of Copyright should less than 200.")
    private @Length(max=200, message="Length of Copyright should less than 200.") String copyright;
    @Schema(name="copyrightTextColor", description="Copyright text color. Hex color code such as: #ffffff.")
    @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="The value of copyrightTextColor is invalid.")
    private @Pattern(regexp="^#[0-9A-Fa-f]{6}$", message="The value of copyrightTextColor is invalid.") String copyrightTextColor;
    @Schema(name="copyrightTextOpacity", description="Copyright text opacity, should be within the range of 0\u2013100.")
    @Range(min=0L, max=100L, message="Value of copyrightTextOpacity is from 0 to 100.")
    private @Range(min=0L, max=100L, message="Value of copyrightTextOpacity is from 0 to 100.") Integer copyrightTextOpacity;
    @Schema(name="copyrightTextFontSize", description="Copyright text font size, should be within the range of 12\u201318.")
    @Range(min=12L, max=18L, message="Copyright text font size ranges from 12 to 18.")
    private @Range(min=12L, max=18L, message="Copyright text font size ranges from 12 to 18.") Integer copyrightTextFontSize;
    @Schema(name="redirectionCountDownEnable", description="Whether to show redirection countdown after authorized.")
    private Boolean redirectionCountDownEnable;
    @Schema(name="advertisement", description="Advertisement setting")
    @Valid
    private AdvertisementSettingOpenApiVO advertisement;

    @Generated
    public Integer getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Generated
    public String getBackgroundPictureId() {
        return this.backgroundPictureId;
    }

    @Generated
    public String getLogoPictureId() {
        return this.logoPictureId;
    }

    @Generated
    public Boolean getLogoDisplay() {
        return this.logoDisplay;
    }

    @Generated
    public String getInputBoxColor() {
        return this.inputBoxColor;
    }

    @Generated
    public Integer getInputBoxOpacity() {
        return this.inputBoxOpacity;
    }

    @Generated
    public String getInputTextColor() {
        return this.inputTextColor;
    }

    @Generated
    public Integer getInputTextOpacity() {
        return this.inputTextOpacity;
    }

    @Generated
    public String getButtonColor() {
        return this.buttonColor;
    }

    @Generated
    public Integer getButtonOpacity() {
        return this.buttonOpacity;
    }

    @Generated
    public String getButtonTextColor() {
        return this.buttonTextColor;
    }

    @Generated
    public Integer getButtonTextOpacity() {
        return this.buttonTextOpacity;
    }

    @Generated
    public String getButtonText() {
        return this.buttonText;
    }

    @Generated
    public String getFormAuthButtonText() {
        return this.formAuthButtonText;
    }

    @Generated
    public Boolean getWelcomeEnable() {
        return this.welcomeEnable;
    }

    @Generated
    public String getWelcomeInformation() {
        return this.welcomeInformation;
    }

    @Generated
    public String getWelcomeTextColor() {
        return this.welcomeTextColor;
    }

    @Generated
    public Integer getWelcomeTextOpacity() {
        return this.welcomeTextOpacity;
    }

    @Generated
    public Integer getWelcomeTextFontSize() {
        return this.welcomeTextFontSize;
    }

    @Generated
    public Boolean getTermsOfServiceEnable() {
        return this.termsOfServiceEnable;
    }

    @Generated
    public String getTermsOfServiceText() {
        return this.termsOfServiceText;
    }

    @Generated
    public Integer getTermsOfServiceFontSize() {
        return this.termsOfServiceFontSize;
    }

    @Generated
    public List<TermsOfServiceUrlVO> getTermsOfServiceUrlTexts() {
        return this.termsOfServiceUrlTexts;
    }

    @Generated
    public Boolean getCopyrightEnable() {
        return this.copyrightEnable;
    }

    @Generated
    public String getCopyright() {
        return this.copyright;
    }

    @Generated
    public String getCopyrightTextColor() {
        return this.copyrightTextColor;
    }

    @Generated
    public Integer getCopyrightTextOpacity() {
        return this.copyrightTextOpacity;
    }

    @Generated
    public Integer getCopyrightTextFontSize() {
        return this.copyrightTextFontSize;
    }

    @Generated
    public Boolean getRedirectionCountDownEnable() {
        return this.redirectionCountDownEnable;
    }

    @Generated
    public AdvertisementSettingOpenApiVO getAdvertisement() {
        return this.advertisement;
    }

    @Generated
    public void setDefaultLanguage(Integer defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Generated
    public void setBackgroundPictureId(String backgroundPictureId) {
        this.backgroundPictureId = backgroundPictureId;
    }

    @Generated
    public void setLogoPictureId(String logoPictureId) {
        this.logoPictureId = logoPictureId;
    }

    @Generated
    public void setLogoDisplay(Boolean logoDisplay) {
        this.logoDisplay = logoDisplay;
    }

    @Generated
    public void setInputBoxColor(String inputBoxColor) {
        this.inputBoxColor = inputBoxColor;
    }

    @Generated
    public void setInputBoxOpacity(Integer inputBoxOpacity) {
        this.inputBoxOpacity = inputBoxOpacity;
    }

    @Generated
    public void setInputTextColor(String inputTextColor) {
        this.inputTextColor = inputTextColor;
    }

    @Generated
    public void setInputTextOpacity(Integer inputTextOpacity) {
        this.inputTextOpacity = inputTextOpacity;
    }

    @Generated
    public void setButtonColor(String buttonColor) {
        this.buttonColor = buttonColor;
    }

    @Generated
    public void setButtonOpacity(Integer buttonOpacity) {
        this.buttonOpacity = buttonOpacity;
    }

    @Generated
    public void setButtonTextColor(String buttonTextColor) {
        this.buttonTextColor = buttonTextColor;
    }

    @Generated
    public void setButtonTextOpacity(Integer buttonTextOpacity) {
        this.buttonTextOpacity = buttonTextOpacity;
    }

    @Generated
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    @Generated
    public void setFormAuthButtonText(String formAuthButtonText) {
        this.formAuthButtonText = formAuthButtonText;
    }

    @Generated
    public void setWelcomeEnable(Boolean welcomeEnable) {
        this.welcomeEnable = welcomeEnable;
    }

    @Generated
    public void setWelcomeInformation(String welcomeInformation) {
        this.welcomeInformation = welcomeInformation;
    }

    @Generated
    public void setWelcomeTextColor(String welcomeTextColor) {
        this.welcomeTextColor = welcomeTextColor;
    }

    @Generated
    public void setWelcomeTextOpacity(Integer welcomeTextOpacity) {
        this.welcomeTextOpacity = welcomeTextOpacity;
    }

    @Generated
    public void setWelcomeTextFontSize(Integer welcomeTextFontSize) {
        this.welcomeTextFontSize = welcomeTextFontSize;
    }

    @Generated
    public void setTermsOfServiceEnable(Boolean termsOfServiceEnable) {
        this.termsOfServiceEnable = termsOfServiceEnable;
    }

    @Generated
    public void setTermsOfServiceText(String termsOfServiceText) {
        this.termsOfServiceText = termsOfServiceText;
    }

    @Generated
    public void setTermsOfServiceFontSize(Integer termsOfServiceFontSize) {
        this.termsOfServiceFontSize = termsOfServiceFontSize;
    }

    @Generated
    public void setTermsOfServiceUrlTexts(List<TermsOfServiceUrlVO> termsOfServiceUrlTexts) {
        this.termsOfServiceUrlTexts = termsOfServiceUrlTexts;
    }

    @Generated
    public void setCopyrightEnable(Boolean copyrightEnable) {
        this.copyrightEnable = copyrightEnable;
    }

    @Generated
    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Generated
    public void setCopyrightTextColor(String copyrightTextColor) {
        this.copyrightTextColor = copyrightTextColor;
    }

    @Generated
    public void setCopyrightTextOpacity(Integer copyrightTextOpacity) {
        this.copyrightTextOpacity = copyrightTextOpacity;
    }

    @Generated
    public void setCopyrightTextFontSize(Integer copyrightTextFontSize) {
        this.copyrightTextFontSize = copyrightTextFontSize;
    }

    @Generated
    public void setRedirectionCountDownEnable(Boolean redirectionCountDownEnable) {
        this.redirectionCountDownEnable = redirectionCountDownEnable;
    }

    @Generated
    public void setAdvertisement(AdvertisementSettingOpenApiVO advertisement) {
        this.advertisement = advertisement;
    }

    @Generated
    public String toString() {
        return "PortalCustomizeOpenApiVO(defaultLanguage=" + this.getDefaultLanguage() + ", backgroundPictureId=" + this.getBackgroundPictureId() + ", logoPictureId=" + this.getLogoPictureId() + ", logoDisplay=" + this.getLogoDisplay() + ", inputBoxColor=" + this.getInputBoxColor() + ", inputBoxOpacity=" + this.getInputBoxOpacity() + ", inputTextColor=" + this.getInputTextColor() + ", inputTextOpacity=" + this.getInputTextOpacity() + ", buttonColor=" + this.getButtonColor() + ", buttonOpacity=" + this.getButtonOpacity() + ", buttonTextColor=" + this.getButtonTextColor() + ", buttonTextOpacity=" + this.getButtonTextOpacity() + ", buttonText=" + this.getButtonText() + ", formAuthButtonText=" + this.getFormAuthButtonText() + ", welcomeEnable=" + this.getWelcomeEnable() + ", welcomeInformation=" + this.getWelcomeInformation() + ", welcomeTextColor=" + this.getWelcomeTextColor() + ", welcomeTextOpacity=" + this.getWelcomeTextOpacity() + ", welcomeTextFontSize=" + this.getWelcomeTextFontSize() + ", termsOfServiceEnable=" + this.getTermsOfServiceEnable() + ", termsOfServiceText=" + this.getTermsOfServiceText() + ", termsOfServiceFontSize=" + this.getTermsOfServiceFontSize() + ", termsOfServiceUrlTexts=" + this.getTermsOfServiceUrlTexts() + ", copyrightEnable=" + this.getCopyrightEnable() + ", copyright=" + this.getCopyright() + ", copyrightTextColor=" + this.getCopyrightTextColor() + ", copyrightTextOpacity=" + this.getCopyrightTextOpacity() + ", copyrightTextFontSize=" + this.getCopyrightTextFontSize() + ", redirectionCountDownEnable=" + this.getRedirectionCountDownEnable() + ", advertisement=" + this.getAdvertisement() + ")";
    }

    @Generated
    public PortalCustomizeOpenApiVO() {
    }

    @Generated
    public PortalCustomizeOpenApiVO(Integer defaultLanguage, String backgroundPictureId, String logoPictureId, Boolean logoDisplay, String inputBoxColor, Integer inputBoxOpacity, String inputTextColor, Integer inputTextOpacity, String buttonColor, Integer buttonOpacity, String buttonTextColor, Integer buttonTextOpacity, String buttonText, String formAuthButtonText, Boolean welcomeEnable, String welcomeInformation, String welcomeTextColor, Integer welcomeTextOpacity, Integer welcomeTextFontSize, Boolean termsOfServiceEnable, String termsOfServiceText, Integer termsOfServiceFontSize, List<TermsOfServiceUrlVO> termsOfServiceUrlTexts, Boolean copyrightEnable, String copyright, String copyrightTextColor, Integer copyrightTextOpacity, Integer copyrightTextFontSize, Boolean redirectionCountDownEnable, AdvertisementSettingOpenApiVO advertisement) {
        this.defaultLanguage = defaultLanguage;
        this.backgroundPictureId = backgroundPictureId;
        this.logoPictureId = logoPictureId;
        this.logoDisplay = logoDisplay;
        this.inputBoxColor = inputBoxColor;
        this.inputBoxOpacity = inputBoxOpacity;
        this.inputTextColor = inputTextColor;
        this.inputTextOpacity = inputTextOpacity;
        this.buttonColor = buttonColor;
        this.buttonOpacity = buttonOpacity;
        this.buttonTextColor = buttonTextColor;
        this.buttonTextOpacity = buttonTextOpacity;
        this.buttonText = buttonText;
        this.formAuthButtonText = formAuthButtonText;
        this.welcomeEnable = welcomeEnable;
        this.welcomeInformation = welcomeInformation;
        this.welcomeTextColor = welcomeTextColor;
        this.welcomeTextOpacity = welcomeTextOpacity;
        this.welcomeTextFontSize = welcomeTextFontSize;
        this.termsOfServiceEnable = termsOfServiceEnable;
        this.termsOfServiceText = termsOfServiceText;
        this.termsOfServiceFontSize = termsOfServiceFontSize;
        this.termsOfServiceUrlTexts = termsOfServiceUrlTexts;
        this.copyrightEnable = copyrightEnable;
        this.copyright = copyright;
        this.copyrightTextColor = copyrightTextColor;
        this.copyrightTextOpacity = copyrightTextOpacity;
        this.copyrightTextFontSize = copyrightTextFontSize;
        this.redirectionCountDownEnable = redirectionCountDownEnable;
        this.advertisement = advertisement;
    }
}

