/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalAuthTimeoutOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="HotspotRadiusSetting", description="Hotspot Radius Portal Setting.")
public class HotspotRadiusSettingOpenApiVO {
    @Schema(name="radiusProfileId", description="RADIUS profile ID.")
    @NotNull(message="RADIUS profile ID should not be null.")
    private @NotNull(message="RADIUS profile ID should not be null.") String radiusProfileId;
    @Schema(name="authMode", description="RADIUS auth mode, should be a value as follows: 1: PAP; 2: CHAP")
    @NotNull
    @NumberSet(value={1, 2}, message="RADIUS auth mode should be 1 or 2.")
    private Integer authMode;
    @Schema(name="nasId", description="RADIUS Attribute: NasID, should contain 1 to 64 characters.")
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [nasId] should be visible ASCII, between 1 and 64 characters")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [nasId] should be visible ASCII, between 1 and 64 characters") String nasId;
    @Schema(name="authTimeout", description="RADIUS auth timeout setting.")
    @NotNull
    @Valid
    private PortalAuthTimeoutOpenApiVO authTimeout;
    @Schema(name="disconnectReq", description="Whether to support disconnect messages.")
    private Boolean disconnectReq;
    @Schema(name="receiverPort", description="Port for listening to disconnect messages, should be within the range of 1\u201365535.")
    @Range(min=1L, max=65535L, message="HotspotRadiusSetting parameter [receiverPort] should be from 1 to 65535.")
    private @Range(min=1L, max=65535L, message="HotspotRadiusSetting parameter [receiverPort] should be from 1 to 65535.") Integer receiverPort;

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public Integer getAuthMode() {
        return this.authMode;
    }

    @Generated
    public String getNasId() {
        return this.nasId;
    }

    @Generated
    public PortalAuthTimeoutOpenApiVO getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public Boolean getDisconnectReq() {
        return this.disconnectReq;
    }

    @Generated
    public Integer getReceiverPort() {
        return this.receiverPort;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public void setAuthMode(Integer authMode) {
        this.authMode = authMode;
    }

    @Generated
    public void setNasId(String nasId) {
        this.nasId = nasId;
    }

    @Generated
    public void setAuthTimeout(PortalAuthTimeoutOpenApiVO authTimeout) {
        this.authTimeout = authTimeout;
    }

    @Generated
    public void setDisconnectReq(Boolean disconnectReq) {
        this.disconnectReq = disconnectReq;
    }

    @Generated
    public void setReceiverPort(Integer receiverPort) {
        this.receiverPort = receiverPort;
    }

    @Generated
    public String toString() {
        return "HotspotRadiusSettingOpenApiVO(radiusProfileId=" + this.getRadiusProfileId() + ", authMode=" + this.getAuthMode() + ", nasId=" + this.getNasId() + ", authTimeout=" + this.getAuthTimeout() + ", disconnectReq=" + this.getDisconnectReq() + ", receiverPort=" + this.getReceiverPort() + ")";
    }

    @Generated
    public HotspotRadiusSettingOpenApiVO() {
    }

    @Generated
    public HotspotRadiusSettingOpenApiVO(String radiusProfileId, Integer authMode, String nasId, PortalAuthTimeoutOpenApiVO authTimeout, Boolean disconnectReq, Integer receiverPort) {
        this.radiusProfileId = radiusProfileId;
        this.authMode = authMode;
        this.nasId = nasId;
        this.authTimeout = authTimeout;
        this.disconnectReq = disconnectReq;
        this.receiverPort = receiverPort;
    }
}

