/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="ExternalRadiusSetting", description="External RADIUS Portal Setting.")
public class ExternalRadiusSettingOpenApiVO {
    @Schema(name="radiusProfileId", description="RADIUS profile ID.")
    @NotNull(message="RADIUS profile ID should not be null.")
    private @NotNull(message="RADIUS profile ID should not be null.") String radiusProfileId;
    @Schema(name="authMode", description="RADIUS auth mode, should be a value as follows: 1: PAP; 2: CHAP")
    @NotNull
    @NumberSet(value={1, 2}, message="ExternalRadiusSetting parameter [authMode] should be 1 or 2")
    private Integer authMode;
    @Schema(name="nasId", description="RADIUS Attribute: NasID, should contain 1 to 64 characters.")
    @NotNull
    @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [nasId] should be visible ASCII, between 1 and 64 characters")
    private @NotNull @Pattern(regexp="^[^ ]$|^[^ ].{0,62}[^ ]$", message="Parameter [nasId] should be visible ASCII, between 1 and 64 characters") String nasId;
    @Schema(name="portalCustom", description="Portal customization, should be a value as follows: 1: Local Web Portal; 2: External Web Portal.")
    @NotNull
    @NumberSet(value={1, 2}, message="ExternalRadiusSetting parameter [portalCustom] should be 1 or 2")
    private Integer portalCustom;
    @Schema(name="externalUrlScheme", description="External URL scheme, required when [portalCustom] is 2, value could be 'http' or 'https'.")
    @Pattern(regexp="http|https", message="ExternalRadiusSetting parameter [externalUrlScheme] is supposed be \"http\" or \"https\"")
    private @Pattern(regexp="http|https", message="ExternalRadiusSetting parameter [externalUrlScheme] is supposed be \"http\" or \"https\"") String externalUrlScheme;
    @Schema(name="externalUrl", description="External URL, required when [portalCustom] is 2")
    @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$", message="ExternalRadiusSetting parameter [externalUrl] is invalid.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$", message="ExternalRadiusSetting parameter [externalUrl] is invalid.") String externalUrl;
    @Schema(name="disconnectReq", description="Whether to support disconnect messages.")
    private Boolean disconnectReq;
    @Schema(name="receiverPort", description="Port for listening to disconnect messages, should be within the range of 1\u201365535.")
    @Range(min=1L, max=65535L, message="ExternalRadiusSetting parameter [receiverPort] should be from 1 to 65535.")
    private @Range(min=1L, max=65535L, message="ExternalRadiusSetting parameter [receiverPort] should be from 1 to 65535.") Integer receiverPort;

    public void setDisconnectReq(Boolean disconnectReq) {
        if (OmadacType.s()) {
            return;
        }
        this.disconnectReq = disconnectReq;
    }

    public void setReceiverPort(Integer receiverPort) {
        if (OmadacType.s()) {
            return;
        }
        this.receiverPort = receiverPort;
    }

    @JsonIgnore
    public boolean useExternalPortal() {
        return Objects.equals(2, this.portalCustom);
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public Integer getAuthMode() {
        return this.authMode;
    }

    @Generated
    public String getNasId() {
        return this.nasId;
    }

    @Generated
    public Integer getPortalCustom() {
        return this.portalCustom;
    }

    @Generated
    public String getExternalUrlScheme() {
        return this.externalUrlScheme;
    }

    @Generated
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Generated
    public Boolean getDisconnectReq() {
        return this.disconnectReq;
    }

    @Generated
    public Integer getReceiverPort() {
        return this.receiverPort;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public void setAuthMode(Integer authMode) {
        this.authMode = authMode;
    }

    @Generated
    public void setNasId(String nasId) {
        this.nasId = nasId;
    }

    @Generated
    public void setPortalCustom(Integer portalCustom) {
        this.portalCustom = portalCustom;
    }

    @Generated
    public void setExternalUrlScheme(String externalUrlScheme) {
        this.externalUrlScheme = externalUrlScheme;
    }

    @Generated
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    @Generated
    public String toString() {
        return "ExternalRadiusSettingOpenApiVO(radiusProfileId=" + this.getRadiusProfileId() + ", authMode=" + this.getAuthMode() + ", nasId=" + this.getNasId() + ", portalCustom=" + this.getPortalCustom() + ", externalUrlScheme=" + this.getExternalUrlScheme() + ", externalUrl=" + this.getExternalUrl() + ", disconnectReq=" + this.getDisconnectReq() + ", receiverPort=" + this.getReceiverPort() + ")";
    }

    @Generated
    public ExternalRadiusSettingOpenApiVO() {
    }

    @Generated
    public ExternalRadiusSettingOpenApiVO(String radiusProfileId, Integer authMode, String nasId, Integer portalCustom, String externalUrlScheme, String externalUrl, Boolean disconnectReq, Integer receiverPort) {
        this.radiusProfileId = radiusProfileId;
        this.authMode = authMode;
        this.nasId = nasId;
        this.portalCustom = portalCustom;
        this.externalUrlScheme = externalUrlScheme;
        this.externalUrl = externalUrl;
        this.disconnectReq = disconnectReq;
        this.receiverPort = receiverPort;
    }
}

