/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.web.vo.ExternalPortalSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="ExternalServerPortalSetting", description="External Server Portal Setting.")
public class ExternalPortalSettingOpenApiVO {
    @Schema(name="hostType", description="Host type, should be a value as follows: 1: IP; 2: URL")
    @NotNull
    @NumberSet(value={1, 2}, message="ExternalServerPortalSetting parameter [hostType] is invalid.")
    private Integer hostType;
    @Schema(name="serverIp", description="Server IP, required when [hostType] is 1, pattern as \"xx.xx.xx.xx\".")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="ExternalServerPortalSetting parameter [serverIp] is invalid.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="ExternalServerPortalSetting parameter [serverIp] is invalid.") String serverIp;
    @Schema(name="serverPort", description="Server port, required when [hostType] is 1, from 1 to 65535.")
    @Range(min=1L, max=65535L, message="ExternalServerPortalSetting parameter [serverPort] is invalid.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @Range(min=1L, max=65535L, message="ExternalServerPortalSetting parameter [serverPort] is invalid.") Integer serverPort;
    @Schema(name="serverUrlScheme", description="Server url scheme, required when [hostType] is 2, value is http or https.")
    @Pattern(regexp="http|https", message="ExternalServerPortalSetting parameter [serverUrlScheme] is invalid.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @Pattern(regexp="http|https", message="ExternalServerPortalSetting parameter [serverUrlScheme] is invalid.") String serverUrlScheme;
    @Schema(name="serverUrl", description="Server url, required when [hostType] is 2.")
    @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$", message="ExternalServerPortalSetting parameter [serverUrl] is invalid.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private @Pattern(regexp="^(([-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-z]{2,63})|((?!255\\.255\\.255\\.255)((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.)){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)))((:([1-9]|[1-9]\\d|[1-9]\\d{2}|[1-9]\\d{3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)(/([-a-zA-Z0-9@:%_+.~#?&//=]*))?$", message="ExternalServerPortalSetting parameter [serverUrl] is invalid.") String serverUrl;

    public static ExternalPortalSettingOpenApiVO fromVO(ExternalPortalSettingVO vo) {
        if (vo == null) {
            return null;
        }
        ExternalPortalSettingOpenApiVO externalPortalSettingOpenApiVO = new ExternalPortalSettingOpenApiVO();
        externalPortalSettingOpenApiVO.setServerIp(vo.getServerIp());
        externalPortalSettingOpenApiVO.setServerPort(vo.getServerPort());
        externalPortalSettingOpenApiVO.setServerUrlScheme(vo.getServerUrlScheme());
        externalPortalSettingOpenApiVO.setServerUrl(vo.getServerUrl());
        return externalPortalSettingOpenApiVO;
    }

    @Generated
    public static ExternalPortalSettingOpenApiVOBuilder builder() {
        return new ExternalPortalSettingOpenApiVOBuilder();
    }

    @Generated
    public Integer getHostType() {
        return this.hostType;
    }

    @Generated
    public String getServerIp() {
        return this.serverIp;
    }

    @Generated
    public Integer getServerPort() {
        return this.serverPort;
    }

    @Generated
    public String getServerUrlScheme() {
        return this.serverUrlScheme;
    }

    @Generated
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Generated
    public void setHostType(Integer hostType) {
        this.hostType = hostType;
    }

    @Generated
    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    @Generated
    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    @Generated
    public void setServerUrlScheme(String serverUrlScheme) {
        this.serverUrlScheme = serverUrlScheme;
    }

    @Generated
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Generated
    public String toString() {
        return "ExternalPortalSettingOpenApiVO(hostType=" + this.getHostType() + ", serverIp=" + this.getServerIp() + ", serverPort=" + this.getServerPort() + ", serverUrlScheme=" + this.getServerUrlScheme() + ", serverUrl=" + this.getServerUrl() + ")";
    }

    @Generated
    public ExternalPortalSettingOpenApiVO() {
    }

    @Generated
    public ExternalPortalSettingOpenApiVO(Integer hostType, String serverIp, Integer serverPort, String serverUrlScheme, String serverUrl) {
        this.hostType = hostType;
        this.serverIp = serverIp;
        this.serverPort = serverPort;
        this.serverUrlScheme = serverUrlScheme;
        this.serverUrl = serverUrl;
    }

    @Generated
    public static class ExternalPortalSettingOpenApiVOBuilder {
        @Generated
        private Integer hostType;
        @Generated
        private String serverIp;
        @Generated
        private Integer serverPort;
        @Generated
        private String serverUrlScheme;
        @Generated
        private String serverUrl;

        @Generated
        ExternalPortalSettingOpenApiVOBuilder() {
        }

        @Generated
        public ExternalPortalSettingOpenApiVOBuilder hostType(Integer hostType) {
            this.hostType = hostType;
            return this;
        }

        @Generated
        public ExternalPortalSettingOpenApiVOBuilder serverIp(String serverIp) {
            this.serverIp = serverIp;
            return this;
        }

        @Generated
        public ExternalPortalSettingOpenApiVOBuilder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Generated
        public ExternalPortalSettingOpenApiVOBuilder serverUrlScheme(String serverUrlScheme) {
            this.serverUrlScheme = serverUrlScheme;
            return this;
        }

        @Generated
        public ExternalPortalSettingOpenApiVOBuilder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        @Generated
        public ExternalPortalSettingOpenApiVO build() {
            return new ExternalPortalSettingOpenApiVO(this.hostType, this.serverIp, this.serverPort, this.serverUrlScheme, this.serverUrl);
        }

        @Generated
        public String toString() {
            return "ExternalPortalSettingOpenApiVO.ExternalPortalSettingOpenApiVOBuilder(hostType=" + this.hostType + ", serverIp=" + this.serverIp + ", serverPort=" + this.serverPort + ", serverUrlScheme=" + this.serverUrlScheme + ", serverUrl=" + this.serverUrl + ")";
        }
    }
}

