/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo.portal;

import com.tplink.smb.omada.portal.api.web.vo.AdvertisementSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="AdvertisementSetting", description="Advertisement Setting.")
public class AdvertisementSettingOpenApiVO {
    @Schema(name="enable", description="Advertisement enable.")
    @NotNull(message="Advertisement parameter [enable] should not be null")
    private @NotNull(message="Advertisement parameter [enable] should not be null") Boolean enable;
    @Schema(name="pictureIds", description="Picture ID list, Up to 5 entries are allowed for the pictureIds list.")
    private List<String> pictureIds;
    @Schema(name="totalDuration", description="Advertisement totalDuration, should be within the range of 1\u201330, time unit is second.")
    @Range(min=1L, max=30L, message="Value of AdvertisementSetting totalDuration should be 1 to 30.")
    private @Range(min=1L, max=30L, message="Value of AdvertisementSetting totalDuration should be 1 to 30.") Integer totalDuration;
    @Schema(name="pictureInterval", description="Advertisement picture interval, should be within the range of 1\u201310, time unit is second.")
    @Range(min=1L, max=10L, message="Value of AdvertisementSetting pictureInterval should be 1 to 10.")
    private @Range(min=1L, max=10L, message="Value of AdvertisementSetting pictureInterval should be 1 to 10.") Integer pictureInterval;
    @Schema(name="skipEnable", description="Whether allow users to skip the advertisement.")
    private Boolean skipEnable;

    public static AdvertisementSettingVO defaultSetting() {
        return AdvertisementSettingVO.builder().enable(Boolean.valueOf(false)).skipEnable(Boolean.valueOf(true)).build();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<String> getPictureIds() {
        return this.pictureIds;
    }

    @Generated
    public Integer getTotalDuration() {
        return this.totalDuration;
    }

    @Generated
    public Integer getPictureInterval() {
        return this.pictureInterval;
    }

    @Generated
    public Boolean getSkipEnable() {
        return this.skipEnable;
    }

    @Generated
    private void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    private void setPictureIds(List<String> pictureIds) {
        this.pictureIds = pictureIds;
    }

    @Generated
    private void setTotalDuration(Integer totalDuration) {
        this.totalDuration = totalDuration;
    }

    @Generated
    private void setPictureInterval(Integer pictureInterval) {
        this.pictureInterval = pictureInterval;
    }

    @Generated
    private void setSkipEnable(Boolean skipEnable) {
        this.skipEnable = skipEnable;
    }

    @Generated
    public String toString() {
        return "AdvertisementSettingOpenApiVO(enable=" + this.getEnable() + ", pictureIds=" + this.getPictureIds() + ", totalDuration=" + this.getTotalDuration() + ", pictureInterval=" + this.getPictureInterval() + ", skipEnable=" + this.getSkipEnable() + ")";
    }

    @Generated
    public AdvertisementSettingOpenApiVO() {
    }

    @Generated
    public AdvertisementSettingOpenApiVO(Boolean enable, List<String> pictureIds, Integer totalDuration, Integer pictureInterval, Boolean skipEnable) {
        this.enable = enable;
        this.pictureIds = pictureIds;
        this.totalDuration = totalDuration;
        this.pictureInterval = pictureInterval;
        this.skipEnable = skipEnable;
    }
}

