/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.openapi.vo.PortalAccessControlOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.FreeAuthPolicyVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class PreAuthAccessPolicyOpenApiVO {
    @Schema(name="idInt", description="Entry ID of the policy. Except for newly added policies, this parameter should be retained")
    private Integer idInt;
    @Schema(name="type", description="Type of the policy. It should be a value as follows: 1: Destination IP Range, and parameter [ip] and [subnetMask] is needed. 2: URL, and parameter [url] is needed")
    @NumberSet(value={1, 2})
    @NotNull
    private Integer type;
    @Schema(name="ip", description="IP Address of Pre-Authentication Access")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b") String ip;
    @Schema(name="subnetMask", description="Subnet mask of Pre-Authentication Access. It should be within the range of 1-32")
    @Range(min=1L, max=32L)
    private @Range(min=1L, max=32L) Integer subnetMask;
    @Schema(name="url", description="URL of Pre-Authentication Access")
    @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}(:([0-9]|[1-9]\\d{1,3}|[1-5]\\d{4}|6[0-4]\\d{4}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,18}(:([0-9]|[1-9]\\d{1,3}|[1-5]\\d{4}|6[0-4]\\d{4}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)")
    private @Pattern(regexp="((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}(:([0-9]|[1-9]\\d{1,3}|[1-5]\\d{4}|6[0-4]\\d{4}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,18}(:([0-9]|[1-9]\\d{1,3}|[1-5]\\d{4}|6[0-4]\\d{4}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5]))?)") String url;

    @JsonIgnore
    public OperationResponse<PortalAccessControlOpenApiVO> validate() {
        if (Objects.equals(this.type, 1) && this.ip == null) {
            return new OperationResponse(b.d, "parameter [ip] should not be null.", null);
        }
        if (Objects.equals(this.type, 1) && this.subnetMask == null) {
            return new OperationResponse(b.d, "parameter [subnetMask] should not be null.", null);
        }
        if (Objects.equals(this.type, 2) && this.url == null) {
            return new OperationResponse(b.d, "parameter [url] should not be null.", null);
        }
        return OperationResponse.success(null);
    }

    @JsonIgnore
    public static PreAuthAccessPolicyOpenApiVO toOpenApiVO(FreeAuthPolicyVO vo) {
        if (vo == null) {
            return null;
        }
        Integer voType = vo.getType();
        if (voType == null || voType != 1 && voType != 2) {
            return null;
        }
        return new PreAuthAccessPolicyOpenApiVO().setIdInt(vo.getIdInt()).setType(vo.getType()).setIp(vo.getIp()).setSubnetMask(vo.getSubnetMask()).setUrl(vo.getUrl());
    }

    @JsonIgnore
    public FreeAuthPolicyVO toVO() {
        return new FreeAuthPolicyVO().setIdInt(this.idInt).setType(this.type).setIp(this.ip).setSubnetMask(this.subnetMask).setUrl(this.url);
    }

    @Generated
    public Integer getIdInt() {
        return this.idInt;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Integer getSubnetMask() {
        return this.subnetMask;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public PreAuthAccessPolicyOpenApiVO setIdInt(Integer idInt) {
        this.idInt = idInt;
        return this;
    }

    @Generated
    public PreAuthAccessPolicyOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public PreAuthAccessPolicyOpenApiVO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public PreAuthAccessPolicyOpenApiVO setSubnetMask(Integer subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    @Generated
    public PreAuthAccessPolicyOpenApiVO setUrl(String url) {
        this.url = url;
        return this;
    }

    @Generated
    public String toString() {
        return "PreAuthAccessPolicyOpenApiVO(idInt=" + this.getIdInt() + ", type=" + this.getType() + ", ip=" + this.getIp() + ", subnetMask=" + this.getSubnetMask() + ", url=" + this.getUrl() + ")";
    }

    @Generated
    public PreAuthAccessPolicyOpenApiVO(Integer idInt, Integer type, String ip, Integer subnetMask, String url) {
        this.idInt = idInt;
        this.type = type;
        this.ip = ip;
        this.subnetMask = subnetMask;
        this.url = url;
    }

    @Generated
    public PreAuthAccessPolicyOpenApiVO() {
    }
}

