/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.portal.api.openapi.vo.FreeAuthClientPolicyOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.PreAuthAccessPolicyOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.PortalAccessControlVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class PortalAccessControlOpenApiVO {
    @Schema(name="preAuthAccessEnable", description="Whether to enable Pre-Authentication Access. If parameter [preAuthAccessEnable] is true, parameter [preAuthAccessPolicies] is needed")
    @NotNull
    private Boolean preAuthAccessEnable;
    @Schema(name="preAuthAccessPolicies", description="List of Pre-Authentication Access Policy")
    @Valid
    private List<PreAuthAccessPolicyOpenApiVO> preAuthAccessPolicies;
    @Schema(name="freeAuthClientEnable", description="Whether to enable Free-Authentication Client. If parameter [freeAuthClientEnable] is true, parameter [freeAuthClientPolicies] is needed")
    @NotNull
    private Boolean freeAuthClientEnable;
    @Schema(name="freeAuthClientPolicies", description="List of Free-Authentication Client Policy")
    @Valid
    private List<FreeAuthClientPolicyOpenApiVO> freeAuthClientPolicies;

    @JsonIgnore
    public OperationResponse<PortalAccessControlOpenApiVO> validate() {
        OperationResponse<PortalAccessControlOpenApiVO> validate;
        if (Boolean.TRUE.equals(this.preAuthAccessEnable)) {
            if (this.preAuthAccessPolicies == null) {
                return new OperationResponse(b.d, "parameter [preAuthAccessPolicies] should not be null.", null);
            }
            if (!CollectionUtils.isEmpty(this.preAuthAccessPolicies)) {
                for (PreAuthAccessPolicyOpenApiVO preAuthAccessPolicyOpenApiVO : this.preAuthAccessPolicies) {
                    validate = preAuthAccessPolicyOpenApiVO.validate();
                    if (validate.success()) continue;
                    return validate;
                }
            }
        }
        if (Boolean.TRUE.equals(this.freeAuthClientEnable)) {
            if (this.freeAuthClientPolicies == null) {
                return new OperationResponse(b.d, "parameter [freeAuthClientPolicies] should not be null.", null);
            }
            if (!CollectionUtils.isEmpty(this.freeAuthClientPolicies)) {
                for (FreeAuthClientPolicyOpenApiVO freeAuthClientPolicyOpenApiVO : this.freeAuthClientPolicies) {
                    validate = freeAuthClientPolicyOpenApiVO.validate();
                    if (validate.success()) continue;
                    return validate;
                }
            }
        }
        return OperationResponse.success(null);
    }

    @JsonIgnore
    public static PortalAccessControlOpenApiVO toOpenApiVO(PortalAccessControlVO vo) {
        if (vo == null) {
            return null;
        }
        return new PortalAccessControlOpenApiVO().setPreAuthAccessEnable(vo.getPreAuthAccessEnable()).setPreAuthAccessPolicies(CollectionUtils.isEmpty((Collection)vo.getPreAuthAccessPolicies()) ? Collections.emptyList() : vo.getPreAuthAccessPolicies().stream().map(PreAuthAccessPolicyOpenApiVO::toOpenApiVO).collect(Collectors.toList())).setFreeAuthClientEnable(vo.getFreeAuthClientEnable()).setFreeAuthClientPolicies(CollectionUtils.isEmpty((Collection)vo.getFreeAuthClientPolicies()) ? Collections.emptyList() : vo.getFreeAuthClientPolicies().stream().map(FreeAuthClientPolicyOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
    }

    @JsonIgnore
    public PortalAccessControlVO toVO() {
        PortalAccessControlVO portalAccessControlVO = new PortalAccessControlVO();
        portalAccessControlVO.setPreAuthAccessEnable(this.preAuthAccessEnable);
        portalAccessControlVO.setPreAuthAccessPolicies(CollectionUtils.isEmpty(this.preAuthAccessPolicies) ? Collections.emptyList() : this.preAuthAccessPolicies.stream().map(PreAuthAccessPolicyOpenApiVO::toVO).collect(Collectors.toList()));
        portalAccessControlVO.setFreeAuthClientEnable(this.freeAuthClientEnable);
        portalAccessControlVO.setFreeAuthClientPolicies(CollectionUtils.isEmpty(this.freeAuthClientPolicies) ? Collections.emptyList() : this.freeAuthClientPolicies.stream().map(FreeAuthClientPolicyOpenApiVO::toVO).collect(Collectors.toList()));
        return portalAccessControlVO;
    }

    @Generated
    public static PortalAccessControlOpenApiVOBuilder builder() {
        return new PortalAccessControlOpenApiVOBuilder();
    }

    @Generated
    public Boolean getPreAuthAccessEnable() {
        return this.preAuthAccessEnable;
    }

    @Generated
    public List<PreAuthAccessPolicyOpenApiVO> getPreAuthAccessPolicies() {
        return this.preAuthAccessPolicies;
    }

    @Generated
    public Boolean getFreeAuthClientEnable() {
        return this.freeAuthClientEnable;
    }

    @Generated
    public List<FreeAuthClientPolicyOpenApiVO> getFreeAuthClientPolicies() {
        return this.freeAuthClientPolicies;
    }

    @Generated
    public PortalAccessControlOpenApiVO setPreAuthAccessEnable(Boolean preAuthAccessEnable) {
        this.preAuthAccessEnable = preAuthAccessEnable;
        return this;
    }

    @Generated
    public PortalAccessControlOpenApiVO setPreAuthAccessPolicies(List<PreAuthAccessPolicyOpenApiVO> preAuthAccessPolicies) {
        this.preAuthAccessPolicies = preAuthAccessPolicies;
        return this;
    }

    @Generated
    public PortalAccessControlOpenApiVO setFreeAuthClientEnable(Boolean freeAuthClientEnable) {
        this.freeAuthClientEnable = freeAuthClientEnable;
        return this;
    }

    @Generated
    public PortalAccessControlOpenApiVO setFreeAuthClientPolicies(List<FreeAuthClientPolicyOpenApiVO> freeAuthClientPolicies) {
        this.freeAuthClientPolicies = freeAuthClientPolicies;
        return this;
    }

    @Generated
    public String toString() {
        return "PortalAccessControlOpenApiVO(preAuthAccessEnable=" + this.getPreAuthAccessEnable() + ", preAuthAccessPolicies=" + this.getPreAuthAccessPolicies() + ", freeAuthClientEnable=" + this.getFreeAuthClientEnable() + ", freeAuthClientPolicies=" + this.getFreeAuthClientPolicies() + ")";
    }

    @Generated
    public PortalAccessControlOpenApiVO(Boolean preAuthAccessEnable, List<PreAuthAccessPolicyOpenApiVO> preAuthAccessPolicies, Boolean freeAuthClientEnable, List<FreeAuthClientPolicyOpenApiVO> freeAuthClientPolicies) {
        this.preAuthAccessEnable = preAuthAccessEnable;
        this.preAuthAccessPolicies = preAuthAccessPolicies;
        this.freeAuthClientEnable = freeAuthClientEnable;
        this.freeAuthClientPolicies = freeAuthClientPolicies;
    }

    @Generated
    public PortalAccessControlOpenApiVO() {
    }

    @Generated
    public static class PortalAccessControlOpenApiVOBuilder {
        @Generated
        private Boolean preAuthAccessEnable;
        @Generated
        private List<PreAuthAccessPolicyOpenApiVO> preAuthAccessPolicies;
        @Generated
        private Boolean freeAuthClientEnable;
        @Generated
        private List<FreeAuthClientPolicyOpenApiVO> freeAuthClientPolicies;

        @Generated
        PortalAccessControlOpenApiVOBuilder() {
        }

        @Generated
        public PortalAccessControlOpenApiVOBuilder preAuthAccessEnable(Boolean preAuthAccessEnable) {
            this.preAuthAccessEnable = preAuthAccessEnable;
            return this;
        }

        @Generated
        public PortalAccessControlOpenApiVOBuilder preAuthAccessPolicies(List<PreAuthAccessPolicyOpenApiVO> preAuthAccessPolicies) {
            this.preAuthAccessPolicies = preAuthAccessPolicies;
            return this;
        }

        @Generated
        public PortalAccessControlOpenApiVOBuilder freeAuthClientEnable(Boolean freeAuthClientEnable) {
            this.freeAuthClientEnable = freeAuthClientEnable;
            return this;
        }

        @Generated
        public PortalAccessControlOpenApiVOBuilder freeAuthClientPolicies(List<FreeAuthClientPolicyOpenApiVO> freeAuthClientPolicies) {
            this.freeAuthClientPolicies = freeAuthClientPolicies;
            return this;
        }

        @Generated
        public PortalAccessControlOpenApiVO build() {
            return new PortalAccessControlOpenApiVO(this.preAuthAccessEnable, this.preAuthAccessPolicies, this.freeAuthClientEnable, this.freeAuthClientPolicies);
        }

        @Generated
        public String toString() {
            return "PortalAccessControlOpenApiVO.PortalAccessControlOpenApiVOBuilder(preAuthAccessEnable=" + this.preAuthAccessEnable + ", preAuthAccessPolicies=" + this.preAuthAccessPolicies + ", freeAuthClientEnable=" + this.freeAuthClientEnable + ", freeAuthClientPolicies=" + this.freeAuthClientPolicies + ")";
        }
    }
}

