/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.portal.api.openapi.vo.DailyAuthTimeOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.RateLimitOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class ModifyLocalUserOpenApiVO {
    @Schema(name="password", description="Password should contain 1 to 128 characters.")
    @NotNull(message="Parameter [password] is null")
    @Length(min=1, max=128, message="Length of PassWord is from 1 to 128.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="Parameter [password] is null") @Length(min=1, max=128, message="Length of PassWord is from 1 to 128.") String password;
    @Schema(name="enable", description="Whether to enable.")
    @NotNull(message="Parameter [enable] is null")
    private @NotNull(message="Parameter [enable] is null") Boolean enable;
    @Schema(name="expirationTime", description="Expiration timestamp. Unit:ms.")
    @NotNull(message="Parameter [expirationTime] is null")
    private @NotNull(message="Parameter [expirationTime] is null") Long expirationTime;
    @Schema(name="bindingType", description="MAC binding type should be a value as follows: 0: no binding; 1: static binding; 2: dynamic binding.")
    @NotNull(message="Parameter [bindingType] is null")
    private @NotNull(message="Parameter [bindingType] is null") Integer bindingType;
    @Schema(name="macAddress", description="Mac address,the value is only available when the macType is static binding or dynamic binding.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String macAddress;
    @Schema(name="maxUsers", description="The maximum number of users online at the same time when the MAC binding type is No Binding. It cannot be modified after initialization. MaxUsers should be within the range of 1\u20132048.")
    @NotNull(message="Parameter [maxUsers] is null")
    @Range(min=1L, max=2048L, message="Value of Maximum Users is from 1 to 2048.")
    private @NotNull(message="Parameter [maxUsers] is null") @Range(min=1L, max=2048L, message="Value of Maximum Users is from 1 to 2048.") Integer maxUsers;
    @Schema(name="name", description="Name should contain 1 to 128 characters, with no spaces at the beginning and end, and spaces in the middle")
    @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$") String name;
    @Schema(name="phone", description="Phone number should contain 1 to 20 characters.")
    @Length(min=0, max=20, message="Length of Telephone is from 1 to 20.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Length(min=0, max=20, message="Length of Telephone is from 1 to 20.") String phone;
    @Schema(name="rateLimit", description="When configuring rate limit, can only configure one of rateLimitProfileId or customRateLimit.")
    @NotNull(message="Parameter [rateLimit] is null")
    @Valid
    private @NotNull(message="Parameter [rateLimit] is null") @Valid RateLimitOpenApiVO rateLimit;
    @Schema(name="trafficLimitEnable", description="Whether to enable traffic limit.")
    @NotNull(message="Parameter [trafficLimitEnable] is null")
    private @NotNull(message="Parameter [trafficLimitEnable] is null") Boolean trafficLimitEnable;
    @Schema(name="trafficLimit", description="Traffic limit in MB. It should be within the range of 1\u201310485760.")
    @Range(min=0L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.")
    private @Range(min=0L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.") Long trafficLimit;
    @Schema(name="trafficLimitFrequency", description="Frequency of traffic limit should be a value as follows: 0: total; 1: daily; 2: weekly; 3: monthly.")
    @Range(min=0L, max=3L, message="TrafficLimitFrequency should be a value as follows: 0, 1, 2, 3.")
    private @Range(min=0L, max=3L, message="TrafficLimitFrequency should be a value as follows: 0, 1, 2, 3.") Integer trafficLimitFrequency;
    @Schema(name="portals", description="Bound portal ID list. Portal can be created using 'Add portal' interface, and portal ID can be obtained from 'Get portal list in a site' interface")
    @NotNull(message="Parameter [portals] is null")
    private @NotNull(message="Parameter [portals] is null") List<String> portals;
    @Schema(name="logout", description="local user logout. enable local user logout")
    private Boolean logout;
    @Schema(name="applyToAllPortals", description="Is the localuser effective for all portals, including all newly created portals")
    private Boolean applyToAllPortals;
    @Schema(name="dailyLimitEnable", description="Whether to enable localuser daily time limit")
    private Boolean dailyLimitEnable;
    @Valid
    @Schema(name="dailyLimit", description="Daily time limit setting, required when parameter [dailyLimitEnable] is true")
    private DailyAuthTimeOpenApiVO dailyLimit;

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Integer getBindingType() {
        return this.bindingType;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public Integer getMaxUsers() {
        return this.maxUsers;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public RateLimitOpenApiVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public List<String> getPortals() {
        return this.portals;
    }

    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public Boolean getApplyToAllPortals() {
        return this.applyToAllPortals;
    }

    @Generated
    public Boolean getDailyLimitEnable() {
        return this.dailyLimitEnable;
    }

    @Generated
    public DailyAuthTimeOpenApiVO getDailyLimit() {
        return this.dailyLimit;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Generated
    public void setBindingType(Integer bindingType) {
        this.bindingType = bindingType;
    }

    @Generated
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    @Generated
    public void setMaxUsers(Integer maxUsers) {
        this.maxUsers = maxUsers;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setRateLimit(RateLimitOpenApiVO rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Generated
    public void setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
    }

    @Generated
    public void setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
    }

    @Generated
    public void setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
    }

    @Generated
    public void setPortals(List<String> portals) {
        this.portals = portals;
    }

    @Generated
    public void setLogout(Boolean logout) {
        this.logout = logout;
    }

    @Generated
    public void setApplyToAllPortals(Boolean applyToAllPortals) {
        this.applyToAllPortals = applyToAllPortals;
    }

    @Generated
    public void setDailyLimitEnable(Boolean dailyLimitEnable) {
        this.dailyLimitEnable = dailyLimitEnable;
    }

    @Generated
    public void setDailyLimit(DailyAuthTimeOpenApiVO dailyLimit) {
        this.dailyLimit = dailyLimit;
    }

    @Generated
    public String toString() {
        return "ModifyLocalUserOpenApiVO(password=" + this.getPassword() + ", enable=" + this.getEnable() + ", expirationTime=" + this.getExpirationTime() + ", bindingType=" + this.getBindingType() + ", macAddress=" + this.getMacAddress() + ", maxUsers=" + this.getMaxUsers() + ", name=" + this.getName() + ", phone=" + this.getPhone() + ", rateLimit=" + this.getRateLimit() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", portals=" + this.getPortals() + ", logout=" + this.getLogout() + ", applyToAllPortals=" + this.getApplyToAllPortals() + ", dailyLimitEnable=" + this.getDailyLimitEnable() + ", dailyLimit=" + this.getDailyLimit() + ")";
    }
}

