/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.portal.api.openapi.vo.AuthTimeOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.RateLimitOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class LocalUserOpenApiVO {
    @Schema(name="id", description="Local user ID")
    private String id;
    @Schema(name="userName", description="User name should contain 1 to 128 characters")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    @Length(min=1, max=128, message="Length of UserName is from 1 to 128.")
    private @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") @Length(min=1, max=128, message="Length of UserName is from 1 to 128.") String userName;
    @Schema(name="password", description="Password should contain 1 to 128 characters")
    @Length(min=1, max=128, message="Length of PassWord is from 1 to 128.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Length(min=1, max=128, message="Length of PassWord is from 1 to 128.") String password;
    @Schema(name="enable", description="Local user enable status")
    private Boolean enable;
    @Schema(name="expirationTime", description="Expiration time, unit: ms")
    private Long expirationTime;
    @Schema(name="bindingType", description="MAC binding type should be a value as follows: 0: no binding; 1: static binding; 2: dynamic binding.")
    private Integer bindingType;
    @Schema(name="macAddress", description="Mac address,the value is only available when the macType is static binding or dynamic binding.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String macAddress;
    @Schema(name="maxUsers", description="The maximum number of users online at the same time when the MAC binding type is No Binding. It cannot be modified after initialization. Value of Maximum Users should be within the range of 1-2048.")
    @Range(min=1L, max=2048L, message="Value of Maximum Users is from 1 to 2048.")
    private @Range(min=1L, max=2048L, message="Value of Maximum Users is from 1 to 2048.") Integer maxUsers;
    @Schema(name="name", description="Name")
    @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$") String name;
    @Schema(name="phone", description="Phone number should contain 1 to 20 characters.")
    @Length(min=0, max=20, message="Length of Telephone is from 1 to 20.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Length(min=0, max=20, message="Length of Telephone is from 1 to 20.") String phone;
    @Schema(name="rateLimit", description="Rate limit configuring.")
    private RateLimitOpenApiVO rateLimit;
    @Schema(name="trafficLimitEnable", description="Whether to enable traffic limit.")
    private Boolean trafficLimitEnable;
    @Schema(name="trafficLimit", description="Traffic limit in MB. The value should be within the range of 1\u201310485760.")
    @Range(min=0L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.")
    private @Range(min=0L, max=0xA00000L, message="Value of limit is from 1 to 10485760 MB.") Long trafficLimit;
    @Schema(name="trafficLeft", description="Is there any remaining traffic.")
    private Boolean trafficLeft;
    @Schema(name="trafficUsed", description="Used traffic(MB).")
    private Long trafficUsed;
    @Schema(name="trafficLimitFrequency", description="Frequency of traffic limit should be a value as follows: 0: total; 1: daily; 2: weekly; 3: monthly.")
    private Integer trafficLimitFrequency;
    @Schema(name="used", description="Used quantity.")
    private Integer used;
    @Schema(name="overtime", description="Whether the current time has exceeded the expirationTime")
    private Boolean overtime = false;
    @Schema(name="portals", description="Bound portal IDs.")
    private List<String> portals;
    @Schema(name="portals", description="Bound portal names.")
    private List<String> portalNames;
    @Schema(name="logout", description="local user logout. enable local user logout.")
    private Boolean logout;
    @Schema(name="applyToAllPortals", description="Is the localuser effective for all portals, including all newly created portals")
    private Boolean applyToAllPortals;
    @Schema(name="dailyLimitEnable", description="Whether to enable localuser daily time limit")
    private Boolean dailyLimitEnable;
    @Valid
    @Schema(name="dailyLimit", description="Daily time limit setting, required when parameter [dailyLimitEnable] is true")
    private AuthTimeOpenApiVO dailyLimit;
    @Schema(name="dailyLimitMs", description="Daily time limit, unit is ms, required when parameter [dailyLimitEnable] is true")
    private Long dailyLimitMs;
    @Nullable
    @Schema(name="dailyLimitLeftMs", description="Daily time left, unit is ms, required when parameter [dailyLimitEnable] is true")
    private Long dailyLimitLeftMs;

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Long getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public Integer getBindingType() {
        return this.bindingType;
    }

    @Generated
    public String getMacAddress() {
        return this.macAddress;
    }

    @Generated
    public Integer getMaxUsers() {
        return this.maxUsers;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public RateLimitOpenApiVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public Boolean getTrafficLimitEnable() {
        return this.trafficLimitEnable;
    }

    @Generated
    public Long getTrafficLimit() {
        return this.trafficLimit;
    }

    @Generated
    public Boolean getTrafficLeft() {
        return this.trafficLeft;
    }

    @Generated
    public Long getTrafficUsed() {
        return this.trafficUsed;
    }

    @Generated
    public Integer getTrafficLimitFrequency() {
        return this.trafficLimitFrequency;
    }

    @Generated
    public Integer getUsed() {
        return this.used;
    }

    @Generated
    public Boolean getOvertime() {
        return this.overtime;
    }

    @Generated
    public List<String> getPortals() {
        return this.portals;
    }

    @Generated
    public List<String> getPortalNames() {
        return this.portalNames;
    }

    @Generated
    public Boolean getLogout() {
        return this.logout;
    }

    @Generated
    public Boolean getApplyToAllPortals() {
        return this.applyToAllPortals;
    }

    @Generated
    public Boolean getDailyLimitEnable() {
        return this.dailyLimitEnable;
    }

    @Generated
    public AuthTimeOpenApiVO getDailyLimit() {
        return this.dailyLimit;
    }

    @Generated
    public Long getDailyLimitMs() {
        return this.dailyLimitMs;
    }

    @Nullable
    @Generated
    public Long getDailyLimitLeftMs() {
        return this.dailyLimitLeftMs;
    }

    @Generated
    public LocalUserOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setExpirationTime(Long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setBindingType(Integer bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setMaxUsers(Integer maxUsers) {
        this.maxUsers = maxUsers;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setRateLimit(RateLimitOpenApiVO rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setTrafficLimitEnable(Boolean trafficLimitEnable) {
        this.trafficLimitEnable = trafficLimitEnable;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setTrafficLimit(Long trafficLimit) {
        this.trafficLimit = trafficLimit;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setTrafficLeft(Boolean trafficLeft) {
        this.trafficLeft = trafficLeft;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setTrafficUsed(Long trafficUsed) {
        this.trafficUsed = trafficUsed;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setTrafficLimitFrequency(Integer trafficLimitFrequency) {
        this.trafficLimitFrequency = trafficLimitFrequency;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setUsed(Integer used) {
        this.used = used;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setOvertime(Boolean overtime) {
        this.overtime = overtime;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setPortals(List<String> portals) {
        this.portals = portals;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setPortalNames(List<String> portalNames) {
        this.portalNames = portalNames;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setLogout(Boolean logout) {
        this.logout = logout;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setApplyToAllPortals(Boolean applyToAllPortals) {
        this.applyToAllPortals = applyToAllPortals;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setDailyLimitEnable(Boolean dailyLimitEnable) {
        this.dailyLimitEnable = dailyLimitEnable;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setDailyLimit(AuthTimeOpenApiVO dailyLimit) {
        this.dailyLimit = dailyLimit;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setDailyLimitMs(Long dailyLimitMs) {
        this.dailyLimitMs = dailyLimitMs;
        return this;
    }

    @Generated
    public LocalUserOpenApiVO setDailyLimitLeftMs(@Nullable Long dailyLimitLeftMs) {
        this.dailyLimitLeftMs = dailyLimitLeftMs;
        return this;
    }

    @Generated
    public String toString() {
        return "LocalUserOpenApiVO(id=" + this.getId() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", enable=" + this.getEnable() + ", expirationTime=" + this.getExpirationTime() + ", bindingType=" + this.getBindingType() + ", macAddress=" + this.getMacAddress() + ", maxUsers=" + this.getMaxUsers() + ", name=" + this.getName() + ", phone=" + this.getPhone() + ", rateLimit=" + this.getRateLimit() + ", trafficLimitEnable=" + this.getTrafficLimitEnable() + ", trafficLimit=" + this.getTrafficLimit() + ", trafficLeft=" + this.getTrafficLeft() + ", trafficUsed=" + this.getTrafficUsed() + ", trafficLimitFrequency=" + this.getTrafficLimitFrequency() + ", used=" + this.getUsed() + ", overtime=" + this.getOvertime() + ", portals=" + this.getPortals() + ", portalNames=" + this.getPortalNames() + ", logout=" + this.getLogout() + ", applyToAllPortals=" + this.getApplyToAllPortals() + ", dailyLimitEnable=" + this.getDailyLimitEnable() + ", dailyLimit=" + this.getDailyLimit() + ", dailyLimitMs=" + this.getDailyLimitMs() + ", dailyLimitLeftMs=" + this.getDailyLimitLeftMs() + ")";
    }

    @Generated
    public LocalUserOpenApiVO() {
    }

    @Generated
    public LocalUserOpenApiVO(String id, String userName, String password, Boolean enable, Long expirationTime, Integer bindingType, String macAddress, Integer maxUsers, String name, String phone, RateLimitOpenApiVO rateLimit, Boolean trafficLimitEnable, Long trafficLimit, Boolean trafficLeft, Long trafficUsed, Integer trafficLimitFrequency, Integer used, Boolean overtime, List<String> portals, List<String> portalNames, Boolean logout, Boolean applyToAllPortals, Boolean dailyLimitEnable, AuthTimeOpenApiVO dailyLimit, Long dailyLimitMs, @Nullable Long dailyLimitLeftMs) {
        this.id = id;
        this.userName = userName;
        this.password = password;
        this.enable = enable;
        this.expirationTime = expirationTime;
        this.bindingType = bindingType;
        this.macAddress = macAddress;
        this.maxUsers = maxUsers;
        this.name = name;
        this.phone = phone;
        this.rateLimit = rateLimit;
        this.trafficLimitEnable = trafficLimitEnable;
        this.trafficLimit = trafficLimit;
        this.trafficLeft = trafficLeft;
        this.trafficUsed = trafficUsed;
        this.trafficLimitFrequency = trafficLimitFrequency;
        this.used = used;
        this.overtime = overtime;
        this.portals = portals;
        this.portalNames = portalNames;
        this.logout = logout;
        this.applyToAllPortals = applyToAllPortals;
        this.dailyLimitEnable = dailyLimitEnable;
        this.dailyLimit = dailyLimit;
        this.dailyLimitMs = dailyLimitMs;
        this.dailyLimitLeftMs = dailyLimitLeftMs;
    }
}

