/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.openapi.vo.PortalAccessControlOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.FreeAuthPolicyVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;

public class FreeAuthClientPolicyOpenApiVO {
    @Schema(name="idInt", description="Entry ID of the policy. Except for newly added policies, this parameter should be retained")
    private Integer idInt;
    @Schema(name="type", description="Type of the policy. It should be a value as follows: 3: Free auth client IP, and parameter [clientIp] is needed. 4: Free auth client MAC, and parameter [clientMac] is needed")
    @NumberSet(value={3, 4})
    @NotNull
    private Integer type;
    @Schema(name="clientIp", description="Free auth client IP Address")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b") String clientIp;
    @Schema(name="clientMac", description="Free auth client MAC Address, for example: AA-AA-AA-AA-AA-AA")
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}") String clientMac;

    @JsonIgnore
    public OperationResponse<PortalAccessControlOpenApiVO> validate() {
        if (Objects.equals(this.type, 3) && this.clientIp == null) {
            return new OperationResponse(b.d, "parameter [clientIp] should not be null.", null);
        }
        if (Objects.equals(this.type, 4) && this.clientMac == null) {
            return new OperationResponse(b.d, "parameter [clientMac] should not be null.", null);
        }
        return OperationResponse.success(null);
    }

    @JsonIgnore
    public static FreeAuthClientPolicyOpenApiVO toOpenApiVO(FreeAuthPolicyVO vo) {
        if (vo == null) {
            return null;
        }
        Integer voType = vo.getType();
        if (voType == null || voType != 3 && voType != 4) {
            return null;
        }
        FreeAuthClientPolicyOpenApiVO freeAuthClientPolicyOpenApiVO = new FreeAuthClientPolicyOpenApiVO();
        freeAuthClientPolicyOpenApiVO.setIdInt(vo.getIdInt());
        freeAuthClientPolicyOpenApiVO.setType(vo.getType());
        freeAuthClientPolicyOpenApiVO.setClientIp(vo.getClientIp());
        freeAuthClientPolicyOpenApiVO.setClientMac(vo.getClientMac());
        return freeAuthClientPolicyOpenApiVO;
    }

    @JsonIgnore
    public FreeAuthPolicyVO toVO() {
        FreeAuthPolicyVO freeAuthPolicyVO = new FreeAuthPolicyVO();
        freeAuthPolicyVO.setIdInt(this.idInt);
        freeAuthPolicyVO.setType(this.type);
        freeAuthPolicyVO.setClientIp(this.clientIp);
        freeAuthPolicyVO.setClientMac(this.clientMac);
        return freeAuthPolicyVO;
    }

    @Generated
    public static FreeAuthClientPolicyOpenApiVOBuilder builder() {
        return new FreeAuthClientPolicyOpenApiVOBuilder();
    }

    @Generated
    public Integer getIdInt() {
        return this.idInt;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getClientIp() {
        return this.clientIp;
    }

    @Generated
    public String getClientMac() {
        return this.clientMac;
    }

    @Generated
    public FreeAuthClientPolicyOpenApiVO setIdInt(Integer idInt) {
        this.idInt = idInt;
        return this;
    }

    @Generated
    public FreeAuthClientPolicyOpenApiVO setType(Integer type) {
        this.type = type;
        return this;
    }

    @Generated
    public FreeAuthClientPolicyOpenApiVO setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    @Generated
    public FreeAuthClientPolicyOpenApiVO setClientMac(String clientMac) {
        this.clientMac = clientMac;
        return this;
    }

    @Generated
    public String toString() {
        return "FreeAuthClientPolicyOpenApiVO(idInt=" + this.getIdInt() + ", type=" + this.getType() + ", clientIp=" + this.getClientIp() + ", clientMac=" + this.getClientMac() + ")";
    }

    @Generated
    public FreeAuthClientPolicyOpenApiVO(Integer idInt, Integer type, String clientIp, String clientMac) {
        this.idInt = idInt;
        this.type = type;
        this.clientIp = clientIp;
        this.clientMac = clientMac;
    }

    @Generated
    public FreeAuthClientPolicyOpenApiVO() {
    }

    @Generated
    public static class FreeAuthClientPolicyOpenApiVOBuilder {
        @Generated
        private Integer idInt;
        @Generated
        private Integer type;
        @Generated
        private String clientIp;
        @Generated
        private String clientMac;

        @Generated
        FreeAuthClientPolicyOpenApiVOBuilder() {
        }

        @Generated
        public FreeAuthClientPolicyOpenApiVOBuilder idInt(Integer idInt) {
            this.idInt = idInt;
            return this;
        }

        @Generated
        public FreeAuthClientPolicyOpenApiVOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        @Generated
        public FreeAuthClientPolicyOpenApiVOBuilder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        @Generated
        public FreeAuthClientPolicyOpenApiVOBuilder clientMac(String clientMac) {
            this.clientMac = clientMac;
            return this;
        }

        @Generated
        public FreeAuthClientPolicyOpenApiVO build() {
            return new FreeAuthClientPolicyOpenApiVO(this.idInt, this.type, this.clientIp, this.clientMac);
        }

        @Generated
        public String toString() {
            return "FreeAuthClientPolicyOpenApiVO.FreeAuthClientPolicyOpenApiVOBuilder(idInt=" + this.idInt + ", type=" + this.type + ", clientIp=" + this.clientIp + ", clientMac=" + this.clientMac + ")";
        }
    }
}

