/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.portal.api.web.vo.FormAuthCardVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class FormAuthCardOpenApiVO {
    @Schema(name="type", description="Card type should be a value as follows: 0: single choice (single choice); 1: multiple choice (multiple choice); 2: ComboBox (drop-down menu); 3: input (input box); 4: score (score); 5: prompt frame")
    @NotNull(message="Parameter [type] is null")
    @Range(min=0L, max=5L)
    private @NotNull(message="Parameter [type] is null") @Range(min=0L, max=5L) Integer type;
    @Schema(name="required", description="Indicates whether the card is required (cardType is 5, meaningless in the prompt box).")
    @NotNull(message="Parameter [required] is null")
    private @NotNull(message="Parameter [required] is null") Boolean required;
    @Schema(name="title", description="Title should contain 1-2000 characters")
    @NotNull(message="Parameter [title] is null")
    @Length(max=2000, message="Title should contain 1-2000 characters.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="Parameter [title] is null") @Length(max=2000, message="Title should contain 1-2000 characters.") String title;
    @Schema(name="choices", description="Drop-down menu or list of options for multiple-choice questions (exist if and only if cardType is 0, 1, 2), excluding questions with other options. Choices should contain 1-2000 characters")
    @NotNull(message="Parameter [choices] is null")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="Parameter [choices] is null") List<String> choices;
    @Schema(name="others", description="The question of the other options. Exists if and only if type is 0, 1. Others should contain 1-2000 characters")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Length(max=2000, message="Others should contain 1-2000 characters.")
    private @Length(max=2000, message="Others should contain 1-2000 characters.") String others;
    @Schema(name="scoreNotes", description="The prompt text corresponding to different scores of the scoring card. Exists when the cardType is 4 and needs to be transmitted in order. The subscript 0 corresponds to the score 1.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private List<String> scoreNotes;

    public FormAuthCardVO toVO() {
        return new FormAuthCardVO().setType(this.type).setRequired(this.required).setTitle(this.title).setChoices(this.choices).setOthers(this.others).setScoreNotes(this.scoreNotes);
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Boolean getRequired() {
        return this.required;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public List<String> getChoices() {
        return this.choices;
    }

    @Generated
    public String getOthers() {
        return this.others;
    }

    @Generated
    public List<String> getScoreNotes() {
        return this.scoreNotes;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setChoices(List<String> choices) {
        this.choices = choices;
    }

    @Generated
    public void setOthers(String others) {
        this.others = others;
    }

    @Generated
    public void setScoreNotes(List<String> scoreNotes) {
        this.scoreNotes = scoreNotes;
    }

    @Generated
    public String toString() {
        return "FormAuthCardOpenApiVO(type=" + this.getType() + ", required=" + this.getRequired() + ", title=" + this.getTitle() + ", choices=" + this.getChoices() + ", others=" + this.getOthers() + ", scoreNotes=" + this.getScoreNotes() + ")";
    }
}

