/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.common.a;
import com.tplink.smb.omada.portal.api.openapi.vo.AuthTimeOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.AuthTimeoutVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class DailyAuthTimeOpenApiVO {
    @Schema(name="authTimeout", description="Validity period should be a value as follows: 0: Custom; 1: 30 Minutes; 2: 1 Hour; 3: 2 Hours; 4: 4 Hours; 5: 8 Hours;")
    @NotNull(message="AuthTimeout [authTimeout] should not be null")
    @NumberSet(value={0, 1, 2, 3, 4, 5})
    private @NotNull(message="AuthTimeout [authTimeout] should not be null") Integer authTimeout;
    @Schema(name="customTimeout", description="Custom timeout should be within the range of 1 ~ 1,440 minutes(when parameter[customTimeoutUnit] value is 1), or 1 ~ 24 hours(when parameter[customTimeoutUnit] value is 2).")
    @Range(min=1L, max=1440L)
    private @Range(min=1L, max=1440L) Integer customTimeout;
    @Schema(name="customTimeoutUnit", description="Custom timeout unit should be a value as follows: 1: min; 2: hour.")
    @NumberSet(value={1, 2})
    private Integer customTimeoutUnit;

    public static AuthTimeOpenApiVO defaultAuthTimeoutVO() {
        return new AuthTimeOpenApiVO().setAuthTimeout(a.f.i).setCustomTimeout(8).setCustomTimeoutUnit(2);
    }

    public OperationResponse validate() {
        if (this.authTimeout != 0) {
            return OperationResponse.ok();
        }
        if (this.customTimeout == null || this.customTimeoutUnit == null) {
            return new OperationResponse(b.d, "Parameter customTimeout and customTimeoutUnit should not be null when authTimeout is 1", null);
        }
        if (this.customTimeoutUnit == 1 && this.customTimeout > 1440) {
            return new OperationResponse(b.d, (Object)"Parameter customTimeout should be within the range of 1-1440 when customTimeoutUnit is 1");
        }
        if (this.customTimeoutUnit == 2 && this.customTimeout > 24) {
            return new OperationResponse(b.d, (Object)"Parameter customTimeout should be within the range of 1-24 when customTimeoutUnit is 2");
        }
        return OperationResponse.ok();
    }

    public static DailyAuthTimeOpenApiVO fromVO(AuthTimeoutVO vo) {
        if (vo == null) {
            return null;
        }
        DailyAuthTimeOpenApiVO dailyAuthTimeOpenApiVO = new DailyAuthTimeOpenApiVO();
        dailyAuthTimeOpenApiVO.setAuthTimeout(vo.getAuthTimeout());
        dailyAuthTimeOpenApiVO.setCustomTimeout(vo.getCustomTimeout());
        dailyAuthTimeOpenApiVO.setCustomTimeoutUnit(vo.getCustomTimeoutUnit());
        return dailyAuthTimeOpenApiVO;
    }

    @Generated
    public Integer getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public Integer getCustomTimeout() {
        return this.customTimeout;
    }

    @Generated
    public Integer getCustomTimeoutUnit() {
        return this.customTimeoutUnit;
    }

    @Generated
    public DailyAuthTimeOpenApiVO setAuthTimeout(Integer authTimeout) {
        this.authTimeout = authTimeout;
        return this;
    }

    @Generated
    public DailyAuthTimeOpenApiVO setCustomTimeout(Integer customTimeout) {
        this.customTimeout = customTimeout;
        return this;
    }

    @Generated
    public DailyAuthTimeOpenApiVO setCustomTimeoutUnit(Integer customTimeoutUnit) {
        this.customTimeoutUnit = customTimeoutUnit;
        return this;
    }

    @Generated
    public String toString() {
        return "DailyAuthTimeOpenApiVO(authTimeout=" + this.getAuthTimeout() + ", customTimeout=" + this.getCustomTimeout() + ", customTimeoutUnit=" + this.getCustomTimeoutUnit() + ")";
    }

    @Generated
    public DailyAuthTimeOpenApiVO() {
    }

    @Generated
    public DailyAuthTimeOpenApiVO(Integer authTimeout, Integer customTimeout, Integer customTimeoutUnit) {
        this.authTimeout = authTimeout;
        this.customTimeout = customTimeout;
        this.customTimeoutUnit = customTimeoutUnit;
    }
}

