/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.portal.api.openapi.vo;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.portal.api.common.a;
import com.tplink.smb.omada.portal.api.web.vo.AuthTimeoutVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class AuthTimeOpenApiVO {
    @Schema(name="authTimeout", description="Validity period should be a value as follows: 0: Custom; 1: 30 Minutes; 2: 1 Hour; 3: 2 Hours; 4: 4 Hours; 5: 8 Hours; 6: 1 Day; 7: 7 Days integer.")
    @NotNull(message="AuthTimeout [authTimeout] should not be null")
    @NumberSet(value={0, 1, 2, 3, 4, 5, 6, 7})
    private @NotNull(message="AuthTimeout [authTimeout] should not be null") Integer authTimeout;
    @Schema(name="customTimeout", description="Custom timeout should be within the range of 1 ~ 1,000,000 minutes(when parameter[customTimeoutUnit] value is 1), or 1 ~ 10,000 hours(when parameter[customTimeoutUnit] value is 2), or 1 ~ 1,000 days(when parameter[customTimeoutUnit] value is 3).")
    @Range(min=1L, max=1000000L)
    private @Range(min=1L, max=1000000L) Integer customTimeout;
    @Schema(name="customTimeoutUnit", description="Custom timeout unit should be a value as follows: 1: min; 2: hour; 3: day.")
    @NumberSet(value={1, 2, 3})
    private Integer customTimeoutUnit;

    public static AuthTimeOpenApiVO defaultAuthTimeoutVO() {
        return new AuthTimeOpenApiVO().setAuthTimeout(a.f.i).setCustomTimeout(8).setCustomTimeoutUnit(2);
    }

    public boolean validate() {
        if (this.authTimeout != 0) {
            return true;
        }
        if (this.customTimeout == null || this.customTimeoutUnit == null) {
            return false;
        }
        if (this.customTimeoutUnit == 3 && this.customTimeout > 1000) {
            return false;
        }
        return this.customTimeoutUnit != 2 || this.customTimeout <= 10000;
    }

    public static AuthTimeOpenApiVO fromVO(AuthTimeoutVO vo) {
        if (vo == null) {
            return null;
        }
        AuthTimeOpenApiVO authTimeOpenApiVO = new AuthTimeOpenApiVO();
        authTimeOpenApiVO.setAuthTimeout(vo.getAuthTimeout());
        authTimeOpenApiVO.setCustomTimeout(vo.getCustomTimeout());
        authTimeOpenApiVO.setCustomTimeoutUnit(vo.getCustomTimeoutUnit());
        return authTimeOpenApiVO;
    }

    @Generated
    public Integer getAuthTimeout() {
        return this.authTimeout;
    }

    @Generated
    public Integer getCustomTimeout() {
        return this.customTimeout;
    }

    @Generated
    public Integer getCustomTimeoutUnit() {
        return this.customTimeoutUnit;
    }

    @Generated
    public AuthTimeOpenApiVO setAuthTimeout(Integer authTimeout) {
        this.authTimeout = authTimeout;
        return this;
    }

    @Generated
    public AuthTimeOpenApiVO setCustomTimeout(Integer customTimeout) {
        this.customTimeout = customTimeout;
        return this;
    }

    @Generated
    public AuthTimeOpenApiVO setCustomTimeoutUnit(Integer customTimeoutUnit) {
        this.customTimeoutUnit = customTimeoutUnit;
        return this;
    }

    @Generated
    public String toString() {
        return "AuthTimeOpenApiVO(authTimeout=" + this.getAuthTimeout() + ", customTimeout=" + this.getCustomTimeout() + ", customTimeoutUnit=" + this.getCustomTimeoutUnit() + ")";
    }

    @Generated
    public AuthTimeOpenApiVO() {
    }

    @Generated
    public AuthTimeOpenApiVO(Integer authTimeout, Integer customTimeout, Integer customTimeoutUnit) {
        this.authTimeout = authTimeout;
        this.customTimeout = customTimeout;
        this.customTimeoutUnit = customTimeoutUnit;
    }
}

