/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.api.openapi.vo.topology;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.client.api.openapi.vo.topology.ApInfoOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.topology.GatewayInfoOpenApiVO;
import com.tplink.smb.omada.client.api.openapi.vo.topology.SwitchInfoOpenApiVO;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.DeviceInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

@Schema(name="Device Node Info")
public class DeviceNodeOpenApiVO {
    @Schema(name="deviceType", description="Device type, 0: AP; 1: Switch; 2: Gateway.")
    private Integer deviceType;
    @Schema(name="name", description="Device name")
    private String name;
    @Schema(name="mac", description="Device MAC")
    @a
    private String mac;
    @Schema(name="model", description="Device model name")
    private String model;
    @Schema(name="modelVersion", description="Model version of device,for example:3.0")
    private String modelVersion;
    @Schema(name="showModel", description="Device model name with version")
    private String showModel;
    @Schema(name="ip", description="Device IP")
    private String ip;
    @Schema(name="ipv6List", description="Device IPv6 list")
    private List<String> ipv6List;
    @Schema(name="status", description="Status of device,status should be a value as follows: 0:Disconnected;1:Disconnected(Migrating);10:Provisioning;11:Configuring;12:Upgrading;13:Rebooting;14:Connected;15:Connected(Wireless);16:Connected(Migrating);17:Connected(Wireless,Migrating);20:Pending;21:Pending(Wireless);22:Adopting;23:Adopting(Wireless);24:Adopt Failed;25:Adopt Failed(Wireless);26:Managed By Others;27:Managed By Others(Wireless);30:Heartbeat Missed;31:Heartbeat Missed(Wireless);32:Heartbeat Missed(Migrating);33:Heartbeat Missed(Wireless,Migrating);40:Isolated;41:Isolated(Migrating);50:Slice Configuring")
    private Integer status;
    @Schema(name="statusCategory", description="Device status should be a value as follows: 0: Disconnected; 1: Connected; 2: Pending; 3: Heartbeat Missed; 4: Isolated")
    private Integer statusCategory;
    @Schema(name="devTxRate", description="Device real-time uploadRate")
    private Long devTxRate;
    @Schema(name="devRxRate", description="Device real-time downloadRate")
    private Long devRxRate;
    @Schema(name="stackGroup", description="Stack Group")
    private Boolean stackGroup;
    @Schema(name="healthScore", description="1~3: poor; 4~7: fair; 0: no data; 8~10 good.")
    private Integer healthScore;
    @Schema(name="apInfo", description="AP info, exists when deviceType is 0.")
    private ApInfoOpenApiVO apInfo;
    @Schema(name="switchInfo", description="Switch info, exists when deviceType is 1.")
    private SwitchInfoOpenApiVO switchInfo;
    @Schema(name="gatewayInfo", description="Gateway info, exists when deviceType is 2.")
    private GatewayInfoOpenApiVO gatewayInfo;

    public boolean isAp() {
        return this.deviceType == 0;
    }

    public boolean isOsw() {
        return this.deviceType == 1;
    }

    public boolean isOsg() {
        return this.deviceType == 2;
    }

    public static DeviceNodeOpenApiVO build(DeviceInfoVO deviceInfoVO) {
        if (deviceInfoVO == null) {
            return null;
        }
        DeviceNodeOpenApiVO deviceNodeOpenApiVO = new DeviceNodeOpenApiVO();
        deviceNodeOpenApiVO.setDeviceType(deviceInfoVO.getDeviceType());
        deviceNodeOpenApiVO.setName(deviceInfoVO.getName());
        deviceNodeOpenApiVO.setMac(deviceInfoVO.getMac());
        deviceNodeOpenApiVO.setModel(deviceInfoVO.getModel());
        deviceNodeOpenApiVO.setModelVersion(deviceInfoVO.getModelVersion());
        deviceNodeOpenApiVO.setShowModel(deviceInfoVO.getShowModel());
        deviceNodeOpenApiVO.setIp(deviceInfoVO.getIp());
        deviceNodeOpenApiVO.setIpv6List(deviceInfoVO.getIpv6List());
        deviceNodeOpenApiVO.setStatus(deviceInfoVO.getStatus());
        deviceNodeOpenApiVO.setStatusCategory(deviceInfoVO.getStatusCategory());
        deviceNodeOpenApiVO.setHealthScore(deviceInfoVO.getHealthScore());
        deviceNodeOpenApiVO.setDevTxRate(deviceInfoVO.getDevTxRate());
        deviceNodeOpenApiVO.setDevRxRate(deviceInfoVO.getDevRxRate());
        deviceNodeOpenApiVO.setStackGroup(deviceInfoVO.getStackGroup());
        deviceNodeOpenApiVO.setApInfo(ApInfoOpenApiVO.build(deviceInfoVO.getApInfo()));
        deviceNodeOpenApiVO.setSwitchInfo(SwitchInfoOpenApiVO.build(deviceInfoVO.getSwitchInfo()));
        deviceNodeOpenApiVO.setGatewayInfo(GatewayInfoOpenApiVO.build(deviceInfoVO.getGatewayInfoVO()));
        return deviceNodeOpenApiVO;
    }

    @Generated
    public DeviceNodeOpenApiVO() {
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getShowModel() {
        return this.showModel;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<String> getIpv6List() {
        return this.ipv6List;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getStatusCategory() {
        return this.statusCategory;
    }

    @Generated
    public Long getDevTxRate() {
        return this.devTxRate;
    }

    @Generated
    public Long getDevRxRate() {
        return this.devRxRate;
    }

    @Generated
    public Boolean getStackGroup() {
        return this.stackGroup;
    }

    @Generated
    public Integer getHealthScore() {
        return this.healthScore;
    }

    @Generated
    public ApInfoOpenApiVO getApInfo() {
        return this.apInfo;
    }

    @Generated
    public SwitchInfoOpenApiVO getSwitchInfo() {
        return this.switchInfo;
    }

    @Generated
    public GatewayInfoOpenApiVO getGatewayInfo() {
        return this.gatewayInfo;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setShowModel(String showModel) {
        this.showModel = showModel;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setIpv6List(List<String> ipv6List) {
        this.ipv6List = ipv6List;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setStatusCategory(Integer statusCategory) {
        this.statusCategory = statusCategory;
    }

    @Generated
    public void setDevTxRate(Long devTxRate) {
        this.devTxRate = devTxRate;
    }

    @Generated
    public void setDevRxRate(Long devRxRate) {
        this.devRxRate = devRxRate;
    }

    @Generated
    public void setStackGroup(Boolean stackGroup) {
        this.stackGroup = stackGroup;
    }

    @Generated
    public void setHealthScore(Integer healthScore) {
        this.healthScore = healthScore;
    }

    @Generated
    public void setApInfo(ApInfoOpenApiVO apInfo) {
        this.apInfo = apInfo;
    }

    @Generated
    public void setSwitchInfo(SwitchInfoOpenApiVO switchInfo) {
        this.switchInfo = switchInfo;
    }

    @Generated
    public void setGatewayInfo(GatewayInfoOpenApiVO gatewayInfo) {
        this.gatewayInfo = gatewayInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceNodeOpenApiVO)) {
            return false;
        }
        DeviceNodeOpenApiVO other = (DeviceNodeOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$deviceType = this.getDeviceType();
        Integer other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !((Object)this$deviceType).equals(other$deviceType)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$statusCategory = this.getStatusCategory();
        Integer other$statusCategory = other.getStatusCategory();
        if (this$statusCategory == null ? other$statusCategory != null : !((Object)this$statusCategory).equals(other$statusCategory)) {
            return false;
        }
        Long this$devTxRate = this.getDevTxRate();
        Long other$devTxRate = other.getDevTxRate();
        if (this$devTxRate == null ? other$devTxRate != null : !((Object)this$devTxRate).equals(other$devTxRate)) {
            return false;
        }
        Long this$devRxRate = this.getDevRxRate();
        Long other$devRxRate = other.getDevRxRate();
        if (this$devRxRate == null ? other$devRxRate != null : !((Object)this$devRxRate).equals(other$devRxRate)) {
            return false;
        }
        Boolean this$stackGroup = this.getStackGroup();
        Boolean other$stackGroup = other.getStackGroup();
        if (this$stackGroup == null ? other$stackGroup != null : !((Object)this$stackGroup).equals(other$stackGroup)) {
            return false;
        }
        Integer this$healthScore = this.getHealthScore();
        Integer other$healthScore = other.getHealthScore();
        if (this$healthScore == null ? other$healthScore != null : !((Object)this$healthScore).equals(other$healthScore)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        String this$showModel = this.getShowModel();
        String other$showModel = other.getShowModel();
        if (this$showModel == null ? other$showModel != null : !this$showModel.equals(other$showModel)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        List<String> this$ipv6List = this.getIpv6List();
        List<String> other$ipv6List = other.getIpv6List();
        if (this$ipv6List == null ? other$ipv6List != null : !((Object)this$ipv6List).equals(other$ipv6List)) {
            return false;
        }
        ApInfoOpenApiVO this$apInfo = this.getApInfo();
        ApInfoOpenApiVO other$apInfo = other.getApInfo();
        if (this$apInfo == null ? other$apInfo != null : !this$apInfo.equals(other$apInfo)) {
            return false;
        }
        SwitchInfoOpenApiVO this$switchInfo = this.getSwitchInfo();
        SwitchInfoOpenApiVO other$switchInfo = other.getSwitchInfo();
        if (this$switchInfo == null ? other$switchInfo != null : !((Object)this$switchInfo).equals(other$switchInfo)) {
            return false;
        }
        GatewayInfoOpenApiVO this$gatewayInfo = this.getGatewayInfo();
        GatewayInfoOpenApiVO other$gatewayInfo = other.getGatewayInfo();
        return !(this$gatewayInfo == null ? other$gatewayInfo != null : !((Object)this$gatewayInfo).equals(other$gatewayInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceNodeOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : ((Object)$deviceType).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $statusCategory = this.getStatusCategory();
        result = result * 59 + ($statusCategory == null ? 43 : ((Object)$statusCategory).hashCode());
        Long $devTxRate = this.getDevTxRate();
        result = result * 59 + ($devTxRate == null ? 43 : ((Object)$devTxRate).hashCode());
        Long $devRxRate = this.getDevRxRate();
        result = result * 59 + ($devRxRate == null ? 43 : ((Object)$devRxRate).hashCode());
        Boolean $stackGroup = this.getStackGroup();
        result = result * 59 + ($stackGroup == null ? 43 : ((Object)$stackGroup).hashCode());
        Integer $healthScore = this.getHealthScore();
        result = result * 59 + ($healthScore == null ? 43 : ((Object)$healthScore).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        String $showModel = this.getShowModel();
        result = result * 59 + ($showModel == null ? 43 : $showModel.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        List<String> $ipv6List = this.getIpv6List();
        result = result * 59 + ($ipv6List == null ? 43 : ((Object)$ipv6List).hashCode());
        ApInfoOpenApiVO $apInfo = this.getApInfo();
        result = result * 59 + ($apInfo == null ? 43 : $apInfo.hashCode());
        SwitchInfoOpenApiVO $switchInfo = this.getSwitchInfo();
        result = result * 59 + ($switchInfo == null ? 43 : ((Object)$switchInfo).hashCode());
        GatewayInfoOpenApiVO $gatewayInfo = this.getGatewayInfo();
        result = result * 59 + ($gatewayInfo == null ? 43 : ((Object)$gatewayInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeviceNodeOpenApiVO(deviceType=" + this.getDeviceType() + ", name=" + this.getName() + ", mac=" + this.getMac() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", showModel=" + this.getShowModel() + ", ip=" + this.getIp() + ", ipv6List=" + this.getIpv6List() + ", status=" + this.getStatus() + ", statusCategory=" + this.getStatusCategory() + ", devTxRate=" + this.getDevTxRate() + ", devRxRate=" + this.getDevRxRate() + ", stackGroup=" + this.getStackGroup() + ", healthScore=" + this.getHealthScore() + ", apInfo=" + this.getApInfo() + ", switchInfo=" + this.getSwitchInfo() + ", gatewayInfo=" + this.getGatewayInfo() + ")";
    }
}

