/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.api.openapi.vo.topology;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.client.api.web.vo.clienttopo.ClientInfoVO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import lombok.Generated;

@Schema(name="Client Node Info")
public class ClientNodeOpenApiVO {
    @Schema(name="mac", description="Client MAC Address.")
    @a
    private String mac;
    @Schema(name="name", description="Client name.")
    private String name;
    @Schema(name="wireless", description="true: Wireless client;  false: Not wireless client")
    private Boolean wireless;
    @Schema(name="guest", description="(Wireless) Whether it is Guest (used to display the wireless Guest client icon).")
    private Boolean guest;
    @Schema(name="clientType", description="Client Type: iphone, ipod, android, pc, printer, tv...")
    private String clientType;
    @Schema(name="upDeviceType", description="Uplink device type, 0: AP; 1: Switch; 2: Gateway.")
    private Integer upDeviceType;
    @Schema(name="authStatus", description="Authentication status should be a value as follows: <br/>0: CONNECTED // Access without any authentication method; <br/>1: PENDING // Access to Portal, but authentication failed; <br/>2: AUTHORIZED // Pass through portal, pass other authentication without portal; <br/>3: AUTH-FREE // No portal authentication required.")
    private Integer authStatus;
    @Schema(name="model", description="Model of client device.")
    private String model;
    @Schema(name="manager", description="Whether it is the device currently accessing the Controller itself.")
    private Boolean manager;
    @Schema(name="devTxRate", description="Client real-time uploadRate")
    private Long devTxRate;
    @Schema(name="devRxRate", description="Client real-time downloadRate")
    private Long devRxRate;
    @Schema(name="healthScore", description="Health Score, 1~3: poor; 4~7: fair; 0: no data; 8~10 good.")
    private Integer healthScore;
    @Schema(name="upOswInfo", description="Uplink switch info, exists when parameter [upDeviceType] is 1.")
    private UpOswInfo upOswInfo;
    @Schema(name="upApInfo", description="Uplink AP info, exists when parameter [upDeviceType] is 0.")
    private UpApInfo upApInfo;

    public static ClientNodeOpenApiVO build(ClientInfoVO clientInfoVO) {
        if (clientInfoVO == null) {
            return null;
        }
        return new ClientNodeOpenApiVO().setMac(clientInfoVO.getMac()).setName(clientInfoVO.getName()).setWireless(clientInfoVO.getWireless()).setGuest(clientInfoVO.getGuest()).setClientType(clientInfoVO.getClientType()).setUpDeviceType(clientInfoVO.getUpDeviceType()).setHealthScore(clientInfoVO.getHealthScore()).setAuthStatus(clientInfoVO.getAuthStatus()).setModel(clientInfoVO.getModel()).setManager(clientInfoVO.getManager()).setDevTxRate(clientInfoVO.getDevTxRate()).setDevRxRate(clientInfoVO.getDevRxRate()).setUpOswInfo(Optional.ofNullable(clientInfoVO.getUpOswInfo()).map(entry -> {
            UpOswInfo upOswInfo = new UpOswInfo();
            upOswInfo.setPort(entry.getPort());
            upOswInfo.setStandardPort(entry.getStandardPort());
            upOswInfo.setLagId(entry.getLagId() == null ? null : entry.getLagId().toString());
            upOswInfo.setLinkSpeed(entry.getLinkSpeed());
            upOswInfo.setDuplex(entry.getDuplex());
            upOswInfo.setTrafficDown(entry.getTrafficDown());
            upOswInfo.setTrafficUp(entry.getTrafficUp());
            return upOswInfo;
        }).orElse(null)).setUpApInfo(Optional.ofNullable(clientInfoVO.getUpApInfo()).map(entry -> {
            UpApInfo apInfo = new UpApInfo();
            apInfo.setPort(entry.getPort());
            apInfo.setName(entry.getName());
            apInfo.setLagId(entry.getLagId());
            apInfo.setChannel(entry.getChannel());
            apInfo.setSsid(entry.getSsid());
            apInfo.setRadio(entry.getRadio());
            apInfo.setSupport5g2(entry.getSupport5g2());
            apInfo.setRssi(entry.getRssi());
            apInfo.setTrafficDown(entry.getTrafficDown());
            apInfo.setTrafficUp(entry.getTrafficUp());
            apInfo.setTxRate(entry.getTxRate());
            apInfo.setRxRate(entry.getRxRate());
            return apInfo;
        }).orElse(null));
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getWireless() {
        return this.wireless;
    }

    @Generated
    public Boolean getGuest() {
        return this.guest;
    }

    @Generated
    public String getClientType() {
        return this.clientType;
    }

    @Generated
    public Integer getUpDeviceType() {
        return this.upDeviceType;
    }

    @Generated
    public Integer getAuthStatus() {
        return this.authStatus;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public Boolean getManager() {
        return this.manager;
    }

    @Generated
    public Long getDevTxRate() {
        return this.devTxRate;
    }

    @Generated
    public Long getDevRxRate() {
        return this.devRxRate;
    }

    @Generated
    public Integer getHealthScore() {
        return this.healthScore;
    }

    @Generated
    public UpOswInfo getUpOswInfo() {
        return this.upOswInfo;
    }

    @Generated
    public UpApInfo getUpApInfo() {
        return this.upApInfo;
    }

    @Generated
    public ClientNodeOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setWireless(Boolean wireless) {
        this.wireless = wireless;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setGuest(Boolean guest) {
        this.guest = guest;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setClientType(String clientType) {
        this.clientType = clientType;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setUpDeviceType(Integer upDeviceType) {
        this.upDeviceType = upDeviceType;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setModel(String model) {
        this.model = model;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setManager(Boolean manager) {
        this.manager = manager;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setDevTxRate(Long devTxRate) {
        this.devTxRate = devTxRate;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setDevRxRate(Long devRxRate) {
        this.devRxRate = devRxRate;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setHealthScore(Integer healthScore) {
        this.healthScore = healthScore;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setUpOswInfo(UpOswInfo upOswInfo) {
        this.upOswInfo = upOswInfo;
        return this;
    }

    @Generated
    public ClientNodeOpenApiVO setUpApInfo(UpApInfo upApInfo) {
        this.upApInfo = upApInfo;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientNodeOpenApiVO)) {
            return false;
        }
        ClientNodeOpenApiVO other = (ClientNodeOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$wireless = this.getWireless();
        Boolean other$wireless = other.getWireless();
        if (this$wireless == null ? other$wireless != null : !((Object)this$wireless).equals(other$wireless)) {
            return false;
        }
        Boolean this$guest = this.getGuest();
        Boolean other$guest = other.getGuest();
        if (this$guest == null ? other$guest != null : !((Object)this$guest).equals(other$guest)) {
            return false;
        }
        Integer this$upDeviceType = this.getUpDeviceType();
        Integer other$upDeviceType = other.getUpDeviceType();
        if (this$upDeviceType == null ? other$upDeviceType != null : !((Object)this$upDeviceType).equals(other$upDeviceType)) {
            return false;
        }
        Integer this$authStatus = this.getAuthStatus();
        Integer other$authStatus = other.getAuthStatus();
        if (this$authStatus == null ? other$authStatus != null : !((Object)this$authStatus).equals(other$authStatus)) {
            return false;
        }
        Boolean this$manager = this.getManager();
        Boolean other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
            return false;
        }
        Long this$devTxRate = this.getDevTxRate();
        Long other$devTxRate = other.getDevTxRate();
        if (this$devTxRate == null ? other$devTxRate != null : !((Object)this$devTxRate).equals(other$devTxRate)) {
            return false;
        }
        Long this$devRxRate = this.getDevRxRate();
        Long other$devRxRate = other.getDevRxRate();
        if (this$devRxRate == null ? other$devRxRate != null : !((Object)this$devRxRate).equals(other$devRxRate)) {
            return false;
        }
        Integer this$healthScore = this.getHealthScore();
        Integer other$healthScore = other.getHealthScore();
        if (this$healthScore == null ? other$healthScore != null : !((Object)this$healthScore).equals(other$healthScore)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        UpOswInfo this$upOswInfo = this.getUpOswInfo();
        UpOswInfo other$upOswInfo = other.getUpOswInfo();
        if (this$upOswInfo == null ? other$upOswInfo != null : !((Object)this$upOswInfo).equals(other$upOswInfo)) {
            return false;
        }
        UpApInfo this$upApInfo = this.getUpApInfo();
        UpApInfo other$upApInfo = other.getUpApInfo();
        return !(this$upApInfo == null ? other$upApInfo != null : !((Object)this$upApInfo).equals(other$upApInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientNodeOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $wireless = this.getWireless();
        result = result * 59 + ($wireless == null ? 43 : ((Object)$wireless).hashCode());
        Boolean $guest = this.getGuest();
        result = result * 59 + ($guest == null ? 43 : ((Object)$guest).hashCode());
        Integer $upDeviceType = this.getUpDeviceType();
        result = result * 59 + ($upDeviceType == null ? 43 : ((Object)$upDeviceType).hashCode());
        Integer $authStatus = this.getAuthStatus();
        result = result * 59 + ($authStatus == null ? 43 : ((Object)$authStatus).hashCode());
        Boolean $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
        Long $devTxRate = this.getDevTxRate();
        result = result * 59 + ($devTxRate == null ? 43 : ((Object)$devTxRate).hashCode());
        Long $devRxRate = this.getDevRxRate();
        result = result * 59 + ($devRxRate == null ? 43 : ((Object)$devRxRate).hashCode());
        Integer $healthScore = this.getHealthScore();
        result = result * 59 + ($healthScore == null ? 43 : ((Object)$healthScore).hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        UpOswInfo $upOswInfo = this.getUpOswInfo();
        result = result * 59 + ($upOswInfo == null ? 43 : ((Object)$upOswInfo).hashCode());
        UpApInfo $upApInfo = this.getUpApInfo();
        result = result * 59 + ($upApInfo == null ? 43 : ((Object)$upApInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientNodeOpenApiVO(mac=" + this.getMac() + ", name=" + this.getName() + ", wireless=" + this.getWireless() + ", guest=" + this.getGuest() + ", clientType=" + this.getClientType() + ", upDeviceType=" + this.getUpDeviceType() + ", authStatus=" + this.getAuthStatus() + ", model=" + this.getModel() + ", manager=" + this.getManager() + ", devTxRate=" + this.getDevTxRate() + ", devRxRate=" + this.getDevRxRate() + ", healthScore=" + this.getHealthScore() + ", upOswInfo=" + this.getUpOswInfo() + ", upApInfo=" + this.getUpApInfo() + ")";
    }

    @Generated
    public ClientNodeOpenApiVO() {
    }

    @Schema(name="Uplink Switch Info")
    @KeepClass
    public static class UpOswInfo {
        @Schema(name="port", description="Client connected port.")
        private Integer port;
        @Schema(name="standardPort", description="Standard Port of Stack")
        private String standardPort;
        @Schema(name="lagId", description="Lag Id")
        private String lagId;
        @Schema(name="linkSpeed", description="Port link speed, 1: 10Mbps; 2: 100Mbps; 3: 1000Mbps; 4: 2.5Gbps; 5: 10Gbps.")
        private Integer linkSpeed;
        @Schema(name="duplex", description="Duplex: 1:Half; 2:Full.")
        private Integer duplex;
        @Schema(name="trafficDown", description="Downstream traffic (Byte).")
        private Long trafficDown;
        @Schema(name="trafficUp", description="Upstream traffic (Byte).")
        private Long trafficUp;

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public String getStandardPort() {
            return this.standardPort;
        }

        @Generated
        public String getLagId() {
            return this.lagId;
        }

        @Generated
        public Integer getLinkSpeed() {
            return this.linkSpeed;
        }

        @Generated
        public Integer getDuplex() {
            return this.duplex;
        }

        @Generated
        public Long getTrafficDown() {
            return this.trafficDown;
        }

        @Generated
        public Long getTrafficUp() {
            return this.trafficUp;
        }

        @Generated
        public UpOswInfo setPort(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public UpOswInfo setStandardPort(String standardPort) {
            this.standardPort = standardPort;
            return this;
        }

        @Generated
        public UpOswInfo setLagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        @Generated
        public UpOswInfo setLinkSpeed(Integer linkSpeed) {
            this.linkSpeed = linkSpeed;
            return this;
        }

        @Generated
        public UpOswInfo setDuplex(Integer duplex) {
            this.duplex = duplex;
            return this;
        }

        @Generated
        public UpOswInfo setTrafficDown(Long trafficDown) {
            this.trafficDown = trafficDown;
            return this;
        }

        @Generated
        public UpOswInfo setTrafficUp(Long trafficUp) {
            this.trafficUp = trafficUp;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpOswInfo)) {
                return false;
            }
            UpOswInfo other = (UpOswInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            Integer this$linkSpeed = this.getLinkSpeed();
            Integer other$linkSpeed = other.getLinkSpeed();
            if (this$linkSpeed == null ? other$linkSpeed != null : !((Object)this$linkSpeed).equals(other$linkSpeed)) {
                return false;
            }
            Integer this$duplex = this.getDuplex();
            Integer other$duplex = other.getDuplex();
            if (this$duplex == null ? other$duplex != null : !((Object)this$duplex).equals(other$duplex)) {
                return false;
            }
            Long this$trafficDown = this.getTrafficDown();
            Long other$trafficDown = other.getTrafficDown();
            if (this$trafficDown == null ? other$trafficDown != null : !((Object)this$trafficDown).equals(other$trafficDown)) {
                return false;
            }
            Long this$trafficUp = this.getTrafficUp();
            Long other$trafficUp = other.getTrafficUp();
            if (this$trafficUp == null ? other$trafficUp != null : !((Object)this$trafficUp).equals(other$trafficUp)) {
                return false;
            }
            String this$standardPort = this.getStandardPort();
            String other$standardPort = other.getStandardPort();
            if (this$standardPort == null ? other$standardPort != null : !this$standardPort.equals(other$standardPort)) {
                return false;
            }
            String this$lagId = this.getLagId();
            String other$lagId = other.getLagId();
            return !(this$lagId == null ? other$lagId != null : !this$lagId.equals(other$lagId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpOswInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            Integer $linkSpeed = this.getLinkSpeed();
            result = result * 59 + ($linkSpeed == null ? 43 : ((Object)$linkSpeed).hashCode());
            Integer $duplex = this.getDuplex();
            result = result * 59 + ($duplex == null ? 43 : ((Object)$duplex).hashCode());
            Long $trafficDown = this.getTrafficDown();
            result = result * 59 + ($trafficDown == null ? 43 : ((Object)$trafficDown).hashCode());
            Long $trafficUp = this.getTrafficUp();
            result = result * 59 + ($trafficUp == null ? 43 : ((Object)$trafficUp).hashCode());
            String $standardPort = this.getStandardPort();
            result = result * 59 + ($standardPort == null ? 43 : $standardPort.hashCode());
            String $lagId = this.getLagId();
            result = result * 59 + ($lagId == null ? 43 : $lagId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientNodeOpenApiVO.UpOswInfo(port=" + this.getPort() + ", standardPort=" + this.getStandardPort() + ", lagId=" + this.getLagId() + ", linkSpeed=" + this.getLinkSpeed() + ", duplex=" + this.getDuplex() + ", trafficDown=" + this.getTrafficDown() + ", trafficUp=" + this.getTrafficUp() + ")";
        }
    }

    @Schema(name="Uplink AP Info")
    @KeepClass
    public static class UpApInfo {
        @Schema(name="port", description="Client connected port.")
        private Integer port;
        @Schema(name="name", description="Client connected port name.")
        private String name;
        @Schema(name="lagId", description="Lag Id")
        private Integer lagId;
        @Schema(name="channel", description="Connected actual channel.")
        private Integer channel;
        @Schema(name="ssid", description="Connected SSID name.")
        private String ssid;
        @Schema(name="radio", description="Radio ID, 0: 2.4GHz; 1: 5GHz-1; 2:5GHz-2; 3: 6GHz.")
        private Integer radio;
        @Schema(name="support5g2", description="Whether the AP support 5G2 radio.")
        private Boolean support5g2;
        @Schema(name="rssi", description="Signal strength, unit: dBm.")
        private Integer rssi;
        @Schema(name="trafficDown", description="Downstream traffic (Byte).")
        private Long trafficDown;
        @Schema(name="trafficUp", description="Upstream traffic (Byte).")
        private Long trafficUp;
        @Schema(name="txRate", description="Downlink negotiation rate (Kbit/s)")
        private Long txRate;
        @Schema(name="rxRate", description="Uplink negotiation rate (Kbit/s)")
        private Long rxRate;

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Integer getLagId() {
            return this.lagId;
        }

        @Generated
        public Integer getChannel() {
            return this.channel;
        }

        @Generated
        public String getSsid() {
            return this.ssid;
        }

        @Generated
        public Integer getRadio() {
            return this.radio;
        }

        @Generated
        public Boolean getSupport5g2() {
            return this.support5g2;
        }

        @Generated
        public Integer getRssi() {
            return this.rssi;
        }

        @Generated
        public Long getTrafficDown() {
            return this.trafficDown;
        }

        @Generated
        public Long getTrafficUp() {
            return this.trafficUp;
        }

        @Generated
        public Long getTxRate() {
            return this.txRate;
        }

        @Generated
        public Long getRxRate() {
            return this.rxRate;
        }

        @Generated
        public UpApInfo setPort(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public UpApInfo setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public UpApInfo setLagId(Integer lagId) {
            this.lagId = lagId;
            return this;
        }

        @Generated
        public UpApInfo setChannel(Integer channel) {
            this.channel = channel;
            return this;
        }

        @Generated
        public UpApInfo setSsid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        @Generated
        public UpApInfo setRadio(Integer radio) {
            this.radio = radio;
            return this;
        }

        @Generated
        public UpApInfo setSupport5g2(Boolean support5g2) {
            this.support5g2 = support5g2;
            return this;
        }

        @Generated
        public UpApInfo setRssi(Integer rssi) {
            this.rssi = rssi;
            return this;
        }

        @Generated
        public UpApInfo setTrafficDown(Long trafficDown) {
            this.trafficDown = trafficDown;
            return this;
        }

        @Generated
        public UpApInfo setTrafficUp(Long trafficUp) {
            this.trafficUp = trafficUp;
            return this;
        }

        @Generated
        public UpApInfo setTxRate(Long txRate) {
            this.txRate = txRate;
            return this;
        }

        @Generated
        public UpApInfo setRxRate(Long rxRate) {
            this.rxRate = rxRate;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpApInfo)) {
                return false;
            }
            UpApInfo other = (UpApInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            Integer this$lagId = this.getLagId();
            Integer other$lagId = other.getLagId();
            if (this$lagId == null ? other$lagId != null : !((Object)this$lagId).equals(other$lagId)) {
                return false;
            }
            Integer this$channel = this.getChannel();
            Integer other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            Integer this$radio = this.getRadio();
            Integer other$radio = other.getRadio();
            if (this$radio == null ? other$radio != null : !((Object)this$radio).equals(other$radio)) {
                return false;
            }
            Boolean this$support5g2 = this.getSupport5g2();
            Boolean other$support5g2 = other.getSupport5g2();
            if (this$support5g2 == null ? other$support5g2 != null : !((Object)this$support5g2).equals(other$support5g2)) {
                return false;
            }
            Integer this$rssi = this.getRssi();
            Integer other$rssi = other.getRssi();
            if (this$rssi == null ? other$rssi != null : !((Object)this$rssi).equals(other$rssi)) {
                return false;
            }
            Long this$trafficDown = this.getTrafficDown();
            Long other$trafficDown = other.getTrafficDown();
            if (this$trafficDown == null ? other$trafficDown != null : !((Object)this$trafficDown).equals(other$trafficDown)) {
                return false;
            }
            Long this$trafficUp = this.getTrafficUp();
            Long other$trafficUp = other.getTrafficUp();
            if (this$trafficUp == null ? other$trafficUp != null : !((Object)this$trafficUp).equals(other$trafficUp)) {
                return false;
            }
            Long this$txRate = this.getTxRate();
            Long other$txRate = other.getTxRate();
            if (this$txRate == null ? other$txRate != null : !((Object)this$txRate).equals(other$txRate)) {
                return false;
            }
            Long this$rxRate = this.getRxRate();
            Long other$rxRate = other.getRxRate();
            if (this$rxRate == null ? other$rxRate != null : !((Object)this$rxRate).equals(other$rxRate)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$ssid = this.getSsid();
            String other$ssid = other.getSsid();
            return !(this$ssid == null ? other$ssid != null : !this$ssid.equals(other$ssid));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpApInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            Integer $lagId = this.getLagId();
            result = result * 59 + ($lagId == null ? 43 : ((Object)$lagId).hashCode());
            Integer $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            Integer $radio = this.getRadio();
            result = result * 59 + ($radio == null ? 43 : ((Object)$radio).hashCode());
            Boolean $support5g2 = this.getSupport5g2();
            result = result * 59 + ($support5g2 == null ? 43 : ((Object)$support5g2).hashCode());
            Integer $rssi = this.getRssi();
            result = result * 59 + ($rssi == null ? 43 : ((Object)$rssi).hashCode());
            Long $trafficDown = this.getTrafficDown();
            result = result * 59 + ($trafficDown == null ? 43 : ((Object)$trafficDown).hashCode());
            Long $trafficUp = this.getTrafficUp();
            result = result * 59 + ($trafficUp == null ? 43 : ((Object)$trafficUp).hashCode());
            Long $txRate = this.getTxRate();
            result = result * 59 + ($txRate == null ? 43 : ((Object)$txRate).hashCode());
            Long $rxRate = this.getRxRate();
            result = result * 59 + ($rxRate == null ? 43 : ((Object)$rxRate).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $ssid = this.getSsid();
            result = result * 59 + ($ssid == null ? 43 : $ssid.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientNodeOpenApiVO.UpApInfo(port=" + this.getPort() + ", name=" + this.getName() + ", lagId=" + this.getLagId() + ", channel=" + this.getChannel() + ", ssid=" + this.getSsid() + ", radio=" + this.getRadio() + ", support5g2=" + this.getSupport5g2() + ", rssi=" + this.getRssi() + ", trafficDown=" + this.getTrafficDown() + ", trafficUp=" + this.getTrafficUp() + ", txRate=" + this.getTxRate() + ", rxRate=" + this.getRxRate() + ")";
        }
    }
}

