/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.api.openapi.vo.topology;

import com.tplink.smb.omada.client.api.web.vo.clienttopo.ApInfoVO;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.WiredPortV3DTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import lombok.Generated;

@Schema(name="AP Info")
public class ApInfoOpenApiVO {
    @Schema(name="wiredUpLink", description="Exists when connected to upper level device via wired connection")
    private WiredUpLink wiredUpLink;
    @Schema(name="wirelessUpLink", description="Exists when connected to upper level device via wireless connection")
    private WirelessUpLink wirelessUpLink;

    public ApInfoOpenApiVO() {
    }

    public static ApInfoOpenApiVO build(ApInfoVO apInfoVO) {
        if (apInfoVO == null) {
            return null;
        }
        ApInfoOpenApiVO vo = new ApInfoOpenApiVO();
        vo.setWiredUpLink(Optional.ofNullable(apInfoVO.getWiredUpLink()).map(entry -> {
            WiredUpLink wiredUpLink = new WiredUpLink();
            wiredUpLink.setUpPort(entry.getUpPort());
            wiredUpLink.setUpLinkPort(entry.getUpLinkPort());
            wiredUpLink.setLinkSpeed(entry.getLinkSpeed());
            wiredUpLink.setDuplex(entry.getDuplex());
            wiredUpLink.setRxDropPkts(entry.getRxDropPkts());
            wiredUpLink.setTxDropPkts(entry.getTxDropPkts());
            wiredUpLink.setRxErrPkts(entry.getRxErrPkts());
            wiredUpLink.setTxErrPkts(entry.getTxErrPkts());
            return wiredUpLink;
        }).orElse(null));
        vo.setWirelessUpLink(Optional.ofNullable(apInfoVO.getWirelessUpLink()).map(entry -> {
            WirelessUpLink wirelessUpLink = new WirelessUpLink();
            wirelessUpLink.setTxRate(entry.getTxRate());
            wirelessUpLink.setRxRate(entry.getRxRate());
            wirelessUpLink.setRssi(entry.getRssi());
            wirelessUpLink.setRssiPercent(entry.getRssiPercent());
            wirelessUpLink.setRxDropPkts(entry.getRxDropPkts());
            wirelessUpLink.setTxDropPkts(entry.getTxDropPkts());
            wirelessUpLink.setRxErrPkts(entry.getRxErrPkts());
            wirelessUpLink.setTxErrPkts(entry.getTxErrPkts());
            wirelessUpLink.setSnr(entry.getSnr());
            return wirelessUpLink;
        }).orElse(null));
        return vo;
    }

    @Generated
    public WiredUpLink getWiredUpLink() {
        return this.wiredUpLink;
    }

    @Generated
    public WirelessUpLink getWirelessUpLink() {
        return this.wirelessUpLink;
    }

    @Generated
    public void setWiredUpLink(WiredUpLink wiredUpLink) {
        this.wiredUpLink = wiredUpLink;
    }

    @Generated
    public void setWirelessUpLink(WirelessUpLink wirelessUpLink) {
        this.wirelessUpLink = wirelessUpLink;
    }

    @Generated
    public ApInfoOpenApiVO(WiredUpLink wiredUpLink, WirelessUpLink wirelessUpLink) {
        this.wiredUpLink = wiredUpLink;
        this.wirelessUpLink = wirelessUpLink;
    }

    @Schema(name="Wired Up Link Info")
    @KeepClass
    public static class WiredUpLink {
        @Schema(name="upPort", description="port info.")
        private WiredPortV3DTO upPort;
        @Schema(name="upLinkPort", description="Uplink port.")
        private WiredPortV3DTO upLinkPort;
        @Schema(name="linkSpeed", description="Uplink port linkSpeed, linkSpeed should be a value as follows: 0: Auto; 1: 10M; 2: 100M; 3: 1000M; 4: 2500M; 5: 10G; 6: 5G; 7: 25G, 8: 100G.")
        private Integer linkSpeed;
        @Schema(name="duplex", description="Duplex mode, should be a value as follows: 0: Auto; 1: Half; 2: Full.")
        private Integer duplex;
        @Schema(name="rxDropPkts", description="Rx Dropped Packets")
        private Long rxDropPkts;
        @Schema(name="txDropPkts", description="Tx Dropped Packets")
        private Long txDropPkts;
        @Schema(name="rxErrPkts", description="Rx Error Packets")
        private Long rxErrPkts;
        @Schema(name="txErrPkts", description="Tx Error Packets")
        private Long txErrPkts;

        public WiredUpLink() {
        }

        @Generated
        public static WiredUpLinkBuilder builder() {
            return new WiredUpLinkBuilder();
        }

        @Generated
        public WiredPortV3DTO getUpPort() {
            return this.upPort;
        }

        @Generated
        public WiredPortV3DTO getUpLinkPort() {
            return this.upLinkPort;
        }

        @Generated
        public Integer getLinkSpeed() {
            return this.linkSpeed;
        }

        @Generated
        public Integer getDuplex() {
            return this.duplex;
        }

        @Generated
        public Long getRxDropPkts() {
            return this.rxDropPkts;
        }

        @Generated
        public Long getTxDropPkts() {
            return this.txDropPkts;
        }

        @Generated
        public Long getRxErrPkts() {
            return this.rxErrPkts;
        }

        @Generated
        public Long getTxErrPkts() {
            return this.txErrPkts;
        }

        @Generated
        public void setUpPort(WiredPortV3DTO upPort) {
            this.upPort = upPort;
        }

        @Generated
        public void setUpLinkPort(WiredPortV3DTO upLinkPort) {
            this.upLinkPort = upLinkPort;
        }

        @Generated
        public void setLinkSpeed(Integer linkSpeed) {
            this.linkSpeed = linkSpeed;
        }

        @Generated
        public void setDuplex(Integer duplex) {
            this.duplex = duplex;
        }

        @Generated
        public void setRxDropPkts(Long rxDropPkts) {
            this.rxDropPkts = rxDropPkts;
        }

        @Generated
        public void setTxDropPkts(Long txDropPkts) {
            this.txDropPkts = txDropPkts;
        }

        @Generated
        public void setRxErrPkts(Long rxErrPkts) {
            this.rxErrPkts = rxErrPkts;
        }

        @Generated
        public void setTxErrPkts(Long txErrPkts) {
            this.txErrPkts = txErrPkts;
        }

        @Generated
        public WiredUpLink(WiredPortV3DTO upPort, WiredPortV3DTO upLinkPort, Integer linkSpeed, Integer duplex, Long rxDropPkts, Long txDropPkts, Long rxErrPkts, Long txErrPkts) {
            this.upPort = upPort;
            this.upLinkPort = upLinkPort;
            this.linkSpeed = linkSpeed;
            this.duplex = duplex;
            this.rxDropPkts = rxDropPkts;
            this.txDropPkts = txDropPkts;
            this.rxErrPkts = rxErrPkts;
            this.txErrPkts = txErrPkts;
        }

        @Generated
        public static class WiredUpLinkBuilder {
            @Generated
            private WiredPortV3DTO upPort;
            @Generated
            private WiredPortV3DTO upLinkPort;
            @Generated
            private Integer linkSpeed;
            @Generated
            private Integer duplex;
            @Generated
            private Long rxDropPkts;
            @Generated
            private Long txDropPkts;
            @Generated
            private Long rxErrPkts;
            @Generated
            private Long txErrPkts;

            @Generated
            WiredUpLinkBuilder() {
            }

            @Generated
            public WiredUpLinkBuilder upPort(WiredPortV3DTO upPort) {
                this.upPort = upPort;
                return this;
            }

            @Generated
            public WiredUpLinkBuilder upLinkPort(WiredPortV3DTO upLinkPort) {
                this.upLinkPort = upLinkPort;
                return this;
            }

            @Generated
            public WiredUpLinkBuilder linkSpeed(Integer linkSpeed) {
                this.linkSpeed = linkSpeed;
                return this;
            }

            @Generated
            public WiredUpLinkBuilder duplex(Integer duplex) {
                this.duplex = duplex;
                return this;
            }

            @Generated
            public WiredUpLinkBuilder rxDropPkts(Long rxDropPkts) {
                this.rxDropPkts = rxDropPkts;
                return this;
            }

            @Generated
            public WiredUpLinkBuilder txDropPkts(Long txDropPkts) {
                this.txDropPkts = txDropPkts;
                return this;
            }

            @Generated
            public WiredUpLinkBuilder rxErrPkts(Long rxErrPkts) {
                this.rxErrPkts = rxErrPkts;
                return this;
            }

            @Generated
            public WiredUpLinkBuilder txErrPkts(Long txErrPkts) {
                this.txErrPkts = txErrPkts;
                return this;
            }

            @Generated
            public WiredUpLink build() {
                return new WiredUpLink(this.upPort, this.upLinkPort, this.linkSpeed, this.duplex, this.rxDropPkts, this.txDropPkts, this.rxErrPkts, this.txErrPkts);
            }

            @Generated
            public String toString() {
                return "ApInfoOpenApiVO.WiredUpLink.WiredUpLinkBuilder(upPort=" + this.upPort + ", upLinkPort=" + this.upLinkPort + ", linkSpeed=" + this.linkSpeed + ", duplex=" + this.duplex + ", rxDropPkts=" + this.rxDropPkts + ", txDropPkts=" + this.txDropPkts + ", rxErrPkts=" + this.rxErrPkts + ", txErrPkts=" + this.txErrPkts + ")";
            }
        }
    }

    @Schema(name="Wireless Up Link Info")
    @KeepClass
    public static class WirelessUpLink {
        @Schema(name="txRate", description="Tx Rate")
        private String txRate;
        @Schema(name="rxRate", description="Rx Rate")
        private String rxRate;
        @Schema(name="rssi", description="Rssi")
        private Integer rssi;
        @Schema(name="rssiPercent", description="Rssi percent")
        private Integer rssiPercent;
        @Schema(name="rxDropPkts", description="Rx Dropped Packets")
        private Long rxDropPkts;
        @Schema(name="txDropPkts", description="Tx Dropped Packets")
        private Long txDropPkts;
        @Schema(name="rxErrPkts", description="Rx Error Packets")
        private Long rxErrPkts;
        @Schema(name="txErrPkts", description="Tx Error Packets")
        private Long txErrPkts;
        @Schema(name="snr", description="Wireless P2P Ap Snr")
        private Integer snr;

        public WirelessUpLink() {
        }

        @Generated
        public static WirelessUpLinkBuilder builder() {
            return new WirelessUpLinkBuilder();
        }

        @Generated
        public String getTxRate() {
            return this.txRate;
        }

        @Generated
        public String getRxRate() {
            return this.rxRate;
        }

        @Generated
        public Integer getRssi() {
            return this.rssi;
        }

        @Generated
        public Integer getRssiPercent() {
            return this.rssiPercent;
        }

        @Generated
        public Long getRxDropPkts() {
            return this.rxDropPkts;
        }

        @Generated
        public Long getTxDropPkts() {
            return this.txDropPkts;
        }

        @Generated
        public Long getRxErrPkts() {
            return this.rxErrPkts;
        }

        @Generated
        public Long getTxErrPkts() {
            return this.txErrPkts;
        }

        @Generated
        public Integer getSnr() {
            return this.snr;
        }

        @Generated
        public void setTxRate(String txRate) {
            this.txRate = txRate;
        }

        @Generated
        public void setRxRate(String rxRate) {
            this.rxRate = rxRate;
        }

        @Generated
        public void setRssi(Integer rssi) {
            this.rssi = rssi;
        }

        @Generated
        public void setRssiPercent(Integer rssiPercent) {
            this.rssiPercent = rssiPercent;
        }

        @Generated
        public void setRxDropPkts(Long rxDropPkts) {
            this.rxDropPkts = rxDropPkts;
        }

        @Generated
        public void setTxDropPkts(Long txDropPkts) {
            this.txDropPkts = txDropPkts;
        }

        @Generated
        public void setRxErrPkts(Long rxErrPkts) {
            this.rxErrPkts = rxErrPkts;
        }

        @Generated
        public void setTxErrPkts(Long txErrPkts) {
            this.txErrPkts = txErrPkts;
        }

        @Generated
        public void setSnr(Integer snr) {
            this.snr = snr;
        }

        @Generated
        public WirelessUpLink(String txRate, String rxRate, Integer rssi, Integer rssiPercent, Long rxDropPkts, Long txDropPkts, Long rxErrPkts, Long txErrPkts, Integer snr) {
            this.txRate = txRate;
            this.rxRate = rxRate;
            this.rssi = rssi;
            this.rssiPercent = rssiPercent;
            this.rxDropPkts = rxDropPkts;
            this.txDropPkts = txDropPkts;
            this.rxErrPkts = rxErrPkts;
            this.txErrPkts = txErrPkts;
            this.snr = snr;
        }

        @Generated
        public static class WirelessUpLinkBuilder {
            @Generated
            private String txRate;
            @Generated
            private String rxRate;
            @Generated
            private Integer rssi;
            @Generated
            private Integer rssiPercent;
            @Generated
            private Long rxDropPkts;
            @Generated
            private Long txDropPkts;
            @Generated
            private Long rxErrPkts;
            @Generated
            private Long txErrPkts;
            @Generated
            private Integer snr;

            @Generated
            WirelessUpLinkBuilder() {
            }

            @Generated
            public WirelessUpLinkBuilder txRate(String txRate) {
                this.txRate = txRate;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder rxRate(String rxRate) {
                this.rxRate = rxRate;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder rssi(Integer rssi) {
                this.rssi = rssi;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder rssiPercent(Integer rssiPercent) {
                this.rssiPercent = rssiPercent;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder rxDropPkts(Long rxDropPkts) {
                this.rxDropPkts = rxDropPkts;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder txDropPkts(Long txDropPkts) {
                this.txDropPkts = txDropPkts;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder rxErrPkts(Long rxErrPkts) {
                this.rxErrPkts = rxErrPkts;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder txErrPkts(Long txErrPkts) {
                this.txErrPkts = txErrPkts;
                return this;
            }

            @Generated
            public WirelessUpLinkBuilder snr(Integer snr) {
                this.snr = snr;
                return this;
            }

            @Generated
            public WirelessUpLink build() {
                return new WirelessUpLink(this.txRate, this.rxRate, this.rssi, this.rssiPercent, this.rxDropPkts, this.txDropPkts, this.rxErrPkts, this.txErrPkts, this.snr);
            }

            @Generated
            public String toString() {
                return "ApInfoOpenApiVO.WirelessUpLink.WirelessUpLinkBuilder(txRate=" + this.txRate + ", rxRate=" + this.rxRate + ", rssi=" + this.rssi + ", rssiPercent=" + this.rssiPercent + ", rxDropPkts=" + this.rxDropPkts + ", txDropPkts=" + this.txDropPkts + ", rxErrPkts=" + this.rxErrPkts + ", txErrPkts=" + this.txErrPkts + ", snr=" + this.snr + ")";
            }
        }
    }
}

