/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.api.openapi.vo.healthv2.sub;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.tplink.smb.omada.client.api.openapi.vo.healthv2.time.TimeValueItemVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class CommonSubHealthInfoDetailVO<T extends Number> {
    @Schema(name="summaryScore", description="Sub dimension health score")
    private Integer summaryScore;
    @Schema(name="averageNum", description="Average value of common dimension, such as rssi")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private Integer averageNum;
    @Schema(name="averageNum", description="List of common dimension value, such as rssi")
    private List<TimeValueItemVO<T>> pastNums;

    public static CommonSubHealthInfoDetailVO createNoDataVO(List<Long> timeList) {
        CommonSubHealthInfoDetailVO noDataVO = new CommonSubHealthInfoDetailVO();
        noDataVO.setSummaryScore(null);
        noDataVO.setAverageNum(null);
        List pastNums = timeList.stream().map(time -> TimeValueItemVO.createNullValueVO(time)).collect(Collectors.toList());
        noDataVO.setPastNums(pastNums);
        return noDataVO;
    }

    @Generated
    public static <T extends Number> CommonSubHealthInfoDetailVOBuilder<T> builder() {
        return new CommonSubHealthInfoDetailVOBuilder();
    }

    @Generated
    public Integer getSummaryScore() {
        return this.summaryScore;
    }

    @Generated
    public Integer getAverageNum() {
        return this.averageNum;
    }

    @Generated
    public List<TimeValueItemVO<T>> getPastNums() {
        return this.pastNums;
    }

    @Generated
    public void setSummaryScore(Integer summaryScore) {
        this.summaryScore = summaryScore;
    }

    @Generated
    public void setAverageNum(Integer averageNum) {
        this.averageNum = averageNum;
    }

    @Generated
    public void setPastNums(List<TimeValueItemVO<T>> pastNums) {
        this.pastNums = pastNums;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonSubHealthInfoDetailVO)) {
            return false;
        }
        CommonSubHealthInfoDetailVO other = (CommonSubHealthInfoDetailVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$summaryScore = this.getSummaryScore();
        Integer other$summaryScore = other.getSummaryScore();
        if (this$summaryScore == null ? other$summaryScore != null : !((Object)this$summaryScore).equals(other$summaryScore)) {
            return false;
        }
        Integer this$averageNum = this.getAverageNum();
        Integer other$averageNum = other.getAverageNum();
        if (this$averageNum == null ? other$averageNum != null : !((Object)this$averageNum).equals(other$averageNum)) {
            return false;
        }
        List<TimeValueItemVO<T>> this$pastNums = this.getPastNums();
        List<TimeValueItemVO<T>> other$pastNums = other.getPastNums();
        return !(this$pastNums == null ? other$pastNums != null : !((Object)this$pastNums).equals(other$pastNums));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommonSubHealthInfoDetailVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $summaryScore = this.getSummaryScore();
        result = result * 59 + ($summaryScore == null ? 43 : ((Object)$summaryScore).hashCode());
        Integer $averageNum = this.getAverageNum();
        result = result * 59 + ($averageNum == null ? 43 : ((Object)$averageNum).hashCode());
        List<TimeValueItemVO<T>> $pastNums = this.getPastNums();
        result = result * 59 + ($pastNums == null ? 43 : ((Object)$pastNums).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommonSubHealthInfoDetailVO(super=" + super.toString() + ", summaryScore=" + this.getSummaryScore() + ", averageNum=" + this.getAverageNum() + ", pastNums=" + this.getPastNums() + ")";
    }

    @Generated
    public CommonSubHealthInfoDetailVO() {
    }

    @Generated
    public CommonSubHealthInfoDetailVO(Integer summaryScore, Integer averageNum, List<TimeValueItemVO<T>> pastNums) {
        this.summaryScore = summaryScore;
        this.averageNum = averageNum;
        this.pastNums = pastNums;
    }

    @Generated
    public static class CommonSubHealthInfoDetailVOBuilder<T extends Number> {
        @Generated
        private Integer summaryScore;
        @Generated
        private Integer averageNum;
        @Generated
        private List<TimeValueItemVO<T>> pastNums;

        @Generated
        CommonSubHealthInfoDetailVOBuilder() {
        }

        @Generated
        public CommonSubHealthInfoDetailVOBuilder<T> summaryScore(Integer summaryScore) {
            this.summaryScore = summaryScore;
            return this;
        }

        @Generated
        public CommonSubHealthInfoDetailVOBuilder<T> averageNum(Integer averageNum) {
            this.averageNum = averageNum;
            return this;
        }

        @Generated
        public CommonSubHealthInfoDetailVOBuilder<T> pastNums(List<TimeValueItemVO<T>> pastNums) {
            this.pastNums = pastNums;
            return this;
        }

        @Generated
        public CommonSubHealthInfoDetailVO<T> build() {
            return new CommonSubHealthInfoDetailVO<T>(this.summaryScore, this.averageNum, this.pastNums);
        }

        @Generated
        public String toString() {
            return "CommonSubHealthInfoDetailVO.CommonSubHealthInfoDetailVOBuilder(summaryScore=" + this.summaryScore + ", averageNum=" + this.averageNum + ", pastNums=" + this.pastNums + ")";
        }
    }
}

