/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.api.openapi.vo;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.cache.FilterMapCache;
import com.tplink.smb.omada.common.cache.h;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import com.tplink.smb.omada.common.gridquery.b;
import com.tplink.smb.omada.common.gridquery.e;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;

@Schema(name="Client Grid Query")
public class ClientQueryOpenApiVO {
    @Schema(name="currentPage", description="Query page of clients")
    private int currentPage = 0;
    @Schema(name="currentPageSize", description="Query page size of clients")
    private int currentPageSize = 0;
    @Schema(name="sorts", description="Query page of clients")
    private LinkedHashMap<String, String> sorts;
    @Schema(name="searchKey", description="Query page of clients")
    private String searchKey;
    @Schema(name="filters", description="Query page of clients")
    @a(e=true)
    private Map<String, Object> filters;
    @Schema(name="searchField", description="Query page of clients")
    @Nullable
    private String searchField;

    public static b transQueryDataWithSort(QueryDataVO queryDataVO, String sortMapKey) {
        return ClientQueryOpenApiVO.transQueryDataWithSortAndFilter(queryDataVO, sortMapKey, null);
    }

    public static b transQueryDataWithSortAndFilter(QueryDataVO queryDataVO, String sortMapKey, String filterMapKey) {
        b queryData = new b();
        queryData.a(queryDataVO.getCurrentPage() == 0 ? 1 : queryDataVO.getCurrentPage());
        queryData.b(queryDataVO.getCurrentPageSize() == 0 ? 10 : queryDataVO.getCurrentPageSize());
        queryData.c(queryDataVO.getSearchKey());
        if (!StringUtils.isBlank((CharSequence)queryDataVO.getSearchField())) {
            List searchFields = Lists.newArrayList((Object[])queryDataVO.getSearchField().split(",")).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            queryData.a(searchFields.isEmpty() ? null : searchFields);
        }
        if (sortMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty((Map)queryDataVO.getSorts())) {
            Map sortMap = h.a((String)sortMapKey);
            queryDataVO.getSorts().forEach((key, direction) -> {
                if (sortMap.get(key) != null) {
                    queryData.a(new e((String)sortMap.get(key), direction));
                }
            });
        }
        if (filterMapKey == null) {
            return queryData;
        }
        if (!CollectionUtils.isEmpty((Map)queryDataVO.getFilters())) {
            Map filterMap = FilterMapCache.a((String)filterMapKey);
            queryDataVO.getFilters().forEach((key, value) -> {
                FilterMapCache.FilterKeyItem item = (FilterMapCache.FilterKeyItem)filterMap.get(key);
                if (item != null) {
                    switch (item.getType()) {
                        case NUMBER: {
                            Number number = NumberUtils.createNumber((String)value.toString());
                            queryData.a(item.getKey(), (Object)number);
                            break;
                        }
                        case BOOLEAN: {
                            queryData.a(item.getKey(), (Object)Boolean.valueOf(value.toString()));
                            break;
                        }
                        default: {
                            queryData.a(item.getKey(), (Object)value.toString());
                        }
                    }
                }
            });
        }
        return queryData;
    }

    public static b transQueryData(QueryDataVO queryDataVO) {
        return ClientQueryOpenApiVO.transQueryDataWithSortAndFilter(queryDataVO, null, null);
    }

    public boolean noNeedPagingQuery() {
        return this.currentPage == 0 && this.currentPageSize == 0;
    }

    @Nullable
    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(@Nullable String searchField) {
        this.searchField = searchField;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public LinkedHashMap<String, String> getSorts() {
        return this.sorts;
    }

    public void setSorts(LinkedHashMap<String, String> sorts) {
        this.sorts = sorts;
    }

    public int getCurrentPageSize() {
        return this.currentPageSize;
    }

    public void setCurrentPageSize(int currentPageSize) {
        this.currentPageSize = currentPageSize;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    @Generated
    public String toString() {
        return "ClientQueryOpenApiVO(currentPage=" + this.getCurrentPage() + ", currentPageSize=" + this.getCurrentPageSize() + ", sorts=" + this.getSorts() + ", searchKey=" + this.getSearchKey() + ", filters=" + this.getFilters() + ", searchField=" + this.getSearchField() + ")";
    }
}

