/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.api.openapi.vo;

import com.tplink.smb.omada.client.api.openapi.vo.ClientQueryFiltersOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Map;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ClientQueryDataOpenApiVO {
    @NotNull(message="page should not be null.")
    @Range(min=1L, message="page should not be less than 1.")
    @Schema(name="page", description="Start from 1.")
    private @NotNull(message="page should not be null.") @Range(min=1L, message="page should not be less than 1.") Integer page;
    @NotNull(message="pageSize should not be null.")
    @Range(min=1L, max=1000L, message="pageSize should between 1 and 1000.")
    @Schema(name="pageSize", description="It should be within the range of 1\u20131000.")
    private @NotNull(message="pageSize should not be null.") @Range(min=1L, max=1000L, message="pageSize should between 1 and 1000.") Integer pageSize;
    @Size(max=1, message="sort should not be more than 1.")
    @Schema(name="sorts", description="Sort rule, key: sort field, value: sort direction, value parameter may be one of asc or desc.Optional parameter.")
    private @Size(max=1, message="sort should not be more than 1.") Map<String, String> sorts;
    @Size(min=1, max=128, message="searchKey length should between 1 and 128.")
    @Schema(name="searchKey", description="Fuzzy query parameters, support field name, mac, ip.")
    private @Size(min=1, max=128, message="searchKey length should between 1 and 128.") String searchKey;
    @Valid
    @Schema(name="filters", description="Filters of the query.")
    private ClientQueryFiltersOpenApiVO filters;
    @Range(min=0L, max=3L, message="Parameter [scope] should between 0 and 3 for 0: all, 1: online(default), 2:offline, 3:blocked.")
    @Schema(name="scope", description="Scope of clients to query, 0: all, 1: online(default), 2:offline, 3:blocked.")
    private @Range(min=0L, max=3L, message="Parameter [scope] should between 0 and 3 for 0: all, 1: online(default), 2:offline, 3:blocked.") Integer scope;

    @Generated
    public Integer getPage() {
        return this.page;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Map<String, String> getSorts() {
        return this.sorts;
    }

    @Generated
    public String getSearchKey() {
        return this.searchKey;
    }

    @Generated
    public ClientQueryFiltersOpenApiVO getFilters() {
        return this.filters;
    }

    @Generated
    public Integer getScope() {
        return this.scope;
    }

    @Generated
    public void setPage(Integer page) {
        this.page = page;
    }

    @Generated
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setSorts(Map<String, String> sorts) {
        this.sorts = sorts;
    }

    @Generated
    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    @Generated
    public void setFilters(ClientQueryFiltersOpenApiVO filters) {
        this.filters = filters;
    }

    @Generated
    public void setScope(Integer scope) {
        this.scope = scope;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientQueryDataOpenApiVO)) {
            return false;
        }
        ClientQueryDataOpenApiVO other = (ClientQueryDataOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$scope = this.getScope();
        Integer other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        Map<String, String> this$sorts = this.getSorts();
        Map<String, String> other$sorts = other.getSorts();
        if (this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts)) {
            return false;
        }
        String this$searchKey = this.getSearchKey();
        String other$searchKey = other.getSearchKey();
        if (this$searchKey == null ? other$searchKey != null : !this$searchKey.equals(other$searchKey)) {
            return false;
        }
        ClientQueryFiltersOpenApiVO this$filters = this.getFilters();
        ClientQueryFiltersOpenApiVO other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientQueryDataOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        Map<String, String> $sorts = this.getSorts();
        result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
        String $searchKey = this.getSearchKey();
        result = result * 59 + ($searchKey == null ? 43 : $searchKey.hashCode());
        ClientQueryFiltersOpenApiVO $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientQueryDataOpenApiVO(page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", sorts=" + this.getSorts() + ", searchKey=" + this.getSearchKey() + ", filters=" + this.getFilters() + ", scope=" + this.getScope() + ")";
    }

    @Generated
    public ClientQueryDataOpenApiVO() {
    }
}

