/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.api.openapi.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.client.api.openapi.vo.AuthInfoOpenApiVO;
import com.tplink.smb.omada.client.api.web.vo.ClientIpSettingVO;
import com.tplink.smb.omada.client.api.web.vo.ClientLockToApDetailVO;
import com.tplink.smb.omada.client.api.web.vo.ClientRateLimitSettingVO;
import com.tplink.smb.omada.client.api.web.vo.MultiLinkItemVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@Schema(name="Client Detail")
public class ClientDetailOpenApiVO {
    @Schema(name="id", description="Client ID.")
    private String id;
    @Schema(name="mac", description="Client MAC Address.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(name="name", description="Client Name, alias.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String name;
    @Schema(name="hostName", description="Host name, device name.")
    private String hostName;
    @Schema(name="vendor", description="Vendor.")
    private String vendor;
    @Schema(name="deviceType", description="Device Type: iphone, ipod, android, pc, printer, tv...")
    private String deviceType;
    @Schema(name="deviceCategory", description="Device Category: loT, TV, computer, phone...")
    private String deviceCategory;
    @Schema(name="osName", description="Device system version.")
    private String osName;
    @Schema(name="model", description="Model of client device.")
    private String model;
    @Schema(name="ip", description="IP Address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ip;
    @Schema(name="ipv6List", description="IPv6 Address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private List<String> ipv6List;
    @Schema(name="connectType", description="Connect type should be a value as follows: 0: wireless guest; 1: wireless user; 2: wired user.")
    private Integer connectType;
    @Schema(name="connectDevType", description="connect device type should be a value as follows: ap, switch, gateway.")
    private String connectDevType;
    @Schema(name="connectedToWirelessRouter", description="true: Client is connecting to a wireless router.")
    private Boolean connectedToWirelessRouter;
    @Schema(name="wireless", description="true: Wireless device (connectDevType=ap);  false: Not wireless device(connectDevType=switch or gateway)")
    private Boolean wireless;
    @Schema(name="ssid", description="(Wireless)  SSID name.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String ssid;
    @Schema(name="signalLevel", description="(Wireless) Signal strength percentage should be within the range of 0-100.")
    private Integer signalLevel;
    @Schema(name="signalRank", description="(Wireless) Signal strength level should be within the range of 0-5.")
    private Integer signalRank;
    @Schema(name="wifiMode", description="(Wireless) Wifi mode should be a value as follows: 0: 11a; 1: 11b; 2: 11g; 3: 11na; 4: 11ng; 5: 11ac; 6: 11axa; 7: 11axg; 8: 11beg; 9: 11bea.")
    private Integer wifiMode;
    @Schema(name="apName", description="(Wireless)  AP Name.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String apName;
    @Schema(name="apMac", description="(Wireless)  AP MAC Address.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String apMac;
    @Schema(name="radioId", description="(Wireless) Radio ID should be a value as follows: 0: 2.4GHz; 1: 5GHz-1; 2:5GHz-2; 3: 6GHz.")
    private Integer radioId;
    @Schema(name="channel", description="(Wireless)  Actual channel.")
    private Integer channel;
    @Schema(name="rxRate", description="(Wireless) Uplink negotiation rate (Kbit/s).")
    private Long rxRate;
    @Schema(name="txRate", description="(Wireless) Downlink negotiation rate (Kbit/s).")
    private Long txRate;
    @Schema(name="powerSave", description="(Wireless)  true: Power save mode enabled.")
    private Boolean powerSave;
    @Schema(name="rssi", description="(Wireless) Signal strength, unit: dBm.")
    private Integer rssi;
    @Schema(name="snr", description="(Wireless) Signal Noise Ratio.")
    private Integer snr;
    @Schema(name="switchMac", description="(Wired, connectDevType=switch)  Switch MAC address.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String switchMac;
    @Schema(name="switchName", description="(Wired, connectDevType=switch)  Switch name.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String switchName;
    @Schema(name="gatewayMac", description="(Wired, connectDevType=gateway)  Gateway MAC Address.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String gatewayMac;
    @Schema(name="gatewayName", description="(Wired, connectDevType=gateway)  Gateway name.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String gatewayName;
    @Schema(name="vid", description="(Wired) vlan.")
    private Integer vid;
    @Schema(name="networkName", description="(Wired) Network name.")
    private String networkName;
    @Schema(name="dot1xIdentity", description="(Wired) 802.1x authentication identity.")
    private String dot1xIdentity;
    @Schema(name="dot1xVlan", description="(Wired) Network name corresponding to the VLAN obtained by 802.1x D-VLAN.")
    private Integer dot1xVlan;
    @Schema(name="port", description="(Wired) Port ID.")
    private Integer port;
    @Schema(name="lagId", description="(Wired) LAG ID. Exists only when the client is connected to the LAG.")
    private Integer lagId;
    @Schema(name="activity", description="Real-time downlink rate (Byte/s).")
    private Long activity;
    @Schema(name="uploadActivity", description="Real-time downlink rate (Byte/s).")
    private Long uploadActivity;
    @Schema(name="trafficDown", description="Downstream traffic (Byte).")
    private Long trafficDown;
    @Schema(name="trafficUp", description="Upstream traffic (Byte).")
    private Long trafficUp;
    @Schema(name="uptime", description="Up time (unit: s).")
    private Long uptime;
    @Schema(name="lastSeen", description="Last found time, timestamp (ms).")
    private Long lastSeen;
    @Schema(name="authStatus", description="Authentication status should be a value as follows: 0: CONNECTED // Access without any authentication method; 1: PENDING // Access to Portal, but authentication failed; 2: AUTHORIZED // Pass through portal, pass other authentication without portal; 3: AUTH-FREE // No portal authentication required.")
    private Integer authStatus;
    @Schema(name="blocked", description="Whether the client is blocked.")
    private Boolean blocked;
    @Schema(name="guest", description="(Wireless) Whether it is Guest (used to display the wireless Guest client icon).")
    private Boolean guest;
    @Schema(name="active", description="Whether the client is online.")
    private Boolean active;
    @Schema(name="manager", description="Whether it is the client currently being managed.")
    private Boolean manager;
    @Schema(name="ipSetting", description="Client IP setting.")
    private ClientIpSettingVO ipSetting;
    @Schema(name="downPacket", description="Number of downstream packets.")
    private Long downPacket;
    @Schema(name="upPacket", description="Number of upstream packets.")
    private Long upPacket;
    @Schema(name="rateLimit", description="RateLimit setting.")
    private ClientRateLimitSettingVO rateLimit;
    @Schema(name="clientLockToApSetting", description="Client lock to ap setting.")
    private ClientLockToApDetailVO clientLockToApSetting;
    @Schema(name="multiLink", description="(Wireless) Client multifrequency info list.")
    private List<MultiLinkItemVO> multiLink;
    @Schema(name="unit", description="Unit ID.")
    private Integer unit;
    @Schema(name="standardPort", description="Standard port.")
    private String standardPort;
    @Schema(name="blockDisable", description="Block client disabled, default value: false")
    private Boolean blockDisable;
    @Schema(name="dhcpLeaseTime", description="DHCP lease time, unit seconds")
    private Long dhcpLeaseTime;
    @Schema(name="systemName", description="Device system name.")
    private String systemName;
    @Schema(name="description", description="Device description.")
    private String description;
    @Schema(name="capabilities", description="One or more of the following values: Station\u3001DOCSIS cable device\u3001Telephone\u3001Router\u3001WLAN access point\u3001Bridge\u3001Repeater\u3001other.")
    private List<String> capabilities;
    @Valid
    @Schema(name="authInfo", description="Client portal authentication information")
    private List<AuthInfoOpenApiVO> authInfo;

    public ClientDetailOpenApiVO setSignalLevel(Integer signalLevel) {
        this.signalLevel = signalLevel;
        this.signalRank = this.signalLevel == null || this.signalLevel == 0 ? 0 : (this.signalLevel - 1) / 20 + 1;
        return this;
    }

    public ClientDetailOpenApiVO setManagerAndHandleAuthstatus(boolean isManager) {
        this.manager = isManager;
        if (isManager && Objects.equals(this.authStatus, 1)) {
            this.authStatus = 3;
        }
        return this;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public String getVendor() {
        return this.vendor;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public String getDeviceCategory() {
        return this.deviceCategory;
    }

    @Generated
    public String getOsName() {
        return this.osName;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<String> getIpv6List() {
        return this.ipv6List;
    }

    @Generated
    public Integer getConnectType() {
        return this.connectType;
    }

    @Generated
    public String getConnectDevType() {
        return this.connectDevType;
    }

    @Generated
    public Boolean getConnectedToWirelessRouter() {
        return this.connectedToWirelessRouter;
    }

    @Generated
    public Boolean getWireless() {
        return this.wireless;
    }

    @Generated
    public String getSsid() {
        return this.ssid;
    }

    @Generated
    public Integer getSignalLevel() {
        return this.signalLevel;
    }

    @Generated
    public Integer getSignalRank() {
        return this.signalRank;
    }

    @Generated
    public Integer getWifiMode() {
        return this.wifiMode;
    }

    @Generated
    public String getApName() {
        return this.apName;
    }

    @Generated
    public String getApMac() {
        return this.apMac;
    }

    @Generated
    public Integer getRadioId() {
        return this.radioId;
    }

    @Generated
    public Integer getChannel() {
        return this.channel;
    }

    @Generated
    public Long getRxRate() {
        return this.rxRate;
    }

    @Generated
    public Long getTxRate() {
        return this.txRate;
    }

    @Generated
    public Boolean getPowerSave() {
        return this.powerSave;
    }

    @Generated
    public Integer getRssi() {
        return this.rssi;
    }

    @Generated
    public Integer getSnr() {
        return this.snr;
    }

    @Generated
    public String getSwitchMac() {
        return this.switchMac;
    }

    @Generated
    public String getSwitchName() {
        return this.switchName;
    }

    @Generated
    public String getGatewayMac() {
        return this.gatewayMac;
    }

    @Generated
    public String getGatewayName() {
        return this.gatewayName;
    }

    @Generated
    public Integer getVid() {
        return this.vid;
    }

    @Generated
    public String getNetworkName() {
        return this.networkName;
    }

    @Generated
    public String getDot1xIdentity() {
        return this.dot1xIdentity;
    }

    @Generated
    public Integer getDot1xVlan() {
        return this.dot1xVlan;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Integer getLagId() {
        return this.lagId;
    }

    @Generated
    public Long getActivity() {
        return this.activity;
    }

    @Generated
    public Long getUploadActivity() {
        return this.uploadActivity;
    }

    @Generated
    public Long getTrafficDown() {
        return this.trafficDown;
    }

    @Generated
    public Long getTrafficUp() {
        return this.trafficUp;
    }

    @Generated
    public Long getUptime() {
        return this.uptime;
    }

    @Generated
    public Long getLastSeen() {
        return this.lastSeen;
    }

    @Generated
    public Integer getAuthStatus() {
        return this.authStatus;
    }

    @Generated
    public Boolean getBlocked() {
        return this.blocked;
    }

    @Generated
    public Boolean getGuest() {
        return this.guest;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Boolean getManager() {
        return this.manager;
    }

    @Generated
    public ClientIpSettingVO getIpSetting() {
        return this.ipSetting;
    }

    @Generated
    public Long getDownPacket() {
        return this.downPacket;
    }

    @Generated
    public Long getUpPacket() {
        return this.upPacket;
    }

    @Generated
    public ClientRateLimitSettingVO getRateLimit() {
        return this.rateLimit;
    }

    @Generated
    public ClientLockToApDetailVO getClientLockToApSetting() {
        return this.clientLockToApSetting;
    }

    @Generated
    public List<MultiLinkItemVO> getMultiLink() {
        return this.multiLink;
    }

    @Generated
    public Integer getUnit() {
        return this.unit;
    }

    @Generated
    public String getStandardPort() {
        return this.standardPort;
    }

    @Generated
    public Boolean getBlockDisable() {
        return this.blockDisable;
    }

    @Generated
    public Long getDhcpLeaseTime() {
        return this.dhcpLeaseTime;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getCapabilities() {
        return this.capabilities;
    }

    @Generated
    public List<AuthInfoOpenApiVO> getAuthInfo() {
        return this.authInfo;
    }

    @Generated
    public ClientDetailOpenApiVO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setDeviceCategory(String deviceCategory) {
        this.deviceCategory = deviceCategory;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setOsName(String osName) {
        this.osName = osName;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setModel(String model) {
        this.model = model;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setIpv6List(List<String> ipv6List) {
        this.ipv6List = ipv6List;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setConnectType(Integer connectType) {
        this.connectType = connectType;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setConnectDevType(String connectDevType) {
        this.connectDevType = connectDevType;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setConnectedToWirelessRouter(Boolean connectedToWirelessRouter) {
        this.connectedToWirelessRouter = connectedToWirelessRouter;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setWireless(Boolean wireless) {
        this.wireless = wireless;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setSsid(String ssid) {
        this.ssid = ssid;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setSignalRank(Integer signalRank) {
        this.signalRank = signalRank;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setWifiMode(Integer wifiMode) {
        this.wifiMode = wifiMode;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setApName(String apName) {
        this.apName = apName;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setApMac(String apMac) {
        this.apMac = apMac;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setRadioId(Integer radioId) {
        this.radioId = radioId;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setChannel(Integer channel) {
        this.channel = channel;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setRxRate(Long rxRate) {
        this.rxRate = rxRate;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setTxRate(Long txRate) {
        this.txRate = txRate;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setPowerSave(Boolean powerSave) {
        this.powerSave = powerSave;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setRssi(Integer rssi) {
        this.rssi = rssi;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setSnr(Integer snr) {
        this.snr = snr;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setSwitchMac(String switchMac) {
        this.switchMac = switchMac;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setSwitchName(String switchName) {
        this.switchName = switchName;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setGatewayMac(String gatewayMac) {
        this.gatewayMac = gatewayMac;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setVid(Integer vid) {
        this.vid = vid;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setNetworkName(String networkName) {
        this.networkName = networkName;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setDot1xIdentity(String dot1xIdentity) {
        this.dot1xIdentity = dot1xIdentity;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setDot1xVlan(Integer dot1xVlan) {
        this.dot1xVlan = dot1xVlan;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setPort(Integer port) {
        this.port = port;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setLagId(Integer lagId) {
        this.lagId = lagId;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setActivity(Long activity) {
        this.activity = activity;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setUploadActivity(Long uploadActivity) {
        this.uploadActivity = uploadActivity;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setTrafficDown(Long trafficDown) {
        this.trafficDown = trafficDown;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setTrafficUp(Long trafficUp) {
        this.trafficUp = trafficUp;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setUptime(Long uptime) {
        this.uptime = uptime;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setBlocked(Boolean blocked) {
        this.blocked = blocked;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setGuest(Boolean guest) {
        this.guest = guest;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setActive(Boolean active) {
        this.active = active;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setManager(Boolean manager) {
        this.manager = manager;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setIpSetting(ClientIpSettingVO ipSetting) {
        this.ipSetting = ipSetting;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setDownPacket(Long downPacket) {
        this.downPacket = downPacket;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setUpPacket(Long upPacket) {
        this.upPacket = upPacket;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setRateLimit(ClientRateLimitSettingVO rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setClientLockToApSetting(ClientLockToApDetailVO clientLockToApSetting) {
        this.clientLockToApSetting = clientLockToApSetting;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setMultiLink(List<MultiLinkItemVO> multiLink) {
        this.multiLink = multiLink;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setUnit(Integer unit) {
        this.unit = unit;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setStandardPort(String standardPort) {
        this.standardPort = standardPort;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setBlockDisable(Boolean blockDisable) {
        this.blockDisable = blockDisable;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setDhcpLeaseTime(Long dhcpLeaseTime) {
        this.dhcpLeaseTime = dhcpLeaseTime;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setSystemName(String systemName) {
        this.systemName = systemName;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @Generated
    public ClientDetailOpenApiVO setAuthInfo(List<AuthInfoOpenApiVO> authInfo) {
        this.authInfo = authInfo;
        return this;
    }

    @Generated
    public String toString() {
        return "ClientDetailOpenApiVO(id=" + this.getId() + ", mac=" + this.getMac() + ", name=" + this.getName() + ", hostName=" + this.getHostName() + ", vendor=" + this.getVendor() + ", deviceType=" + this.getDeviceType() + ", deviceCategory=" + this.getDeviceCategory() + ", osName=" + this.getOsName() + ", model=" + this.getModel() + ", ip=" + this.getIp() + ", ipv6List=" + this.getIpv6List() + ", connectType=" + this.getConnectType() + ", connectDevType=" + this.getConnectDevType() + ", connectedToWirelessRouter=" + this.getConnectedToWirelessRouter() + ", wireless=" + this.getWireless() + ", ssid=" + this.getSsid() + ", signalLevel=" + this.getSignalLevel() + ", signalRank=" + this.getSignalRank() + ", wifiMode=" + this.getWifiMode() + ", apName=" + this.getApName() + ", apMac=" + this.getApMac() + ", radioId=" + this.getRadioId() + ", channel=" + this.getChannel() + ", rxRate=" + this.getRxRate() + ", txRate=" + this.getTxRate() + ", powerSave=" + this.getPowerSave() + ", rssi=" + this.getRssi() + ", snr=" + this.getSnr() + ", switchMac=" + this.getSwitchMac() + ", switchName=" + this.getSwitchName() + ", gatewayMac=" + this.getGatewayMac() + ", gatewayName=" + this.getGatewayName() + ", vid=" + this.getVid() + ", networkName=" + this.getNetworkName() + ", dot1xIdentity=" + this.getDot1xIdentity() + ", dot1xVlan=" + this.getDot1xVlan() + ", port=" + this.getPort() + ", lagId=" + this.getLagId() + ", activity=" + this.getActivity() + ", uploadActivity=" + this.getUploadActivity() + ", trafficDown=" + this.getTrafficDown() + ", trafficUp=" + this.getTrafficUp() + ", uptime=" + this.getUptime() + ", lastSeen=" + this.getLastSeen() + ", authStatus=" + this.getAuthStatus() + ", blocked=" + this.getBlocked() + ", guest=" + this.getGuest() + ", active=" + this.getActive() + ", manager=" + this.getManager() + ", ipSetting=" + this.getIpSetting() + ", downPacket=" + this.getDownPacket() + ", upPacket=" + this.getUpPacket() + ", rateLimit=" + this.getRateLimit() + ", clientLockToApSetting=" + this.getClientLockToApSetting() + ", multiLink=" + this.getMultiLink() + ", unit=" + this.getUnit() + ", standardPort=" + this.getStandardPort() + ", blockDisable=" + this.getBlockDisable() + ", dhcpLeaseTime=" + this.getDhcpLeaseTime() + ", systemName=" + this.getSystemName() + ", description=" + this.getDescription() + ", capabilities=" + this.getCapabilities() + ", authInfo=" + this.getAuthInfo() + ")";
    }
}

